/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.DataBufferReferrer;

public class SimpleDataBufferFactory
implements DataBufferFactory {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private static Thread tracedThread = null;
    private DataBuffer fFreeBuffers;
    private DataBufferReferrerQueue fReferrers;
    private DataBufferActiveQueue fActiveBuffers;
    private int activeCount;
    private static int fgIdCounter;

    public SimpleDataBufferFactory() {
        if (DEBUG && tracedThread == null && Thread.currentThread().getName().startsWith("WebContainer")) {
            tracedThread = Thread.currentThread();
        }
        this.fReferrers = new DataBufferReferrerQueue();
        this.fActiveBuffers = new DataBufferActiveQueue();
    }

    public DataBuffer createBuffer() {
        DataBuffer dataBuffer = this.fFreeBuffers;
        if (dataBuffer != null) {
            this.fFreeBuffers = dataBuffer.next;
            dataBuffer.next = null;
        } else {
            dataBuffer = new DataBuffer(this);
            dataBuffer.id = ++fgIdCounter;
        }
        if (DEBUG && tracedThread == Thread.currentThread()) {
            System.err.println("***XLXP*** SimpleDBF: allocated buffer " + dataBuffer.id);
        }
        this.fActiveBuffers.add(dataBuffer);
        ++this.activeCount;
        return dataBuffer;
    }

    public void freeBuffer(DataBuffer dataBuffer) {
        this.fActiveBuffers.remove(dataBuffer);
        --this.activeCount;
        dataBuffer.next = this.fFreeBuffers;
        this.fFreeBuffers = dataBuffer;
    }

    public void addReferrer(DataBufferReferrer dataBufferReferrer) {
        this.fReferrers.add(dataBufferReferrer);
    }

    public void removeReferrer(DataBufferReferrer dataBufferReferrer) {
        this.fReferrers.remove(dataBufferReferrer);
    }

    public boolean isReferenced(DataBuffer dataBuffer) {
        return this.fReferrers.isReferenced(dataBuffer);
    }

    public void reset(boolean bl) {
        if (DEBUG && tracedThread == Thread.currentThread()) {
            System.err.println("***XLXP*** SimpleDBF: reset()");
        }
        this.reclaimBuffers(0);
        if (!bl) {
            this.fFreeBuffers = null;
        }
    }

    public void reclaimBuffers(int n) {
        boolean bl;
        if (this.activeCount < n) {
            return;
        }
        boolean bl2 = bl = DEBUG && tracedThread == Thread.currentThread();
        if (bl) {
            System.err.println("***XLXP*** SimpleDBF: reclaimBuffers: activeCount is " + this.activeCount + ", " + this.fReferrers.totalReferrers() + " referrers, " + this.fReferrers.activeReferrers() + " are active");
        }
        DataBuffer dataBuffer = this.fActiveBuffers.first();
        while (dataBuffer != null) {
            if (!this.fReferrers.isReferenced(dataBuffer)) {
                if (dataBuffer.activePrev.next == dataBuffer) {
                    dataBuffer.activePrev.next = null;
                }
                DataBuffer dataBuffer2 = this.fActiveBuffers.remove(dataBuffer);
                --this.activeCount;
                if (bl) {
                    System.err.println("***XLXP*** SimpleDBF: reclaimBuffers reclaiming buffer " + dataBuffer.id);
                }
                dataBuffer.next = this.fFreeBuffers;
                this.fFreeBuffers = dataBuffer;
                dataBuffer = dataBuffer2;
                continue;
            }
            dataBuffer = this.fActiveBuffers.next(dataBuffer);
        }
        if (bl) {
            System.err.println("***XLXP*** SimpleDBF: reclaimBuffers: activeCount now " + this.activeCount);
            if (this.activeCount > 0) {
                this.activeCount += 0;
            }
        }
    }

    class DataBufferActiveQueue {
        DataBuffer head;

        DataBufferActiveQueue() {
            this.head.activePrev = this.head.activeNext = (this.head = new DataBuffer(SimpleDataBufferFactory.this));
        }

        void add(DataBuffer dataBuffer) {
            DataBuffer dataBuffer2 = this.head.activePrev;
            dataBuffer.activeNext = dataBuffer2.activeNext;
            dataBuffer.activePrev = dataBuffer2;
            dataBuffer2.activeNext = dataBuffer;
            this.head.activePrev = dataBuffer;
        }

        DataBuffer remove(DataBuffer dataBuffer) {
            DataBuffer dataBuffer2;
            dataBuffer.activePrev.activeNext = dataBuffer2 = dataBuffer.activeNext;
            dataBuffer2.activePrev = dataBuffer.activePrev;
            dataBuffer.activeNext = null;
            dataBuffer.activePrev = null;
            return dataBuffer2 != this.head ? dataBuffer2 : null;
        }

        DataBuffer first() {
            return this.head.activeNext != this.head ? this.head.activeNext : null;
        }

        DataBuffer next(DataBuffer dataBuffer) {
            return dataBuffer.activeNext != this.head ? dataBuffer.activeNext : null;
        }
    }

    class DataBufferReferrerQueue {
        DataBufferReferrer head;

        DataBufferReferrerQueue() {
            this.head.prev = this.head.next = (this.head = new DataBufferReferrer(this){
                private final /* synthetic */ DataBufferReferrerQueue this$1;
                {
                    this.this$1 = dataBufferReferrerQueue;
                }

                public boolean hasReferenceTo(DataBuffer dataBuffer) {
                    return false;
                }
            });
        }

        private int totalReferrers() {
            DataBufferReferrer dataBufferReferrer = this.head.next;
            int n = 0;
            while (dataBufferReferrer != this.head) {
                ++n;
                dataBufferReferrer = dataBufferReferrer.next;
            }
            return n;
        }

        private int activeReferrers() {
            DataBufferReferrer dataBufferReferrer = this.head.next;
            int n = 0;
            while (dataBufferReferrer != this.head) {
                if (dataBufferReferrer.active) {
                    ++n;
                }
                dataBufferReferrer = dataBufferReferrer.next;
            }
            return n;
        }

        boolean isReferenced(DataBuffer dataBuffer) {
            DataBufferReferrer dataBufferReferrer = this.head.next;
            int n = 0;
            boolean bl = DEBUG && tracedThread == Thread.currentThread();
            while (dataBufferReferrer != this.head) {
                DataBufferReferrer dataBufferReferrer2 = dataBufferReferrer.next;
                if (dataBufferReferrer.active && dataBufferReferrer.hasReferenceTo(dataBuffer)) {
                    if (bl) {
                        if (VERBOSE) {
                            if (n == 0) {
                                System.err.println("***XLXP*** SimpleDBF.DBRQ: referenced buffer " + dataBuffer.id);
                            }
                            System.err.println("***XLXP*** SimpleDBF.DBRQ:     referred to by " + dataBufferReferrer);
                        }
                        ++n;
                    }
                    ++dataBufferReferrer.hits;
                    if (dataBufferReferrer != this.head.next && dataBufferReferrer.hits > dataBufferReferrer.prev.hits) {
                        this.moveToFront(dataBufferReferrer);
                    }
                    if (!bl) {
                        return true;
                    }
                }
                dataBufferReferrer = dataBufferReferrer2;
            }
            if (bl) {
                if (n > 0 && bl && !VERBOSE) {
                    System.err.println("***XLXP*** SimpleDBF.DBRQ: referenced buffer " + dataBuffer.id + " had " + n + " active referrers");
                }
                return n > 0;
            }
            return false;
        }

        void moveToFront(DataBufferReferrer dataBufferReferrer) {
            DataBufferReferrer dataBufferReferrer2;
            this.remove(dataBufferReferrer);
            dataBufferReferrer.next = dataBufferReferrer2 = this.head.next;
            dataBufferReferrer.prev = this.head;
            dataBufferReferrer2.prev = dataBufferReferrer;
            this.head.next = dataBufferReferrer;
        }

        void add(DataBufferReferrer dataBufferReferrer) {
            DataBufferReferrer dataBufferReferrer2 = this.head.prev;
            dataBufferReferrer.next = this.head;
            dataBufferReferrer.prev = dataBufferReferrer2;
            dataBufferReferrer2.next = dataBufferReferrer;
            this.head.prev = dataBufferReferrer;
        }

        void remove(DataBufferReferrer dataBufferReferrer) {
            dataBufferReferrer.prev.next = dataBufferReferrer.next;
            dataBufferReferrer.next.prev = dataBufferReferrer.prev;
            dataBufferReferrer.next = null;
            dataBufferReferrer.prev = null;
        }
    }
}

