/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.serializer;

import com.ibm.xml.xlxp.api.stax.serializer.Encoding;
import com.ibm.xml.xlxp.api.stax.serializer.StAXWriter;
import com.ibm.xml.xlxp.api.stax.serializer.Windows125XEncoding;
import com.ibm.xml.xlxp.api.util.UnsynchronizedBag;
import java.io.IOException;
import java.io.OutputStream;

public final class Windows125XWriter
extends StAXWriter {
    private static final ThreadLocal fInstances = new ThreadLocal(){

        public Object initialValue() {
            return new UnsynchronizedBag();
        }
    };
    private int[] fEncodableCharacters;
    private int[] fEncodedCharacters;

    private static final UnsynchronizedBag getPool() {
        return (UnsynchronizedBag)fInstances.get();
    }

    public static final Windows125XWriter getInstance() {
        Windows125XWriter windows125XWriter;
        UnsynchronizedBag unsynchronizedBag = Windows125XWriter.getPool();
        int n = 0;
        while (n < unsynchronizedBag.size) {
            windows125XWriter = (Windows125XWriter)unsynchronizedBag.array[n].get();
            if (windows125XWriter != null) {
                if (!windows125XWriter.fInUse) {
                    windows125XWriter.fInUse = true;
                    return windows125XWriter;
                }
                ++n;
                continue;
            }
            unsynchronizedBag.removeDeadReferences();
        }
        windows125XWriter = new Windows125XWriter();
        windows125XWriter.fInUse = true;
        unsynchronizedBag.add(windows125XWriter);
        return windows125XWriter;
    }

    public void reset(int n, OutputStream outputStream) {
        super.reset(outputStream);
        switch (n) {
            case 57: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1250_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1250_ENCODED_CHARACTERS;
                break;
            }
            case 58: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1251_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1251_ENCODED_CHARACTERS;
                break;
            }
            case 59: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1252_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1252_ENCODED_CHARACTERS;
                break;
            }
            case 60: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1253_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1253_ENCODED_CHARACTERS;
                break;
            }
            case 61: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1254_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1254_ENCODED_CHARACTERS;
                break;
            }
            case 62: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1255_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1255_ENCODED_CHARACTERS;
                break;
            }
            case 63: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1256_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1256_ENCODED_CHARACTERS;
                break;
            }
            case 64: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1257_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1257_ENCODED_CHARACTERS;
                break;
            }
            case 65: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1258_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1258_ENCODED_CHARACTERS;
            }
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.fNumBytes + n2 < this.fBuffer.length) {
            this.encodeAndWrite(cArray, n, n2);
        } else {
            this.flushInternal();
            int n3 = n + n2;
            while (n + this.fBuffer.length < n3) {
                this.encodeAndWrite(cArray, n, this.fBuffer.length);
                n += this.fBuffer.length;
                this.flushInternal();
            }
            this.encodeAndWrite(cArray, n, n3 - n);
        }
    }

    public void write(int n) throws IOException {
        if (this.fNumBytes == this.fBuffer.length) {
            this.flushInternal();
        }
        int n2 = this.fNumBytes++;
        this.fBuffer[n2] = (byte)(this.fBuffer[n2] + (byte)n);
    }

    private void encodeAndWrite(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            if (cArray[n4] <= '\u007f') {
                this.fBuffer[this.fNumBytes++] = (byte)cArray[n4];
            } else {
                int n5 = Encoding.find(cArray[n4], this.fEncodableCharacters);
                this.fBuffer[this.fNumBytes++] = (byte)this.fEncodedCharacters[n5];
            }
            ++n4;
        }
    }

    protected void release() {
        this.fInUse = false;
    }
}

