/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class Serializer {
    private static final int ATTR_TAB_SIZE = 64;
    private static final String[] attrTab = new String[]{null, null, null, null, null, null, null, null, null, "&#x9;", "&#xA;", null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, null, null};
    private static final int TEXT_TAB_SIZE = 64;
    private static final String[] textTab = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;", null};

    static final void serializeAttribute(OMAttribute oMAttribute, Writer writer) throws IOException {
        Serializer.serializeAttribute(oMAttribute.getNamespace() == null ? null : oMAttribute.getNamespace().getPrefix(), oMAttribute.getLocalName(), oMAttribute.getAttributeValue(), writer);
    }

    static final void serializeAttribute(String string, String string2, String string3, Writer writer) throws IOException {
        int n = string3.length();
        int n2 = -1;
        writer.write(" ");
        if (string != null && string.length() != 0) {
            writer.write(string);
            writer.write(":");
        }
        writer.write(string2);
        writer.write("=\"");
        for (int i = 0; i < n; ++i) {
            String string4;
            char c = string3.charAt(i);
            String string5 = string4 = c < '@' ? attrTab[c] : null;
            if (string4 != null) {
                if (n2 >= 0) {
                    writer.write(string3, n2, i - n2);
                    n2 = -1;
                }
                writer.write(string4);
                continue;
            }
            if (n2 >= 0) continue;
            n2 = i;
        }
        if (n2 >= 0) {
            writer.write(string3, n2, n - n2);
        }
        writer.write("\"");
    }

    static final void serializeNamespaceDeclaration(OMNamespace oMNamespace, Writer writer) throws IOException {
        Serializer.serializeNamespaceDeclaration(oMNamespace.getPrefix(), oMNamespace.getName(), writer);
    }

    static final void serializeNamespaceDeclaration(String string, String string2, Writer writer) throws IOException {
        int n = string2.length();
        int n2 = -1;
        writer.write(" xmlns");
        if (string != null && string.length() != 0) {
            writer.write(":");
            writer.write(string);
        }
        writer.write("=\"");
        for (int i = 0; i < n; ++i) {
            String string3;
            char c = string2.charAt(i);
            String string4 = string3 = c < '@' ? attrTab[c] : null;
            if (string3 != null) {
                if (n2 >= 0) {
                    writer.write(string2, n2, i - n2);
                    n2 = -1;
                }
                writer.write(string3);
                continue;
            }
            if (n2 >= 0) continue;
            n2 = i;
        }
        if (n2 >= 0) {
            writer.write(string2, n2, n - n2);
        }
        writer.write("\"");
    }

    public static void serialize(OMNode oMNode, Writer writer) throws IOException {
        switch (oMNode.getType()) {
            case 1: {
                Iterator iterator;
                OMElement oMElement = (OMElement)oMNode;
                String string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
                String string2 = oMElement.getLocalName();
                writer.write("<");
                if (string != null && string.length() != 0) {
                    writer.write(string);
                    writer.write(":");
                }
                writer.write(string2);
                Iterator iterator2 = oMElement.getAllDeclaredNamespaces();
                if (iterator2 != null) {
                    while (iterator2.hasNext()) {
                        Serializer.serializeNamespaceDeclaration((OMNamespace)iterator2.next(), writer);
                    }
                }
                if ((iterator = oMElement.getAllAttributes()) != null) {
                    while (iterator.hasNext()) {
                        Serializer.serializeAttribute((OMAttribute)iterator.next(), writer);
                    }
                }
                writer.write(">");
                for (OMNode oMNode2 = oMElement.getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
                    Serializer.serialize(oMNode2, writer);
                }
                writer.write("</");
                if (string != null && string.length() != 0) {
                    writer.write(string);
                    writer.write(":");
                }
                writer.write(string2);
                writer.write(">");
                break;
            }
            case 9: {
                for (OMNode oMNode3 = ((OMContainer)((Object)oMNode)).getFirstOMChild(); oMNode3 != null; oMNode3 = oMNode3.getNextOMSibling()) {
                    Serializer.serialize(oMNode3, writer);
                }
                break;
            }
            case 4: 
            case 12: {
                Serializer.serializeText(((OMText)oMNode).getText(), writer);
                break;
            }
            case 5: {
                Serializer.serializeComment(oMNode, writer);
                break;
            }
        }
    }

    public static byte[] serialize(OMNode oMNode) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        Serializer.serialize(oMNode, outputStreamWriter);
        ((Writer)outputStreamWriter).close();
        return byteArrayOutputStream.toByteArray();
    }

    static final void serializeText(String string, Writer writer) throws IOException {
        int n = string.length();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            String string2;
            char c = string.charAt(i);
            String string3 = string2 = c < '@' ? textTab[c] : null;
            if (string2 != null) {
                if (n2 >= 0) {
                    writer.write(string, n2, i - n2);
                    n2 = -1;
                }
                writer.write(string2);
                continue;
            }
            if (n2 >= 0) continue;
            n2 = i;
        }
        if (n2 >= 0) {
            writer.write(string, n2, n - n2);
        }
    }

    static final void serializeComment(OMNode oMNode, Writer writer) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        if (oMNode.getParent() instanceof OMDocument) {
            OMNode oMNode2 = oMNode;
            while ((oMNode2 = oMNode2.getPreviousOMSibling()) != null && oMNode2.getType() != 1) {
            }
            if (oMNode2 == null) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        if (bl2) {
            writer.write("\n");
        }
        writer.write("<!--");
        writer.write(((OMComment)oMNode).getValue());
        writer.write("-->");
        if (bl) {
            writer.write("\n");
        }
    }
}

