/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.WriteBeyondContentLengthException;
import com.ibm.wsspi.webcontainer.IResponse;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.ResponseBuffer;
import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer
implements ResponseBuffer {
    protected Writer out;
    protected char[] buf = new char[0];
    protected int count;
    protected int total;
    protected int limit;
    protected IResponse response;
    protected int length = -1;
    protected IOutputStreamObserver obs;
    protected boolean _hasWritten;
    protected boolean _hasFlushed;
    protected IOException except;
    protected boolean committed;
    private int bufferSize;
    private static TraceComponent tc = Tr.register(BufferedWriter.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
    private boolean closeOnClose = false;
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public BufferedWriter(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Constructor --> " + n);
        }
        this.buf = new char[n];
        this.bufferSize = n;
        this._hasWritten = false;
        this._hasFlushed = false;
    }

    public BufferedWriter() {
        this(1024);
    }

    public void init(Writer writer, int n) {
        this.initNewBuffer(writer, n);
    }

    void initNewBuffer(Writer writer, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "initNewBuffer size --> " + n);
        }
        this.out = writer;
        this.except = null;
        if (this.buf.length != n) {
            this.bufferSize = n;
            this.buf = new char[this.bufferSize];
        }
    }

    public void finish() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "finish");
        }
        if (this.length == -1 && this.total != 0) {
            this.length = this.total;
        }
        this.flush();
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "reset");
        }
        this.out = null;
        this.count = 0;
        this.total = 0;
        this.limit = -1;
        this.length = -1;
        this.committed = false;
        this._hasWritten = false;
        this._hasFlushed = false;
        this.response = null;
    }

    public int getTotal() {
        return this.total;
    }

    public void setObserver(IOutputStreamObserver iOutputStreamObserver) {
        this.obs = iOutputStreamObserver;
        this.limit = -1;
    }

    public boolean isCommitted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isCommitted: " + this.committed);
        }
        return this.committed;
    }

    protected void check() throws IOException {
        if (this.except != null) {
            this.flush();
            throw this.except;
        }
    }

    public void write(int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "write --> " + n);
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1 && this.total >= this.limit) {
            throw new WriteBeyondContentLengthException();
        }
        if (this.count == this.buf.length) {
            this.response.setFlushMode(false);
            this.flushChars();
            this.response.setFlushMode(true);
        }
        this.buf[this.count++] = (char)n;
        ++this.total;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "write total: " + this.total + " len: " + n2 + " limit: " + this.limit + " buf.length: " + this.buf.length + " count: " + this.count);
        }
        if (n2 < 0) {
            Tr.error(tc, "Illegal.Argument.Trying.to.write.chars");
            throw new IllegalArgumentException();
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1 && this.total + n2 > this.limit) {
            n2 = this.limit - this.total;
            this.except = new WriteBeyondContentLengthException();
        }
        if (n2 >= this.buf.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "len >= buf.length");
            }
            this.response.setFlushMode(false);
            this.flushChars();
            this.total += n2;
            this.writeOut(cArray, n, n2);
            this.response.setFlushMode(true);
            this.check();
            return;
        }
        int n3 = this.buf.length - this.count;
        if (n2 > n3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "len >= avail");
            }
            this.response.setFlushMode(false);
            this.flushChars();
            this.response.setFlushMode(true);
        }
        System.arraycopy(cArray, n, this.buf, this.count, n2);
        this.count += n2;
        this.total += n2;
        this.check();
    }

    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "flush");
        }
        this.flushChars();
    }

    protected void flushChars() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "flushChars");
        }
        if (!this.committed && !this._hasFlushed && this.obs != null) {
            this._hasFlushed = true;
            this.obs.alertFirstFlush();
        }
        this.committed = true;
        if (this.count > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Count =" + this.count);
            }
            this.writeOut(this.buf, 0, this.count);
            this.count = 0;
        } else if (this.response.getFlushMode()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Count 0 still flush mode is true , forceful flush");
            }
            this.response.flushBufferedContent();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, " flush mode is false");
        }
    }

    public void print(String string) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "print --> ", string);
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        int n = string.length();
        if (this.limit > -1 && this.total + n > this.limit) {
            n = this.limit - this.total;
            this.except = new WriteBeyondContentLengthException();
        }
        int n2 = 0;
        while (n > 0) {
            int n3 = this.buf.length - this.count;
            if (n3 == 0) {
                this.response.setFlushMode(false);
                this.flushChars();
                this.response.setFlushMode(true);
                n3 = this.buf.length - this.count;
            }
            if (n3 > n) {
                n3 = n;
            }
            string.getChars(n2, n2 + n3, this.buf, this.count);
            this.count += n3;
            this.total += n3;
            n2 += n3;
            n -= n3;
        }
        this.check();
    }

    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "close");
        }
        this.finish();
        try {
            this.obs.alertClose();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.srt.BufferedWriter.close", "397", this);
        }
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public void setResponse(IResponse iResponse) {
        this.response = iResponse;
    }

    protected void writeOut(char[] cArray, int n, int n2) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "writeOut --> " + n2);
        }
        try {
            this.out.write(cArray, n, n2);
            this.out.flush();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webcontainer.srt.BufferedWriter.writeOut", "416", this);
            this.count = 0;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "IOException occurred in writeOut method, observer alerting close.");
            }
            this.obs.alertClose();
            this.obs.alertException();
            throw iOException;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setBufferSize --> " + n);
        }
        if (this.total > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setBufferSize(): illegal state--> already wrote " + this.total + " bytes");
            }
            throw new IllegalStateException(nls.getString("Cannot.set.buffer.size.after.data", "Can't set buffer size after data has been written to stream"));
        }
        this.initNewBuffer(this.out, n);
    }

    public void clearBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "clearBuffer");
        }
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "clearBuffer(): illegal state--> stream is committed ");
            }
            throw new IllegalStateException();
        }
        this.total = 0;
        this.count = 0;
        this._hasWritten = false;
    }

    public void flushBuffer() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "flushBuffer");
        }
        this.flush();
    }
}

