/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.util;

import com.ibm.wsspi.util.WsMapFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WsMap
implements Map {
    private static final Object[] NO_VALUES = new Object[0];
    private static final Object REMOVED = new WsMapFactory();
    private final WsMapFactory factory;
    private Object[] values;
    private int removeCount;

    protected WsMap(WsMapFactory wsMapFactory) {
        this.factory = wsMapFactory;
        this.values = new Object[wsMapFactory.keySize()];
        this.removeCount = 0;
    }

    public Object get(int n) {
        if (n >= this.values.length) {
            return null;
        }
        Object object = this.values[n];
        if (object == REMOVED) {
            return null;
        }
        return object;
    }

    public Object put(int n, Object object) {
        Object object2;
        if (n >= this.values.length) {
            object2 = new Object[n + 1];
            System.arraycopy(this.values, 0, object2, 0, this.values.length);
            this.values = object2;
        }
        if ((object2 = this.values[n]) == REMOVED) {
            --this.removeCount;
        }
        this.values[n] = object;
        return object2;
    }

    public int size() {
        return this.values.length - this.removeCount;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object object) {
        int n = this.factory.getIndex(object, false);
        if (n < 0 || n >= this.values.length) {
            return false;
        }
        Object object2 = this.values[n];
        return object2 != REMOVED;
    }

    public boolean containsValue(Object object) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!object.equals(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public Object get(Object object) {
        int n = this.factory.getIndex(object, false);
        if (n < 0) {
            return null;
        }
        return this.get(n);
    }

    public Object put(Object object, Object object2) {
        return this.put(this.factory.getIndex(object), object2);
    }

    public Object remove(Object object) {
        int n = this.factory.getIndex(object, false);
        if (n < 0 || n >= this.values.length) {
            return null;
        }
        Object object2 = this.values[n];
        if (object2 == REMOVED) {
            return null;
        }
        if (object2 != REMOVED) {
            ++this.removeCount;
        }
        this.values[n] = REMOVED;
        return object2;
    }

    public void putAll(Map map) {
        for (Object k : map.keySet()) {
            this.put(k, map.get(k));
        }
    }

    public void clear() {
        this.values = NO_VALUES;
        this.removeCount = 0;
    }

    public Set keySet() {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == REMOVED) continue;
            hashSet.add(this.factory.getKey(i));
        }
        return hashSet;
    }

    public Collection values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.values.length; ++i) {
            Object object = this.values[i];
            if (object == REMOVED) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public Set entrySet() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < this.values.length; ++i) {
            Object object = this.values[i];
            if (object == REMOVED) continue;
            hashMap.put(this.factory.getKey(i), object);
        }
        return hashMap.entrySet();
    }
}

