/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.Factory;
import com.ibm.wsspi.cluster.ClusterManagement;
import java.lang.reflect.Constructor;

public final class ClusterManagementFactory {
    private static final TraceComponent tc = Tr.register(ClusterManagementFactory.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static ClusterManagement distributed;
    private static ClusterManagement local;

    public static ClusterManagement getClusterManagement() {
        return distributed;
    }

    public static ClusterManagement getNonDistributedClusterManagement() {
        return local;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.4 ");
        }
        try {
            Class clazz = Factory.loadClass(ClusterManagement.class);
            Constructor constructor = clazz.getConstructor(Boolean.TYPE);
            distributed = (ClusterManagement)constructor.newInstance(Boolean.TRUE);
            local = (ClusterManagement)constructor.newInstance(Boolean.FALSE);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterManagementFactory.class.getName(), "58");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception", exception);
            }
            local = distributed = (ClusterManagement)Factory.loadImpl(ClusterManagement.class);
        }
    }
}

