/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.bootstrap;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.bootstrap.NlvPrintStream;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import org.eclipse.core.launcher.Main;

public class WSPreLauncher {
    private static Thread shutdownHook = new OnExit();
    static final String WAS_INSTALL_ROOT = "was.install.root";
    static final String USER_INSTALL_ROOT = "user.install.root";
    static final String OSGI_INSTALL = "osgi.install.area";
    static final String OSGI_CONFIG = "osgi.configuration.area";
    static final String OSGI_INSTANCE = "osgi.instance.area";
    private static String osgiInstanceArea = null;
    static final String WAS_PROPERTY_FILE = "cmd.properties.file";
    static final String OSGI_TRACE = "ws.osgi.debug";
    static final String CONFIG_INI = "configuration" + File.separatorChar + "config.ini";
    static final String PLATFORM_XML = "configuration" + File.separatorChar + "org.eclipse.update" + File.separatorChar + "platform.xml";
    static String[] passedArgs = null;
    private static final String S_JAVA_FILE_ENCODING_PROPERTY = "file.encoding";
    private static final String S_JAVA_USER_LANGUAGE_PROPERTY = "user.language";
    private static final String S_SERBIAN_CYRILLIC_USER_LANGUAGE_KEY = "sr";
    private static final String S_CP720 = "Cp720";
    private static final String S_CP737 = "Cp737";
    private static final String S_CP775 = "Cp775";
    private static final String S_CP850 = "Cp850";
    private static final String S_CP852 = "Cp852";
    private static final String S_CP855 = "Cp855";
    private static final String S_CP857 = "Cp857";
    private static final String S_CP862 = "Cp862";
    private static final String S_CP866 = "Cp866";
    private static final String S_CP1047 = "Cp1047";
    private static final String S_CP1250 = "Cp1250";
    private static final String S_CP1251 = "Cp1251";
    private static final String S_CP1252 = "Cp1252";
    private static final String S_CP1253 = "Cp1253";
    private static final String S_CP1254 = "Cp1254";
    private static final String S_CP1255 = "Cp1255";
    private static final String S_CP1256 = "Cp1256";
    private static final String S_CP1257 = "Cp1257";

    public static void main(String[] stringArray) {
        WSPreLauncher.setConsoleEncoding();
        WSPreLauncher.setImplicitProperties();
        String[] stringArray2 = WSPreLauncher.processArgsIn(stringArray);
        WSPreLauncher.checkSystemProperties();
        WSPreLauncher.launchEclipse(stringArray2);
    }

    private static void setConsoleEncoding() {
        block5: {
            String string = System.getProperty("ws.output.encoding");
            if (string != null && !string.equals("file")) {
                if (string.equals("console")) {
                    String string2 = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
                    string = string2.equalsIgnoreCase(S_CP1252) ? S_CP850 : null;
                }
                if (string != null) {
                    try {
                        System.setOut(new NlvPrintStream((OutputStream)System.out, true, string));
                        System.setErr(new NlvPrintStream((OutputStream)System.err, true, string));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (!LoggingServices.debugEnabled) break block5;
                        unsupportedEncodingException.printStackTrace(LoggingServices.out);
                    }
                }
            }
        }
        LoggingServices.out = System.out;
    }

    private static String[] processArgsIn(String[] stringArray) {
        int n;
        String string;
        String[] stringArray2;
        if (LoggingServices.debugEnabled) {
            for (int i = 0; i < stringArray.length; ++i) {
                LoggingServices.out.println("ws.ext.mains.args[" + i + "]=" + stringArray[i]);
            }
        }
        if (WSPreLauncher.configurationIsStale()) {
            Object object;
            String string2 = WSPreLauncher.getWasInstallRoot();
            stringArray2 = WSPreLauncher.getUserInstallRoot();
            if (string2 != null && stringArray2 != null) {
                try {
                    if (!new File((String)stringArray2).getCanonicalFile().equals(new File(string2).getCanonicalFile())) {
                        File file;
                        object = new File((String)stringArray2 + File.separatorChar + CONFIG_INI);
                        if (((File)object).exists()) {
                            if (((File)object).delete()) {
                                WSPreLauncher.debug("Deleting file '" + ((File)object).getName() + "' successfully");
                            } else {
                                WSPreLauncher.debug("WARNING: fail to delete file '" + ((File)object).getName() + '\'');
                            }
                        }
                        if ((file = new File((String)stringArray2 + File.separatorChar + PLATFORM_XML)).delete()) {
                            WSPreLauncher.debug("Deleting file '" + file.getName() + "' successfully");
                        } else {
                            WSPreLauncher.debug("WARNING: fail to delete file '" + file.getName() + '\'');
                        }
                    }
                }
                catch (IOException iOException) {
                    WSPreLauncher.debug("WARNING: IOException encountered: " + iOException);
                    iOException.printStackTrace(LoggingServices.out);
                }
            }
            object = new String[stringArray.length + 1];
            object[0] = "-clean";
            System.arraycopy(stringArray, 0, object, 1, stringArray.length);
            stringArray = object;
        }
        if ((string = System.getProperty(OSGI_TRACE)) != null) {
            if (string.length() == 0) {
                stringArray2 = new String[stringArray.length + 1];
                stringArray2[0] = "-debug";
                System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                stringArray = stringArray2;
            } else {
                stringArray2 = new String[stringArray.length + 2];
                stringArray2[0] = "-debug";
                stringArray2[1] = string;
                System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
                stringArray = stringArray2;
            }
        }
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("com.ibm.ws.bootstrap.WSLauncher")) continue;
            bl = true;
            break;
        }
        if (bl) {
            int n2 = n + 1;
            int n3 = stringArray.length - n2;
            String[] stringArray3 = new String[n2];
            System.arraycopy(stringArray, 0, stringArray3, 0, n2);
            passedArgs = new String[n3];
            System.arraycopy(stringArray, n2, passedArgs, 0, n3);
            if (LoggingServices.debugEnabled) {
                int n4;
                for (n4 = 0; n4 < n2; ++n4) {
                    LoggingServices.out.println("osgi_args[" + n4 + "]=" + stringArray3[n4]);
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    LoggingServices.out.println("passedArgs[" + n4 + "]=" + passedArgs[n4]);
                }
            }
            stringArray = stringArray3;
        } else {
            LoggingServices.trace("WSVR0703W", "com.ibm.ws.bootstrap.WSLauncher");
        }
        return stringArray;
    }

    public static String[] processArgsOut(String[] stringArray) {
        if (passedArgs != null) {
            stringArray = passedArgs;
        }
        return stringArray;
    }

    private static void checkSystemProperties() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    String string = System.getProperty("ibm.websphere.internalClassAccessMode");
                    if (string == null) {
                        string = "allow";
                        System.setProperty("ibm.websphere.internalClassAccessMode", string);
                    }
                    string = string.toLowerCase();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    private static void setImplicitProperties() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                WSPreLauncher.processPropertiesFile();
                if (System.getProperty(WSPreLauncher.OSGI_INSTALL) == null) {
                    string = WSPreLauncher.getWasInstallRoot();
                    if (string != null) {
                        System.setProperty(WSPreLauncher.OSGI_INSTALL, string);
                        WSPreLauncher.debug("Implicitly setting -Dosgi.install.area=" + System.getProperty(WSPreLauncher.OSGI_INSTALL));
                    } else {
                        WSPreLauncher.debug("WARNING: The system property was.install.root is not set.");
                    }
                }
                if (System.getProperty(WSPreLauncher.OSGI_CONFIG) == null) {
                    string = WSPreLauncher.getOsgiConfigRoot();
                    if (string != null) {
                        System.setProperty(WSPreLauncher.OSGI_CONFIG, string);
                        WSPreLauncher.debug("Implicitly setting -Dosgi.configuration.area=" + System.getProperty(WSPreLauncher.OSGI_CONFIG));
                    } else {
                        WSPreLauncher.debug("WARNING: The system properties user.install.root and was.install.root are not set.");
                    }
                }
                if (System.getProperty(WSPreLauncher.OSGI_INSTANCE) == null) {
                    osgiInstanceArea = WSPreLauncher.getOsgiInstanceRoot();
                    if (osgiInstanceArea != null) {
                        System.setProperty(WSPreLauncher.OSGI_INSTANCE, osgiInstanceArea);
                        Runtime.getRuntime().addShutdownHook(shutdownHook);
                        WSPreLauncher.debug("Implicitly setting -Dosgi.instance.area=" + System.getProperty(WSPreLauncher.OSGI_INSTANCE));
                    } else {
                        WSPreLauncher.debug("WARNING: The system properties user.install.root and was.install.root are not set.");
                    }
                }
                return null;
            }
        });
    }

    private static void launchEclipse(String[] stringArray) {
        Main main = new Main();
        main.run(stringArray);
    }

    private static String getWasInstallRoot() {
        return System.getProperty(WAS_INSTALL_ROOT);
    }

    private static String getUserInstallRoot() {
        return System.getProperty(USER_INSTALL_ROOT);
    }

    private static String getOsgiConfigRoot() {
        String string = System.getProperty(OSGI_CONFIG);
        if (string == null) {
            string = WSPreLauncher.getUserInstallRoot();
            if (string == null) {
                string = WSPreLauncher.getWasInstallRoot();
            }
            if (string != null) {
                string = string + "/configuration";
            }
        }
        return string;
    }

    private static String getOsgiInstanceRoot() {
        String string = System.getProperty(OSGI_INSTANCE);
        if (string == null && WSPreLauncher.getUserInstallRoot() != null && !WSPreLauncher.getUserInstallRoot().equals(WSPreLauncher.getWasInstallRoot())) {
            string = WSPreLauncher.getOsgiTmpDir(WSPreLauncher.getUserInstallRoot() + File.separator + "temp");
        }
        if (string == null) {
            string = WSPreLauncher.getOsgiTmpDir(System.getProperty("java.io.tmpdir"));
        }
        return string;
    }

    private static String getOsgiTmpDir(String string) {
        String string2 = System.getProperty("user.name");
        if (string2 == null) {
            string2 = "default";
        }
        Random random = new Random();
        string = string + File.separator + "osgi_instance_location" + File.separator + string2 + File.separator;
        File file = new File(string + random.nextInt(Integer.MAX_VALUE));
        while (!file.mkdirs()) {
            if (!file.exists()) {
                return null;
            }
            file = new File(string + random.nextInt(Integer.MAX_VALUE));
        }
        string = file.getAbsolutePath();
        WSPreLauncher.debug("osgi.instance.area has been set to: " + string);
        return string;
    }

    private static void debug(String string) {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println(string);
        }
    }

    private static boolean configurationIsStale() {
        block6: {
            File file = new File(WSPreLauncher.getWasInstallRoot() + "/properties/version/nif/backup/NIFHistory.xml");
            File file2 = new File(WSPreLauncher.getOsgiConfigRoot() + "/.lastTouched");
            if (file.exists() && file2.exists() && file.lastModified() < file2.lastModified()) {
                return false;
            }
            if (!file.exists()) {
                return false;
            }
            if (file2.exists() && !file2.delete()) {
                WSPreLauncher.debug("WARNING: could not clean up \"last touched\" indicator file: " + file2.getAbsolutePath());
            }
            try {
                if (!file2.createNewFile()) {
                    WSPreLauncher.debug("WARNING: could not create \"last touched\" indicator file: " + file2.getAbsolutePath());
                }
            }
            catch (Throwable throwable) {
                if (!LoggingServices.debugEnabled) break block6;
                throwable.printStackTrace(LoggingServices.out);
            }
        }
        return true;
    }

    public static void processPropertiesFile() {
        String string;
        if (WSLauncher.isWindows() && (string = System.getProperty(WAS_PROPERTY_FILE)) != null) {
            try {
                String string2;
                String string3 = WSPreLauncher.getProperEncodingForCurrentOSShellScripts();
                WSPreLauncher.debug("OSEncoding is " + string3);
                FileInputStream fileInputStream = new FileInputStream(new File(string));
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string3));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.startsWith("#")) continue;
                    string2.trim();
                    int n = string2.indexOf(61);
                    String string4 = string2.substring(0, n);
                    String string5 = string2.substring(n + 1);
                    WSPreLauncher.debug("Key is " + string4 + ", value is " + string5);
                    if (System.getProperty(string4) != null) continue;
                    WSPreLauncher.debug("Adding key " + string4);
                    System.setProperty(string4, string5);
                }
                bufferedReader.close();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                WSPreLauncher.debug("WARNING: IOException processing properties file: " + iOException);
                iOException.printStackTrace(LoggingServices.out);
            }
        }
    }

    private static String getProperEncodingForCurrentOSShellScripts() {
        String string = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
        if (WSLauncher.isWindows()) {
            return WSPreLauncher.lookupEncoding(string);
        }
        if (WSLauncher.isZOS()) {
            return S_CP1047;
        }
        return string;
    }

    private static String lookupEncoding(String string) {
        if (string.equalsIgnoreCase(S_CP1252)) {
            return S_CP850;
        }
        if (string.equalsIgnoreCase(S_CP1251)) {
            if (WSPreLauncher.isSerbianCyrillic()) {
                return S_CP855;
            }
            return S_CP866;
        }
        if (string.equalsIgnoreCase(S_CP1250)) {
            return S_CP852;
        }
        if (string.equalsIgnoreCase(S_CP1253)) {
            return S_CP737;
        }
        if (string.equalsIgnoreCase(S_CP1254)) {
            return S_CP857;
        }
        if (string.equalsIgnoreCase(S_CP1255)) {
            return S_CP862;
        }
        if (string.equalsIgnoreCase(S_CP1256)) {
            return S_CP720;
        }
        if (string.equalsIgnoreCase(S_CP1257)) {
            return S_CP775;
        }
        return string;
    }

    private static boolean isSerbianCyrillic() {
        String string = System.getProperty(S_JAVA_USER_LANGUAGE_PROPERTY);
        return string.equalsIgnoreCase(S_SERBIAN_CYRILLIC_USER_LANGUAGE_KEY);
    }

    static void onExit() {
        WSPreLauncher.deleteEclipseInstanceArea(new File(osgiInstanceArea));
    }

    private static boolean deleteEclipseInstanceArea(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = WSPreLauncher.deleteEclipseInstanceArea(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    private static class OnExit
    extends Thread {
        private OnExit() {
        }

        public void run() {
            WSPreLauncher.onExit();
        }
    }
}

