/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.rt;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;

public class HexOutputStream
extends OutputStream {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private StringWriter writer;

    public HexOutputStream(StringWriter stringWriter) {
        this.writer = stringWriter;
    }

    public synchronized void write(int n) throws IOException {
        this.writer.write(hex[n >> 4 & 0xF]);
        this.writer.write(hex[n >> 0 & 0xF]);
    }

    public synchronized void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        char[] cArray = new char[2 * n2];
        for (int i = 0; i < n2; ++i) {
            cArray[2 * i] = hex[byArray[i] >> 4 & 0xF];
            cArray[2 * i + 1] = hex[byArray[i] >> 0 & 0xF];
        }
        this.writer.write(cArray, 0, cArray.length);
    }

    public synchronized String dump() {
        return this.writer.toString();
    }
}

