/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ExtendedIORInfo;
import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws390.orb.ORB;
import com.ibm.ws390.orb.ORBEJSBridge;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;

public class WS390IORInterceptor
extends LocalObject
implements ORBInitializer,
IORInterceptor {
    private static final TraceComponent tc = Tr.register(WS390IORInterceptor.class, "ORB", null);
    public static final int TAG_ORB_TYPE = 0;
    public static final int TAG_Native390_IPC = 1229081869;
    public static final int TAG_Indirect_IOR = 1229081871;
    public static final int IIOP_Native390ORBType = 1229081856;
    private ORB _orb = null;
    Profile.TaggedComponent[] indirectTags = null;
    Profile.TaggedComponent[] directTags = null;
    private Profile.TaggedComponent orbTypeTag = null;
    private Profile.TaggedComponent localCommTag = null;

    public void pre_init(ORBInitInfo oRBInitInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pre_init", oRBInitInfo);
        }
        WS390IORInterceptor wS390IORInterceptor = new WS390IORInterceptor();
        try {
            ((ExtendedORBInitInfo)oRBInitInfo).add_ior_interceptor_first((IORInterceptor)wS390IORInterceptor);
        }
        catch (DuplicateName duplicateName) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "caught DuplicateName exception", (Object)duplicateName);
            }
            throw new RuntimeException(duplicateName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pre_init");
        }
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
    }

    public void establish_components(IORInfo iORInfo) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "establish_components", iORInfo);
            }
            try {
                if (this._orb == null) {
                    this.getORB();
                }
                if (this._orb != null) {
                    boolean bl = false;
                    Profile profile = ((ExtendedIORInfo)iORInfo).getProfile();
                    bl = this._orb.isIndirectIIOPProfile(profile);
                    if (bl) {
                        this.addTags(profile, this.getIndirectTags());
                    } else {
                        this.addTags(profile, this.getDirectTags());
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "caught exception in WS390IORInterceptor.establish_components", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "establish_components");
        }
    }

    private ORB getORB() {
        this._orb = (ORB)GlobalORBFactory.globalORB();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getORB", this._orb);
        }
        return this._orb;
    }

    private Profile.TaggedComponent[] getDirectTags() {
        if (this.directTags != null) {
            return this.directTags;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDirectTags");
        }
        if (AdminHelper.getPlatformHelper().isServantJvm()) {
            Profile profile = this._orb.getControllerIIOPProfile();
            this.directTags = profile.getTaggedComponents();
        } else {
            this.createDirectTags();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDirectTags", this.directTags);
        }
        return this.directTags;
    }

    private Profile.TaggedComponent[] getIndirectTags() {
        if (this.indirectTags != null) {
            return this.indirectTags;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIndirectTags");
        }
        Profile profile = this._orb.getDaemonIIOPProfile();
        this.indirectTags = profile.getTaggedComponents();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIndirectTags", this.indirectTags);
        }
        return this.indirectTags;
    }

    private void addTags(Profile profile, Profile.TaggedComponent[] taggedComponentArray) {
        if (taggedComponentArray != null) {
            for (int i = 0; i < taggedComponentArray.length; ++i) {
                profile.putTaggedComponent(taggedComponentArray[i].tag(), taggedComponentArray[i].componentData(), true);
            }
        }
    }

    private void createDirectTags() {
        if (this.getLocalCommTag() == null) {
            return;
        }
        if (this.getORBTypeTag() == null) {
            return;
        }
        this.directTags = new Profile.TaggedComponent[2];
        this.directTags[0] = this.orbTypeTag;
        this.directTags[1] = this.localCommTag;
    }

    private Profile.TaggedComponent getORBTypeTag() {
        if (this.orbTypeTag != null) {
            return this.orbTypeTag;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getORBTypeTag");
        }
        CDROutputStream cDROutputStream = ORB.createCDROutputStream();
        cDROutputStream.putEndian();
        cDROutputStream.write_long(1229081856);
        this.orbTypeTag = ORB.createTaggedComponent((int)0, (byte[])cDROutputStream.toByteArray());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getORBTypeTag", this.orbTypeTag.componentData());
        }
        return this.orbTypeTag;
    }

    private Profile.TaggedComponent getLocalCommTag() {
        byte[] byArray;
        if (this.localCommTag != null) {
            return this.localCommTag;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalCommTag");
        }
        if ((byArray = ORBEJSBridge.getLocalCommIORTagData()) != null) {
            this.localCommTag = ORB.createTaggedComponent((int)1229081869, (byte[])byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalCommTag", this.localCommTag != null ? this.localCommTag.componentData() : null);
        }
        return this.localCommTag;
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void destroy() {
    }
}

