/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.orb.XmlNotValidException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SibClassificationParser {
    private static final TraceComponent TC = Tr.register(SibClassificationParser.class, "ORB", null);
    public static final String SCHEMA_VERSION = "1.0";
    private List elements = new ArrayList();
    private boolean gotJmsRa = false;
    private boolean gotDestinationMediation = false;
    private static final SibClassificationParser INSTANCE = new SibClassificationParser();

    private SibClassificationParser() {
    }

    public void parse(Element element) throws XmlNotValidException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "parse");
        }
        String string = element.getAttribute("type");
        String string2 = element.getAttribute("schema_version");
        String string3 = element.getAttribute("default_transaction_class");
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "parse", new Object[]{"element " + element.getTagName(), "type=" + string, "default_transaction_class=" + string3, "schema_version=" + string2});
        }
        if (!string2.equals(SCHEMA_VERSION)) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Unsupported version of SibClassification element (supported version is 1.0)");
            }
            throw new XmlNotValidException("Unsupported version of SibClassification element (supported version is 1.0)");
        }
        boolean bl = false;
        if (string.equals("jmsra")) {
            if (this.gotJmsRa) {
                String string4 = "More than one SibClassification element of type \"" + string + "\" was found";
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, string4);
                }
                throw new XmlNotValidException(string4);
            }
            this.gotJmsRa = true;
            bl = true;
        } else if (string.equals("destinationmediation")) {
            if (this.gotDestinationMediation) {
                String string5 = "More than one SibClassification element of type \"" + string + "\" was found";
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, string5);
                }
                throw new XmlNotValidException(string5);
            }
            this.gotDestinationMediation = true;
            bl = true;
        }
        if (bl) {
            SibClassificationParser.validateTransactionClass(string3);
            NodeList nodeList = element.getElementsByTagName("sib_classification_info");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.validateClassificationInfo((Element)nodeList.item(i));
            }
            this.getElements().add(element);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "parse");
        }
    }

    private void validateClassificationInfo(Element element) throws XmlNotValidException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "parseClassificationInfo");
        }
        String string = element.getAttribute("transaction_class");
        String string2 = element.getAttribute("selector");
        String string3 = element.getAttribute("bus");
        String string4 = element.getAttribute("destination");
        String string5 = element.getAttribute("discriminator");
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "parseClassificationInfo", new Object[]{"element " + element.getTagName(), "transaction_class=" + string, "selector=" + string2, "bus=" + string3, "destination=" + string4, "discriminator=" + string5, "description=" + element.getAttribute("description")});
        }
        SibClassificationParser.validateTransactionClass(string);
        if (string2.trim().equals("") && string3.trim().equals("") && string4.trim().equals("") && string5.trim().equals("")) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "At least one of the attributes selector, bus, destination and discriminator must be specified");
            }
            throw new XmlNotValidException("At least one of the attributes selector, bus, destination and discriminator must be specified");
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "parseClassificationInfo");
        }
    }

    public void clear() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "clear");
        }
        this.elements = new ArrayList();
        this.gotJmsRa = false;
        this.gotDestinationMediation = false;
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "clear");
        }
    }

    public List getElements() {
        return this.elements;
    }

    public static SibClassificationParser getInstance() {
        return INSTANCE;
    }

    private static void validateTransactionClass(String string) throws XmlNotValidException {
        if (string.trim().equals("") || string.length() > 8) {
            String string2 = "Transaction class \"" + string + "\" must not be empty or longer than 8 characters";
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, string2);
            }
            throw new XmlNotValidException(string2);
        }
    }
}

