/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.ServantInitializationListener;
import com.ibm.ws.util.ServantInitializedException;
import java.util.LinkedList;

public class ServantInitializedNotifier {
    private static final char[] charValues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final TraceComponent tc = Tr.register(ServantInitializedNotifier.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    private static LinkedList listenerList;
    private static boolean servantInitialized;

    private static native void setListenerHandle();

    public static synchronized void registerListener(ServantInitializationListener servantInitializationListener) throws ServantInitializedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServantInitializedNotifier.registerListener");
        }
        if (servantInitialized) {
            throw new ServantInitializedException("Servant has already initialized");
        }
        listenerList.add(servantInitializationListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServantInitializedNotifier.registerListener");
        }
    }

    public static synchronized void servantInitialized(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServantInitializedNotifier.servantInitialized", byArray);
        }
        String string = null;
        if (byArray != null && byArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                int n = (byArray[i] & 0xF0) / 16;
                int n2 = byArray[i] & 0xF;
                stringBuffer.append(charValues[n]);
                stringBuffer.append(charValues[n2]);
            }
            string = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServantInitializedNotifier.stringStoken", string);
            }
            for (ServantInitializationListener servantInitializationListener : listenerList) {
                try {
                    servantInitializationListener.servantInitialized(string);
                }
                catch (Exception exception) {
                    Tr.event(tc, "ServantInitializedNotifier.servantInitialized", exception);
                }
            }
            listenerList = null;
            servantInitialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServantInitializedNotifier.servantInitialized");
        }
    }

    static {
        String string = System.getProperty("com.ibm.vm.bitmode");
        int n = Integer.parseInt(string);
        if (n == 64) {
            System.loadLibrary("bbgboa");
        } else {
            System.loadLibrary("bboboa");
        }
        ServantInitializedNotifier.setListenerHandle();
        listenerList = new LinkedList();
        servantInitialized = false;
    }
}

