/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORBUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.orb.BOSSObjectKey;
import com.ibm.ws390.orb.ClientDelegate;
import com.ibm.ws390.orb.ORB;
import com.ibm.ws390.orb.ORBEJSBridge;
import com.ibm.ws390.orb.SRObjectElement;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA_2_3.portable.ObjectImpl;

public class SRAggregator
implements com.ibm.ws.util.SRAggregator {
    private static TraceComponent tc = Tr.register(SRAggregator.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    private static final byte[] NULL_STOKEN = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final char[] charValues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String SIB_Z_DISPATCH = "com.ibm.ws.sib.z.dispatcher.WorkObjectImpl";
    private LinkedList srObjectElementList = null;
    private ListIterator srObjectElementListIterator = null;
    private SRObjectElement singleServantObject = null;
    private ByteBuffer stokenElements = null;
    private String type_id = null;
    private String classname = null;
    private String applenv = null;
    private boolean queueInternal = true;

    public SRAggregator() {
    }

    public SRAggregator(Object object, boolean bl) {
        this(object, bl, NULL_STOKEN, null);
    }

    public SRAggregator(Object object, boolean bl, String string) {
        this(object, bl, NULL_STOKEN, string);
    }

    public SRAggregator(Object object, boolean bl, byte[] byArray) {
        this(object, bl, byArray, null);
    }

    public SRAggregator(Object object, boolean bl, byte[] byArray, boolean bl2) {
        this(object, bl, byArray, null, bl2);
    }

    public SRAggregator(Object object, boolean bl, byte[] byArray, String string) {
        this(object, bl, byArray, string, true);
    }

    public SRAggregator(Object object, boolean bl, byte[] byArray, String string, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SRAggregator::SRAggregator");
        }
        this.initialize(object, bl, byArray, string, bl2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SRAggregator::SRAggregator");
        }
    }

    public void initialize(Object object, boolean bl) {
        this.initialize(object, bl, NULL_STOKEN);
    }

    public void initialize(Object object, boolean bl, byte[] byArray) {
        this.initialize(object, bl, byArray, null);
    }

    public void initialize(Object object, boolean bl, byte[] byArray, String string) {
        this.initialize(object, bl, byArray, string, true);
    }

    public void initialize(Object object, boolean bl, byte[] byArray, String string, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.type_id = ((ObjectImpl)object)._ids()[0];
        this.classname = ((ObjectImpl)object).getClass().getName();
        this.applenv = string;
        this.queueInternal = bl2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createSRAggregator " + this.type_id + " " + this.classname + " " + bl + " " + this.applenv, byArray);
        }
        this.createSRAggregator(bl, byArray != null ? byArray : NULL_STOKEN);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        if (this.singleServantObject == null) {
            LinkedList linkedList = this.srObjectElementList;
            synchronized (linkedList) {
                java.lang.Object object;
                int n;
                byte[] byArray = SRAggregator.getStokenElements();
                this.stokenElements = ByteBuffer.wrap(byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stokenElementsBytes", byArray);
                }
                int n2 = this.stokenElements.getInt();
                int n3 = this.srObjectElementList.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initial list size", new Integer(n3));
                }
                boolean[] blArray = new boolean[n3];
                for (n = 0; n < n3; ++n) {
                    blArray[n] = false;
                }
                for (n = 0; n < n2; ++n) {
                    boolean bl;
                    object = new byte[8];
                    this.stokenElements.get((byte[])object);
                    boolean bl2 = bl = this.stokenElements.get() == 1;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "refreshing stoken", object);
                    }
                    boolean bl3 = false;
                    for (int i = 0; i < n3; ++i) {
                        SRObjectElement sRObjectElement = (SRObjectElement)this.srObjectElementList.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "comparing to srElement at index: " + i, sRObjectElement.getStokenBytes());
                        }
                        if (!Arrays.equals(sRObjectElement.getStokenBytes(), object)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "found stoken in list at index " + i, sRObjectElement);
                        }
                        blArray[i] = true;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    this.srObjectElementList.addLast(this.createSRObjectElement(this.createBOSSObjectKey(), (byte[])object, bl));
                }
                for (n = n3 - 1; n >= 0; --n) {
                    if (blArray[n]) continue;
                    object = (SRObjectElement)this.srObjectElementList.remove(n);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "removed element", object);
                }
                this.srObjectElementListIterator = this.srObjectElementList.listIterator(0);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
    }

    public boolean hasNext() {
        if (this.singleServantObject != null) {
            return true;
        }
        return this.srObjectElementListIterator != null ? this.srObjectElementListIterator.hasNext() : false;
    }

    public java.lang.Object next() {
        if (this.singleServantObject != null) {
            return this.singleServantObject.getSRObject();
        }
        try {
            return ((SRObjectElement)this.srObjectElementListIterator.next()).getSRObject();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException();
        }
    }

    public com.ibm.ws.util.SRObjectElement nextSRObjectElement() {
        if (this.singleServantObject != null) {
            return this.singleServantObject;
        }
        if (this.srObjectElementListIterator != null) {
            return (com.ibm.ws.util.SRObjectElement)this.srObjectElementListIterator.next();
        }
        throw new NoSuchElementException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getSRObjectElementHT() {
        Hashtable<String, java.lang.Object> hashtable = new Hashtable<String, java.lang.Object>();
        LinkedList linkedList = this.srObjectElementList;
        synchronized (linkedList) {
            this.refresh();
            ListIterator listIterator = this.srObjectElementList.listIterator(0);
            while (listIterator.hasNext()) {
                SRObjectElement sRObjectElement = (SRObjectElement)listIterator.next();
                hashtable.put(sRObjectElement.getStoken(), sRObjectElement.getSRObject());
            }
        }
        return hashtable;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSRObject(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteSRObject", byArray);
        }
        SRObjectElement sRObjectElement = null;
        LinkedList linkedList = this.srObjectElementList;
        synchronized (linkedList) {
            ListIterator listIterator = this.srObjectElementList.listIterator(0);
            while (listIterator.hasNext()) {
                SRObjectElement sRObjectElement2 = (SRObjectElement)listIterator.next();
                if (!Arrays.equals(sRObjectElement2.getStokenBytes(), byArray)) continue;
                sRObjectElement = sRObjectElement2;
                listIterator.remove();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteSRObject", sRObjectElement);
        }
    }

    public boolean isServantActive(byte[] byArray) {
        if (ORBEJSBridge.getOrbType() == 1) {
            return PlatformHelperFactory.getPlatformHelper().isServantActive(byArray);
        }
        throw new IllegalStateException("SRAggrator.isServantActive is only supported in a Controller");
    }

    private void createSRAggregator(boolean bl, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSRAggregator");
        }
        if (!bl && (byArray == NULL_STOKEN || Arrays.equals(byArray, NULL_STOKEN))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating singleServantObject to ANY servant");
            }
            BOSSObjectKey bOSSObjectKey = this.createBOSSObjectKey();
            bOSSObjectKey.buildBOSSObjectKey();
            bOSSObjectKey.resetFlag(Integer.MIN_VALUE);
            this.singleServantObject = this.createSRObjectElement(bOSSObjectKey, byArray, false);
        } else {
            byte[] byArray2 = SRAggregator.getStokenElements(!bl);
            this.stokenElements = ByteBuffer.wrap(byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stokenElementsBytes", byArray2);
            }
            int n = this.stokenElements.getInt();
            if (bl) {
                this.srObjectElementList = new LinkedList();
            }
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                byte[] byArray3 = new byte[8];
                this.stokenElements.get(byArray3);
                boolean bl3 = bl2 = this.stokenElements.get() == 1;
                if (bl) {
                    this.srObjectElementList.add(this.createSRObjectElement(this.createBOSSObjectKey(), byArray3, bl2));
                    continue;
                }
                if (!Arrays.equals(byArray, byArray3)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found target stoken", byArray3);
                }
                this.singleServantObject = this.createSRObjectElement(this.createBOSSObjectKey(), byArray, bl2);
                break;
            }
            if (bl) {
                this.srObjectElementListIterator = this.srObjectElementList.listIterator(0);
                this.singleServantObject = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSRAggregator");
        }
    }

    private BOSSObjectKey createBOSSObjectKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBOSSObjectKey");
        }
        BOSSObjectKey bOSSObjectKey = new BOSSObjectKey(this.type_id, this.classname, null, true, false, true, null);
        if (this.applenv != null) {
            bOSSObjectKey.addQueueByApplenvData(this.applenv);
            bOSSObjectKey.setFlag(262144);
        }
        if (this.classname != SIB_Z_DISPATCH && this.queueInternal) {
            bOSSObjectKey.setFlag(0x100000);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBOSSObjectKey", bOSSObjectKey);
        }
        return bOSSObjectKey;
    }

    private SRObjectElement createSRObjectElement(BOSSObjectKey bOSSObjectKey, byte[] byArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSRObjectElement", byArray);
        }
        if (byArray != NULL_STOKEN) {
            bOSSObjectKey.addQueueByStokenData(byArray);
        }
        ORB oRB = (ORB)GlobalORBFactory.globalORB();
        IOR iOR = oRB.createIOR(this.type_id, oRB.getControllerIIOPProfile(), bOSSObjectKey);
        java.lang.Object object = this.createStubObject(iOR);
        SRObjectElement sRObjectElement = new SRObjectElement(object, SRAggregator.getStokenString(byArray), byArray, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSRObjectElement", sRObjectElement);
        }
        return sRObjectElement;
    }

    private static String getStokenString(byte[] byArray) {
        String string = null;
        if (byArray != null && byArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                int n = (byArray[i] & 0xF0) / 16;
                int n2 = byArray[i] & 0xF;
                stringBuffer.append(charValues[n]);
                stringBuffer.append(charValues[n2]);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private java.lang.Object createStubObject(IOR iOR) {
        String string = ORBUtil.stubNameFromRepId((String)this.type_id);
        java.lang.Object var3_3 = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stub_classname " + string);
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            var3_3 = clazz.newInstance();
            ORB oRB = (ORB)GlobalORBFactory.globalORB();
            ClientDelegate clientDelegate = new ClientDelegate(oRB, iOR);
            ((org.omg.CORBA.portable.ObjectImpl)var3_3)._set_delegate((Delegate)clientDelegate);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "ClassNotFoundException", classNotFoundException);
            }
            throw new RuntimeException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "InstantiationException", instantiationException);
            }
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "IllegalAccessException", illegalAccessException);
            }
            throw new RuntimeException(illegalAccessException);
        }
        return var3_3;
    }

    private static byte[] getStokenElements() {
        return SRAggregator.getStokenElements(false);
    }

    private static native byte[] getStokenElements(boolean var0);
}

