/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws390.orb.ORB;
import com.ibm.ws390.orb.PartnerVersion;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.IOP.ServiceContext;

public class ResponseHandlerImpl
implements ResponseHandler {
    static TraceComponent tc = Tr.register(ResponseHandlerImpl.class, "ORB", null);
    protected CDROutputStream responseBuffer = null;
    public static final int NoReply = -1;
    public static final int NO_EXCEPTION = 0;
    public static final int USER_EXCEPTION = 1;
    public static final int SYSTEM_EXCEPTION = 2;
    public static final int LOCATION_FORWARD = 3;
    public static final int UNKNOWN_EXCEPTION = 999;
    public int responseStatus = -1;
    public SystemException systemException = null;
    protected byte giop_major;
    protected byte giop_minor;
    protected int charEncodingId;
    protected int wcharEncodingId;
    private boolean outEndian;
    private boolean isPassthru;
    private short partner_version_extended = 0;
    private short partner_version_major = 0;
    private short partner_version_minor = 0;
    private byte customMaxStreamFormatForReply;
    private boolean isHTTP_Request;
    private int initialSize = 0;
    private final com.ibm.CORBA.iiop.ORB orb;
    private boolean useDefault = false;

    protected static ResponseHandlerImpl getHandler(ResponseHandlerImpl responseHandlerImpl) {
        if (responseHandlerImpl == null) {
            responseHandlerImpl = new ResponseHandlerImpl();
        }
        return responseHandlerImpl;
    }

    ResponseHandlerImpl(boolean bl, boolean bl2, int n, int n2, short s, byte by, boolean bl3) {
        this.orb = (ORB)GlobalORBFactory.globalORB();
        this.outEndian = bl;
        this.isPassthru = bl2;
        this.charEncodingId = n;
        this.wcharEncodingId = n2;
        this.giop_major = (byte)(s >>> 8);
        this.giop_minor = (byte)s;
        this.customMaxStreamFormatForReply = this.validatedMaxStreamFormat(by);
        this.isHTTP_Request = bl3;
    }

    ResponseHandlerImpl(com.ibm.CORBA.iiop.ORB oRB, boolean bl, int n, int n2, short s, byte by, PartnerVersion partnerVersion) {
        this.orb = oRB == null ? GlobalORBFactory.globalORB() : oRB;
        this.isPassthru = false;
        this.isHTTP_Request = false;
        this.outEndian = bl;
        this.charEncodingId = n;
        this.wcharEncodingId = n2;
        this.giop_major = (byte)(s >>> 8);
        this.giop_minor = (byte)s;
        this.customMaxStreamFormatForReply = this.validatedMaxStreamFormat(by);
        this.partner_version_extended = partnerVersion.extract_pv_extended();
        this.partner_version_major = partnerVersion.extract_pv_major();
        this.partner_version_minor = partnerVersion.extract_pv_minor();
    }

    ResponseHandlerImpl() {
        this.orb = GlobalORBFactory.globalORB();
        this.isPassthru = false;
        this.isHTTP_Request = false;
        this.useDefault = true;
    }

    protected byte[] getBytes() {
        return this.responseBuffer.toByteArray();
    }

    public CDRInputStream getParameterInputStream(byte[] byArray, int n) {
        CDRInputStream cDRInputStream = null;
        if (byArray != null && byArray.length > 0) {
            cDRInputStream = com.ibm.CORBA.iiop.ORB.createCDRInputStream((com.ibm.CORBA.iiop.ORB)this.orb, (byte[])byArray, (int)byArray.length, (boolean)this.outEndian, (int)this.charEncodingId, (int)this.wcharEncodingId);
            cDRInputStream.setGIOPVersions(this.giop_major, this.giop_minor, this.partner_version_major, this.partner_version_minor, this.partner_version_extended);
            if (n > 7) {
                cDRInputStream.read_long();
                n -= 4;
            }
            if (n > 3) {
                cDRInputStream.read_long();
                n -= 4;
            }
            if (n > 1) {
                cDRInputStream.read_short();
                n -= 2;
            }
            if (n > 0) {
                cDRInputStream.read_octet();
            }
        }
        return cDRInputStream;
    }

    public OutputStream createReply(int n) {
        this.initialSize = Math.max(n + 16, this.orb.getLargeDataBufferSize());
        return this.createReply();
    }

    public OutputStream createReply() {
        this.responseStatus = 0;
        this.createOutputStream();
        return this.responseBuffer;
    }

    public OutputStream createExceptionReply() {
        this.responseStatus = 1;
        this.createOutputStream();
        return this.responseBuffer;
    }

    public OutputStream createSystemExceptionReply(SystemException systemException) {
        this.responseStatus = 2;
        this.systemException = systemException;
        this.createOutputStream();
        this.responseBuffer.writeSystemException(systemException);
        return this.responseBuffer;
    }

    byte[] createSystemExceptionReplyBytes(SystemException systemException) {
        CDROutputStream cDROutputStream = (CDROutputStream)this.createSystemExceptionReply(systemException);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return byArray;
    }

    public OutputStream createUnknownExceptionReply(UnknownException unknownException) {
        return this.createUnknownExceptionReply(unknownException, null);
    }

    public OutputStream createUnknownExceptionReply(UnknownException unknownException, ExtendedServerRequestInfo extendedServerRequestInfo) {
        String string;
        this.responseStatus = 999;
        this.systemException = unknownException;
        this.createOutputStream();
        if (extendedServerRequestInfo != null) {
            CDROutputStream cDROutputStream = com.ibm.CORBA.iiop.ORB.createCDROutputStream((com.ibm.CORBA.iiop.ORB)this.orb, (boolean)this.outEndian);
            cDROutputStream.setGIOPVersions(this.giop_major, this.giop_minor, this.partner_version_major, this.partner_version_minor, this.partner_version_extended, this.customMaxStreamFormatForReply);
            cDROutputStream.putEndian();
            cDROutputStream.write_value((Serializable)unknownException.originalEx);
            string = new ServiceContext(9, cDROutputStream.toByteArray());
            extendedServerRequestInfo.add_reply_service_context((ServiceContext)string, true);
        }
        int n = 0;
        n = unknownException.originalEx instanceof RemoteException ? -910010480 : -910010465;
        string = RasHelper.throwableToString(unknownException);
        UNKNOWN uNKNOWN = new UNKNOWN(string, n, CompletionStatus.COMPLETED_NO);
        this.responseBuffer.writeSystemException((SystemException)uNKNOWN);
        this.responseBuffer.putEndian();
        this.responseBuffer.write_value((Serializable)unknownException.originalEx);
        return this.responseBuffer;
    }

    byte[] createUnknownExceptionReplyBytes(UnknownException unknownException) {
        return this.createUnknownExceptionReplyBytes(unknownException, null);
    }

    byte[] createUnknownExceptionReplyBytes(UnknownException unknownException, ExtendedServerRequestInfo extendedServerRequestInfo) {
        CDROutputStream cDROutputStream = (CDROutputStream)this.createUnknownExceptionReply(unknownException, extendedServerRequestInfo);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return byArray;
    }

    public void set_pv_extended(short s) {
        this.partner_version_extended = s;
    }

    public void set_pv_major(short s) {
        this.partner_version_major = s;
    }

    public void set_pv_minor(short s) {
        this.partner_version_minor = s;
    }

    private void createOutputStream() {
        if (this.useDefault) {
            this.responseBuffer = com.ibm.CORBA.iiop.ORB.createCDROutputStream();
        } else {
            this.responseBuffer = com.ibm.CORBA.iiop.ORB.createCDROutputStream((com.ibm.CORBA.iiop.ORB)this.orb, (boolean)this.outEndian, (int)this.initialSize);
            this.responseBuffer.enableLargeDataBufferPool();
            if (this.charEncodingId != 0 || this.wcharEncodingId != 0) {
                this.responseBuffer.setCodeSets(this.charEncodingId, this.wcharEncodingId);
            }
            if (!this.isHTTP_Request) {
                this.responseBuffer.setGIOPVersions(this.giop_major, this.giop_minor, this.partner_version_major, this.partner_version_minor, this.partner_version_extended, this.customMaxStreamFormatForReply);
            }
        }
        this.responseBuffer.write_long(this.responseStatus);
        this.responseBuffer.write_long(0);
    }

    public byte getCustomMaxStreamFormatForReply() {
        return this.customMaxStreamFormatForReply;
    }

    private byte validatedMaxStreamFormat(byte by) {
        byte by2 = by;
        byte by3 = com.ibm.CORBA.iiop.ORB.getMaximumCustomMarshalStreamFormatVersion();
        if (by2 > by3) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ResponseHandlerImpl.validatedMaxStreamFormat", new Object[]{"SFV reduced to max supported by our ORB", "Target SFV = " + by2, "ORB SFV = " + by3});
            }
            by2 = by3;
        }
        return by2;
    }
}

