/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.orb.ORB;
import com.ibm.ws390.utility.ws390FileUtilities;
import com.ibm.ws390.ziop.ServiceContextManager;

public class ORBRServiceContextCache {
    private static final TraceComponent tc;
    public static final boolean PROPAGATE_UNKNOWN_SERVICE_CONTEXTS;
    public static final boolean PROPAGATE_WLM_ENCLAVE_TOKEN;
    private static ThreadLocal threadLocalCache;
    private static final int IBM_VSCID = 1229081856;
    private static final int MIN_OMG_VSCID = 0;
    private static final int MAX_OMG_VSCID = 3840;
    private ServiceContextManager scMgr = new ServiceContextManager();
    private byte[] wlmEnclaveToken = null;

    public static ORBRServiceContextCache createNewCache() {
        ORBRServiceContextCache oRBRServiceContextCache = new ORBRServiceContextCache();
        threadLocalCache.set(oRBRServiceContextCache);
        return oRBRServiceContextCache;
    }

    public static ORBRServiceContextCache getCache() {
        return (ORBRServiceContextCache)threadLocalCache.get();
    }

    public static void removeCache() {
        threadLocalCache.remove();
    }

    protected ORBRServiceContextCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ORBRServiceContextCache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ORBRServiceContextCache");
        }
    }

    public void processIncomingContext(ServiceContext[] serviceContextArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processIncomingContext", serviceContextArray);
        }
        if (serviceContextArray != null) {
            for (int i = 0; i < serviceContextArray.length; ++i) {
                ServiceContext serviceContext = serviceContextArray[i];
                if (serviceContext == null) continue;
                int n = serviceContext.getId() & 0xFFFFFF00;
                if (serviceContext.getId() == 1229081890) {
                    this.scMgr.add(serviceContext, true);
                }
                if (n == 1229081856 || n <= 3840 && n >= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caching service context with id:", new Integer(serviceContext.getId()));
                }
                this.scMgr.add(serviceContext, true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processIncomingContext", this.scMgr);
        }
    }

    public void setServiceContext(int n, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServiceContext", new Integer(n));
        }
        ServiceContext serviceContext = ORB.createServiceContext((int)n, (byte[])byArray);
        this.scMgr.add(serviceContext, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServiceContext", byArray);
        }
    }

    public ServiceContext getServiceContext(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceContext", new Integer(n));
        }
        ServiceContext serviceContext = this.scMgr.get(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceContext", serviceContext);
        }
        return serviceContext;
    }

    public byte[] getServiceContextData(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceContextData", new Integer(n));
        }
        byte[] byArray = null;
        ServiceContext serviceContext = this.scMgr.get(n);
        if (serviceContext != null) {
            byArray = serviceContext.getContextData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceContextData", byArray);
        }
        return byArray;
    }

    public ServiceContext[] getServiceContexts() {
        return this.scMgr.get();
    }

    public void setWlmEnclaveToken(byte[] byArray) {
        this.wlmEnclaveToken = byArray;
    }

    public byte[] getWlmEnclaveToken() {
        return this.wlmEnclaveToken;
    }

    static {
        String string;
        tc = Tr.register(ORBRServiceContextCache.class, "ORB", null);
        threadLocalCache = new ThreadLocal();
        boolean bl = false;
        try {
            string = ws390FileUtilities.getenv((String)"protocol_iiop_propagate_unknown_service_ctxs");
            if (string != null && string.length() != 0 && Integer.parseInt(string) == 1) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PROPAGATE_UNKNOWN_SERVICE_CONTEXTS = bl;
        bl = true;
        try {
            string = ws390FileUtilities.getenv((String)"protocol_iiop_local_propagate_wlm_enclave");
            if (string != null && string.length() != 0 && Integer.parseInt(string) == 0) {
                bl = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PROPAGATE_WLM_ENCLAVE_TOKEN = bl;
    }
}

