/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.JVMListenerInterface;
import java.util.LinkedList;

public class JVMListenerNotifier {
    private static final char[] charValues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final TraceComponent tc = Tr.register(JVMListenerNotifier.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    private static LinkedList Listenerlist = new LinkedList();

    private static native void setListenerHandle();

    public static synchronized void registerListener(JVMListenerInterface jVMListenerInterface) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JVMListenerNotifier::registerLister(..)");
        }
        Listenerlist.add(jVMListenerInterface);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JVMListenerNotifier::registerLister(..)");
        }
    }

    public static void servantTerminated(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JVMListenerNotifier::servantTerminated", byArray);
        }
        String string = null;
        if (byArray != null && byArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                int n = (byArray[i] & 0xF0) / 16;
                int n2 = byArray[i] & 0xF;
                stringBuffer.append(charValues[n]);
                stringBuffer.append(charValues[n2]);
            }
            string = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stringStoken", string);
            }
            for (JVMListenerInterface jVMListenerInterface : Listenerlist) {
                try {
                    jVMListenerInterface.servantTerminated(string);
                }
                catch (Exception exception) {
                    Tr.error(tc, "Unable to invoke listener", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JVMListenerNotifier::servantTerminated");
        }
    }

    static {
        String string = System.getProperty("com.ibm.vm.bitmode");
        int n = Integer.parseInt(string);
        if (n == 64) {
            System.loadLibrary("bbgojmx");
        } else {
            System.loadLibrary("bboojmx");
        }
        JVMListenerNotifier.setListenerHandle();
    }
}

