/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.CodeSetComponentInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ServerSubcontract;
import com.ibm.CORBA.iiop.ServiceContextList;
import com.ibm.CORBA.iiop.SubcontractRegistry;
import com.ibm.CORBA.poa.POAServerDelegate;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmi.pi.ServerRequestInfoImpl;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws390.channel.ziop.ORBServiceContextFilter;
import com.ibm.ws390.channel.ziop.ZIOPMessageContext;
import com.ibm.ws390.orb.Constants;
import com.ibm.ws390.orb.PartnerVersion;
import com.ibm.ws390.orb.ResponseHandlerImpl;
import com.ibm.ws390.orb.ServiceContextUtils;
import com.ibm.ws390.orb.WS390InterceptorManager;
import com.ibm.ws390.orb.parameters.ORBEJSBridgeInvoke;
import com.ibm.ws390.ziop.ServiceContextManager;
import com.ibm.ws390.ziop.ZIOPConnectionState;
import com.ibm.ws390.ziop.ZIOPConnectionStateElement;
import com.ibm.wsspi.iiop.channel.ConnectionStateElement;
import java.nio.ByteBuffer;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.IOP.ServiceContext;

public class ClientCallbackDispatch
extends ORBEJSBridgeInvoke {
    private static final String ME = ClientCallbackDispatch.class.getName();
    private static final TraceComponent tc = Tr.register(ME, Constants.ORB_TR_GROUP, null);
    private static final PartnerVersion callback_pv = new PartnerVersion();
    public ByteBuffer objKeyData = null;
    public ByteBuffer scDataOutbound = null;
    protected boolean isPOAObject = false;
    protected boolean attemptedRequestInterceptors = false;
    protected ORB invoke_orb = null;
    protected ConnectionHandle connID = null;
    protected ZIOPConnectionStateElement connState = null;
    protected CDRInputStream paramStream = null;
    protected ExtendedServerRequestInfo sri = null;
    protected Throwable responseException = null;
    protected com.ibm.CORBA.iiop.ServiceContext[] scInboundList = null;
    protected ObjectKey objectKey = null;
    protected Object servant = null;
    protected ServerSubcontract serverSC = null;
    protected ResponseHandlerImpl rh = null;
    private static boolean cachedContexts = false;
    private static ORBServiceContextFilter contextFilter = null;
    private static ServiceContext localPVContext = null;
    private static ServiceContext localMaxStreamVersion = null;
    private static ServiceContext localSendingRuntimeContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] invoke(String string, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, byte[] byArray, byte[] byArray2, short s, short s2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", new Object[]{string});
        }
        this.operation = string;
        this.objKeyData = byteBuffer;
        this.scDataInbound = byteBuffer2;
        this.scDataOutbound = null;
        this.connectionHandle = byArray;
        this.params = byArray2;
        this.pad = s;
        this.endian = bl;
        this.req_giop_version = s2;
        byte[] byArray3 = null;
        CDROutputStream cDROutputStream = null;
        try {
            this.connID = new ConnectionHandle(this.connectionHandle);
            this.connState = ZIOPConnectionState.checkConnection((ConnectionHandle)this.connID);
            if (this.connState == null || !this.connState.isConnectionHealthy()) {
                throw new COMM_FAILURE("Connection is null or broken: " + this.connState, -910010564, CompletionStatus.COMPLETED_NO);
            }
            this.invoke_orb = this.connState.getORB();
            if (this.invoke_orb == null) {
                throw new INTERNAL("No ORB found for this connection: " + this.connState, -910010568, CompletionStatus.COMPLETED_NO);
            }
            this.runInboundContextInterceptors();
            this.createStreamHandlers();
            this.getServant();
            cDROutputStream = this.dispatch();
            byArray3 = cDROutputStream.toByteArray();
            cDROutputStream.releaseBuffer();
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "invoke Object Not Exist", (Object)oBJECT_NOT_EXIST);
            }
            this.rh = ResponseHandlerImpl.getHandler(this.rh);
            byArray3 = this.rh.createSystemExceptionReplyBytes((SystemException)oBJECT_NOT_EXIST);
        }
        catch (Throwable throwable) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "invoke Unexpected Exception", throwable);
            }
            this.rh = ResponseHandlerImpl.getHandler(this.rh);
            if (throwable instanceof SystemException) {
                SystemException systemException = (SystemException)throwable;
                byArray3 = this.rh.createSystemExceptionReplyBytes(systemException);
            } else {
                UnknownException unknownException = new UnknownException(throwable);
                byArray3 = this.rh.createUnknownExceptionReplyBytes(unknownException, this.sri);
            }
        }
        finally {
            this.runOutboundContextInterceptors();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", byArray3);
        }
        return byArray3;
    }

    protected CDROutputStream dispatch() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispatch()", new Object[]{this.servant, this.operation});
        }
        Throwable throwable = null;
        CDROutputStream cDROutputStream = null;
        try {
            if (this.operation.equals("_is_a")) {
                boolean bl = this.objectIsA();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dispatch()", "operation = _is_a " + String.valueOf(bl));
                }
                cDROutputStream = (CDROutputStream)this.rh.createReply();
                cDROutputStream.write_boolean(bl);
            } else if (this.operation.equals("_non_existent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dispatch()", "operation = _non_existent " + (this.servant == null));
                }
                cDROutputStream = (CDROutputStream)this.rh.createReply();
                cDROutputStream.write_boolean(this.servant == null);
            } else if (this.operation.equals("_interface")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dispatch()", "operation = _interface ");
                }
                NO_IMPLEMENT nO_IMPLEMENT = new NO_IMPLEMENT("_interface is not supported", -910010565, CompletionStatus.COMPLETED_NO);
                cDROutputStream = (CDROutputStream)this.rh.createSystemExceptionReply((SystemException)nO_IMPLEMENT);
            } else {
                this.attemptedRequestInterceptors = true;
                WS390InterceptorManager.interceptInboundRequest(this.invoke_orb, this.sri);
                cDROutputStream = (CDROutputStream)((InvokeHandler)this.servant)._invoke(this.operation, (InputStream)this.paramStream, (ResponseHandler)this.rh);
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "dispatch() Bad Operation", (Object)bAD_OPERATION);
            }
            throwable = bAD_OPERATION;
            this.rh = ResponseHandlerImpl.getHandler(this.rh);
            cDROutputStream = (CDROutputStream)this.rh.createSystemExceptionReply((SystemException)bAD_OPERATION);
        }
        catch (UnknownException unknownException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "dispatch() Unknown User Eception", (Object)unknownException);
            }
            throwable = unknownException;
            this.rh = ResponseHandlerImpl.getHandler(this.rh);
            cDROutputStream = (CDROutputStream)this.rh.createUnknownExceptionReply(unknownException, this.sri);
        }
        catch (ThreadDeath threadDeath) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "dispatch() Thread Death", threadDeath);
            }
            throwable = threadDeath;
            throw threadDeath;
        }
        catch (Throwable throwable2) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "exception occurred in dispatch", throwable2);
            }
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (this.attemptedRequestInterceptors) {
                WS390InterceptorManager.interceptOutboundResponse(this.invoke_orb, this.sri, throwable, this.rh);
            }
            if (this.isPOAObject) {
                ((POAServerDelegate)this.serverSC).releasePOAServant(this.servant, this.objectKey, this.sri);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispatch()");
        }
        return cDROutputStream;
    }

    protected void createStreamHandlers() throws Exception {
        if (this.req_tcsc == 0 || this.req_tcsw == 0) {
            throw new INTERNAL("Unable to create data streams; codeSet information is missing (tcsc=" + this.req_tcsc + ",tcsw=" + this.req_tcsw + ")", -910010567, CompletionStatus.COMPLETED_NO);
        }
        PartnerVersion partnerVersion = PartnerVersion.getPartnerVersion(this.req_pv_major, this.req_pv_minor, this.req_pv_extended, this.req_pv_status, callback_pv);
        this.rh = new ResponseHandlerImpl(this.invoke_orb, this.endian, this.req_tcsc, this.req_tcsw, this.req_giop_version, this.customMaxStreamFormatForReply, partnerVersion);
        this.paramStream = this.rh.getParameterInputStream(this.params, this.pad);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createStreamHandlers", new Object[]{"PartnerVersion", "Client(remote) = " + partnerVersion.toString(), "Server(this) = " + callback_pv.toString()});
        }
    }

    protected void getServant() throws Exception {
        this.objectKey = this.invoke_orb.createObjectKey(this.objKeyData);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServant", this.objectKey);
        }
        SubcontractRegistry subcontractRegistry = this.invoke_orb.getSubcontractRegistry();
        if (this.objectKey != null && subcontractRegistry != null) {
            this.serverSC = subcontractRegistry.getServerSubcontract(this.objectKey);
            if (this.serverSC != null) {
                if (this.serverSC.isServantSupported()) {
                    this.servant = this.serverSC.getServant(this.objectKey);
                } else {
                    this.servant = ((POAServerDelegate)this.serverSC).getPOAServant(this.objectKey, this.sri);
                    this.isPOAObject = true;
                }
            }
        }
        if (this.servant == null && !this.isPOAObject && !this.operation.equals("_non_existent")) {
            throw new OBJECT_NOT_EXIST("Requested Object does not exist: " + this.objectKey, -910010566, CompletionStatus.COMPLETED_NO);
        }
        if (this.servant != null && this.sri instanceof ServerRequestInfoImpl) {
            ((ServerRequestInfoImpl)this.sri).setTarget(this.servant);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServant", new Object[]{this.servant, Boolean.toString(this.isPOAObject)});
        }
    }

    protected ExtendedServerRequestInfo runInboundContextInterceptors() throws Throwable {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "runInboundContextInterceptors parsing contexts", this.invoke_orb);
        }
        if (!cachedContexts) {
            ClientCallbackDispatch.initializeContexts(this.invoke_orb);
        }
        ServiceContextManager serviceContextManager = new ServiceContextManager(this.scDataInbound, this.endian);
        ZIOPMessageContext zIOPMessageContext = new ZIOPMessageContext();
        zIOPMessageContext.setServiceContexts((ServiceContextList)serviceContextManager);
        zIOPMessageContext.setType(0);
        contextFilter.processIncomingContext(this.invoke_orb, (GIOPMessageContext)zIOPMessageContext, (GIOPConnectionContext)this.connState.getConnectionContext(), (ConnectionStateElement)this.connState);
        this.scInboundList = ServiceContextUtils.consumeServiceContexts(this.invoke_orb, serviceContextManager, this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "runInboundContextInterceptors", this.scInboundList.length + " inbound contexts");
        }
        this.sri = WS390InterceptorManager.prepareServerRequestInfo(this.invoke_orb, this.operation, this.scInboundList, this.connID);
        WS390InterceptorManager.interceptInboundContexts(this.invoke_orb, this.sri);
        return this.sri;
    }

    protected void runOutboundContextInterceptors() {
        block7: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "runOutboundContextInterceptors marshalling contexts", this.invoke_orb);
            }
            if (this.sri == null) {
                return;
            }
            try {
                if (!cachedContexts) {
                    ClientCallbackDispatch.initializeContexts(this.invoke_orb);
                }
                this.sri.add_reply_service_context(localPVContext, true);
                this.sri.add_reply_service_context(localMaxStreamVersion, true);
                if (this.invoke_orb.getCbSupported() && localSendingRuntimeContext != null) {
                    this.sri.add_reply_service_context(localSendingRuntimeContext, true);
                }
                CodeSetComponentInfo.CodeSetContext codeSetContext = ORB.createCodeSetContext((int)this.req_tcsc, (int)this.req_tcsw);
                com.ibm.CORBA.iiop.ServiceContext[] serviceContextArray = this.sri.getReplyServiceContextList();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "runOutboundContextInterceptors", serviceContextArray.length + " outbound contexts");
                }
                this.scDataOutbound = ServiceContextManager.marshalServiceContextData((com.ibm.CORBA.iiop.ServiceContext[])serviceContextArray, (boolean)this.endian);
            }
            catch (Exception exception) {
                if (!tc.isEventEnabled()) break block7;
                Tr.event(tc, "Exception while marshalling outbound contexts", exception);
            }
        }
    }

    protected boolean objectIsA() {
        if (this.paramStream == null || this.paramStream.isAtEnd()) {
            return false;
        }
        String string = this.paramStream.read_string();
        for (int i = 0; i < ((ObjectImpl)this.servant)._ids().length; ++i) {
            if (!((ObjectImpl)this.servant)._ids()[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private static synchronized void initializeContexts(ORB oRB) {
        if (cachedContexts) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeContexts");
        }
        contextFilter = ORBServiceContextFilter.instance();
        localPVContext = ServiceContextUtils.getPVServiceContext(oRB);
        localMaxStreamVersion = ServiceContextUtils.getCustomMaxStreamFormatContext(oRB);
        localSendingRuntimeContext = ServiceContextUtils.getSendingRuntimeContext(oRB);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeContexts");
        }
    }
}

