/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.jms.listener.WS390EndPointClassificationInfo;
import com.ibm.ejs.jms.listener.WS390EndPointClassificationParser;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.orb.SibClassificationParser;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ClassificationParser
implements ErrorHandler {
    private static final String DEFAULTCLASSIFICATION_STRING = "defaultclassification";
    private static final String NAME_STRING = "name";
    private static final String CLASSIFICATION_STRING = "classification";
    private static final String SELECTOR_STRING = "selector";
    private static final String CLASSIFICATIONENTRY_STRING = "classificationentry";
    private static final short iiop_type = 1;
    private static final short http_type = 2;
    private static final short mdb_type = 3;
    private static final short internal_type = 4;
    private static final short sip_type = 5;
    private static boolean got_iiop = false;
    private static boolean got_http = false;
    private static boolean got_mdb = false;
    private static boolean got_internal = false;
    private static boolean got_sip = false;
    private static TraceComponent tc;

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Error parsing WLM classification XML " + sAXParseException);
        }
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Fatal error parsing WLM classification XML " + sAXParseException);
        }
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Warning parsing WLM classification XML " + sAXParseException);
        }
    }

    private static native void createIIOPRoot(String var0);

    private static native void makeIIOPChild(String var0, String var1, String var2, String var3, String var4, String var5, String var6);

    private static native void goUpIIOP();

    private static native void createHTTPRoot(String var0);

    private static native void goUpHTTP();

    private static native void makeHTTPChild(String var0, String var1, String var2, String var3, String var4);

    private static native void createInternalRoot(String var0);

    private static native void createSIPRoot(String var0);

    private static native void parseError();

    private static String validatetc(String string) {
        if (string.length() > 8) {
            throw new IllegalArgumentException("Transaction Class " + string + " is greater than 8 bytes long");
        }
        return string;
    }

    private static void iterateChildren(Element element, short s) {
        NodeList nodeList = element.getChildNodes();
        block7: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "iterateChildren node #" + i);
            }
            if ((node = nodeList.item(i)) == null || node.getNodeType() != 1) continue;
            switch (s) {
                case 1: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "iterateChildren node is IIOP, adding element");
                    }
                    ClassificationParser.addIIOPElement((Element)node);
                    continue block7;
                }
                case 2: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "iterateChildren node is HTTP, adding element");
                    }
                    ClassificationParser.addHTTPElement((Element)node);
                    continue block7;
                }
                case 3: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "iterateChildren node is MDB, adding element");
                    }
                    ClassificationParser.addMDBElement((Element)node);
                    continue block7;
                }
                case 4: {
                    throw new IllegalArgumentException("Internal node should have no child nodes");
                }
                case 5: {
                    throw new IllegalArgumentException("SIP node should have no child nodes");
                }
            }
        }
    }

    private static void addIIOPElement(Element element) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding IIOP element");
        }
        ClassificationParser.makeIIOPChild(ClassificationParser.validatetc(element.getAttribute("transaction_class")), element.getAttribute("application_name"), element.getAttribute("module_name"), element.getAttribute("component_name"), element.getAttribute("method_name"), element.getAttribute("activity_workload_classification"), element.getAttribute("description"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added IIOP element, iterating children");
        }
        ClassificationParser.iterateChildren(element, (short)1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Going up (IIOP)");
        }
        ClassificationParser.goUpIIOP();
    }

    private static void addHTTPElement(Element element) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding HTTP element");
        }
        ClassificationParser.makeHTTPChild(ClassificationParser.validatetc(element.getAttribute("transaction_class")), element.getAttribute("uri"), element.getAttribute("host"), element.getAttribute("port"), element.getAttribute("description"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added HTTP element, iterating children");
        }
        ClassificationParser.iterateChildren(element, (short)2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Going up (HTTP)");
        }
        ClassificationParser.goUpHTTP();
    }

    private static void addMDBElement(Element element) {
        NodeList nodeList;
        String string = element.getAttribute(NAME_STRING);
        WS390EndPointClassificationInfo wS390EndPointClassificationInfo = new WS390EndPointClassificationInfo(string);
        wS390EndPointClassificationInfo.setDefaultClassificationString(ClassificationParser.validatetc(element.getAttribute(DEFAULTCLASSIFICATION_STRING)));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting up epci name=" + string + " default=" + element.getAttribute(DEFAULTCLASSIFICATION_STRING));
        }
        if ((nodeList = element.getElementsByTagName(CLASSIFICATIONENTRY_STRING)) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (element2 == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding to epci name=" + string + " selector=" + element2.getAttribute(SELECTOR_STRING) + " classification=" + element2.getAttribute(CLASSIFICATION_STRING));
                }
                wS390EndPointClassificationInfo.addEntry(element2.getAttribute(SELECTOR_STRING), ClassificationParser.validatetc(element2.getAttribute(CLASSIFICATION_STRING)));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding MDB classification name=" + string);
        }
        WS390EndPointClassificationParser.getInstance().addClassification(string, wS390EndPointClassificationInfo);
    }

    private static Element validateXML(String string, String string2) {
        Document document = null;
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        Element element = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ClassificationParser());
            document = documentBuilder.parse(new FileInputStream(string), string2);
            element = document.getDocumentElement();
            if (element != null) {
                if (!element.getTagName().equals("Classification")) {
                    throw new IllegalArgumentException("root node is wrong tag");
                }
                if (!element.getAttribute("schema_version").equals("1.0")) {
                    throw new IllegalArgumentException("unsupported version of Classification");
                }
            }
        }
        catch (Exception exception) {
            Tr.audit(tc, "BBOJ0085", exception.toString());
            element = null;
        }
        return element;
    }

    public static void parseClassificationXML(String string, String string2) {
        Element element;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parsing classification XML " + string + " via " + string2);
        }
        if ((element = ClassificationParser.validateXML(string, string2)) != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "XML valid, fetching nodes");
                }
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2;
                    String string3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing node #" + i);
                    }
                    if (nodeList.item(i).getNodeType() != 1) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "node is an element");
                    }
                    if ((string3 = (element2 = (Element)nodeList.item(i)).getTagName()).equals("InboundClassification")) {
                        if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) continue;
                        ClassificationParser.parseInboundClassification(element2);
                        continue;
                    }
                    if (string3.equals("SibClassification")) {
                        SibClassificationParser.getInstance().parse(element2);
                        continue;
                    }
                    throw new IllegalArgumentException("Node inside root is not InboundClassification or SibClassification");
                }
            }
            catch (Exception exception) {
                Tr.audit(tc, "BBOJ0085", exception.toString());
                ClassificationParser.parseError();
                WS390EndPointClassificationParser.getInstance().parseError();
                SibClassificationParser.getInstance().clear();
            }
        }
    }

    private static void parseInboundClassification(Element element) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parsing InboundClassification");
        }
        if (!element.getAttribute("schema_version").equals("1.0")) {
            throw new IllegalArgumentException("unsupported version of InboundClassification");
        }
        String string = element.getAttribute("type");
        if (string.equals("iiop")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IIOP classification element");
            }
            if (got_iiop) {
                throw new IllegalArgumentException("more than one IIOP classification section found");
            }
            got_iiop = true;
            String string2 = ClassificationParser.validatetc(element.getAttribute("default_transaction_class"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating IIOP root tc=" + string2);
            }
            ClassificationParser.createIIOPRoot(string2);
            ClassificationParser.iterateChildren(element, (short)1);
        } else if (string.equals("mdb")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MDB classification element");
            }
            if (got_mdb) {
                throw new IllegalArgumentException("more than one MDB classification section found");
            }
            got_mdb = true;
            String string3 = ClassificationParser.validatetc(element.getAttribute("default_transaction_class"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting MDB default tc=" + string3);
            }
            WS390EndPointClassificationParser.getInstance().setMDB_DEFAULT_CLASSIFICATION(string3);
            ClassificationParser.iterateChildren(element, (short)3);
        } else if (string.equals("http")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HTTP classification element");
            }
            if (got_http) {
                throw new IllegalArgumentException("more than one HTTP classification section found");
            }
            got_http = true;
            String string4 = ClassificationParser.validatetc(element.getAttribute("default_transaction_class"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating HTTP root tc=" + string4);
            }
            ClassificationParser.createHTTPRoot(string4);
            ClassificationParser.iterateChildren(element, (short)2);
        } else if (string.equals("internal")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Internal classification element");
            }
            if (got_internal) {
                throw new IllegalArgumentException("more than one Internal classification section found");
            }
            got_internal = true;
            String string5 = ClassificationParser.validatetc(element.getAttribute("default_transaction_class"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating Internal root tc=" + string5);
            }
            ClassificationParser.createInternalRoot(string5);
            ClassificationParser.iterateChildren(element, (short)4);
        } else if (string.equals("sip")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SIP classification element");
            }
            if (got_sip) {
                throw new IllegalArgumentException("more than one sip classification section found");
            }
            got_sip = true;
            String string6 = ClassificationParser.validatetc(element.getAttribute("default_transaction_class"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating sip root tc=" + string6);
            }
            ClassificationParser.createSIPRoot(string6);
            ClassificationParser.iterateChildren(element, (short)5);
        }
    }

    public static void clearFlags() {
        got_iiop = false;
        got_http = false;
        got_mdb = false;
        got_internal = false;
        got_sip = false;
    }

    static {
        String string = System.getProperty("com.ibm.vm.bitmode");
        int n = Integer.parseInt(string);
        if (n == 64) {
            System.loadLibrary("bbgboa");
        } else {
            System.loadLibrary("bboboa");
        }
        tc = Tr.register(ClassificationParser.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    }
}

