/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.orb.ORBEJSBridge;
import com.ibm.ws390.tx.TranAffinityRouterHelper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;

public class BOSSObjectKey
extends ObjectKey
implements com.ibm.ws.orb.BOSSObjectKey {
    private static final TraceComponent tc;
    static final int CKEY_EYE = -1009596952;
    static final int CLAS_EYE = -1009532446;
    static final int TYPE_EYE = -471279675;
    static final byte[] ORBK_EYE_BYTES;
    static final int SIZEOF_ORBK_LEN = 4;
    static final int orbk_id_OFFSET = 0;
    static final int orbk_scid_OFFSET = 4;
    static final int orbk_server_id_OFFSET = 8;
    static final int orbk_uuid_OFFSET = 12;
    static final int orbk_user_key_offset_OFFSET = 32;
    static final int orbk_user_key_length_OFFSET = 36;
    static final int orbk_user_key_OFFSET = 40;
    static final int orbk_version_OFFSET = 40;
    static final int orbk_generic_server_name_OFFSET = 44;
    static final int orbk_flags_OFFSET = 52;
    static final int orbk_other_data_pairs_OFFSET = 68;
    static final int orbk_variable_info_offset_OFFSET = 68;
    static final int orbk_variable_info_count_OFFSET = 72;
    static final int orbk_fixed_data_extension_offset_OFFSET = 76;
    static final int orbk_fixed_data_extension_count_OFFSET = 80;
    static final int orbk_flags_extension_offset_OFFSET = 84;
    static final int orbk_flags_extension_length_OFFSET = 88;
    static final int orbk_typeid_offset_OFFSET = 92;
    static final int orbk_typeid_length_OFFSET = 96;
    static final int orbk_class_offset_OFFSET = 100;
    static final int orbk_class_length_OFFSET = 104;
    static final int orbk_container_key_offset_OFFSET = 108;
    static final int orbk_container_key_length_OFFSET = 112;
    static final int orbk_amc_offset_OFFSET = 116;
    static final int orbk_amc_length_OFFSET = 120;
    static final int orbk_queue_by_stoken_offset_OFFSET = 124;
    static final int orbk_queue_by_stoken_length_OFFSET = 128;
    static final int orbk_queue_by_applenv_offset_OFFSET = 132;
    static final int orbk_queue_by_applenv_length_OFFSET = 136;
    static final int orbk_clusterid_offset_OFFSET = 140;
    static final int orbk_clusterid_length_OFFSET = 144;
    static final int orbk_fillers5_OFFSET = 148;
    static final int FILLER5_LEN = 48;
    static final int orbk_other_data_OFFSET = 196;
    private ByteBuffer m_nativeObjectKey = null;
    private ByteBuffer m_ObjectKey = null;
    private int m_orbk_len = 0;
    private int m_orbk_id = -690371886;
    private int m_orbk_scid = 16;
    private int m_orbk_serverid = 0;
    private byte[] m_UUID = null;
    private int m_user_key_offset = 40;
    private int m_user_key_length = 0;
    private int m_orbk_version = 3;
    private byte[] m_generic_server_name = null;
    private int m_orbk_flags = 0;
    private int m_orbk_flags2 = 0;
    private int m_orbk_flags3 = 0;
    private int m_orbk_flags4 = 0;
    private static final int VARIABLE_INFO_IDX = 0;
    private static final int FIXED_DATA_EXTENSION_IDX = 1;
    private static final int FLAGS_EXTENSION_IDX = 2;
    private static final int TYPEID_IDX = 3;
    private static final int CLASS_IDX = 4;
    private static final int CONTAINER_KEY_IDX = 5;
    private static final int AMC_IDX = 6;
    private static final int QUEUE_BY_STOKEN_IDX = 7;
    private static final int QUEUE_BY_APPLENV_IDX = 8;
    private static final int CLUSTERID_IDX = 9;
    private static final int NUM_OTHER_DATA_ELEMENTS = 10;
    private int[] m_other_data_offsets = new int[10];
    private int[] m_other_data_lengths = new int[10];
    private int[] m_other_data_addl_data_len = new int[]{0, 0, 0, 5, 5, 4, 4, 12, 4, 4};
    private byte[][] m_other_data_raw_data = new byte[10][];
    private String m_typeId = null;
    private String m_className = null;
    private String m_genericServerName = null;
    private String m_applenv = null;

    public BOSSObjectKey() {
    }

    public BOSSObjectKey(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.m_ObjectKey = byteBuffer;
        this.m_orbk_id = this.m_ObjectKey.getInt(0);
        if (this.m_orbk_id != -690371886) {
            throw new INV_OBJREF("Invalid object key for WebSphere Application Server for z/OS", -910010558, CompletionStatus.COMPLETED_NO);
        }
    }

    public BOSSObjectKey(byte[] byArray) {
        super(byArray);
        if (byArray.length > 0) {
            this.m_ObjectKey = ByteBuffer.wrap(byArray);
            this.m_orbk_id = this.m_ObjectKey.getInt(0);
            if (this.m_orbk_id != -690371886) {
                throw new INV_OBJREF("Invalid object key for WebSphere Application Server for z/OS", -910010559, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public BOSSObjectKey(String string, String string2, byte[] byArray, boolean bl, boolean bl2, boolean bl3, byte[] byArray2) {
        super(ORBK_EYE_BYTES);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BOSSObjectKey", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "className", string2);
            Tr.debug(tc, "containerKey", byArray);
        }
        this.m_className = string2;
        this.m_other_data_raw_data[4] = this.m_className.getBytes();
        this.m_typeId = string;
        this.m_other_data_raw_data[3] = this.m_typeId.getBytes();
        this.m_other_data_raw_data[5] = byArray;
        if (bl) {
            this.setFlag(0x20000000);
        }
        if (bl2) {
            this.setFlag(0x2000000);
        }
        if (bl3) {
            this.setFlag(0x400000);
        }
        if (TranAffinityRouterHelper.isTransactionalSystemObject((String)string)) {
            this.setFlag(131072);
            this.setFlag(0x20000000);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "m_orbk_flags", Integer.toHexString(this.m_orbk_flags));
        }
        this.m_other_data_raw_data[9] = byArray2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BOSSObjectKey");
        }
    }

    private int calculateSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateSize");
        }
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            if (this.m_other_data_raw_data[i] == null) continue;
            n += this.m_other_data_raw_data[i].length + this.m_other_data_addl_data_len[i];
            n = (n + 3) / 4 * 4;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "other_data_total_len", new Integer(n));
        }
        this.m_user_key_length = 156 + n;
        this.m_orbk_len = 40 + this.m_user_key_length;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateSize", new Integer(this.m_orbk_len));
        }
        return this.m_orbk_len;
    }

    private void allocateNativeDirect() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "allocateNativeDirect");
        }
        int n = this.calculateSize();
        n += 4;
        if (this.m_other_data_raw_data[5] == null) {
            n += 4 + this.m_other_data_addl_data_len[5];
        }
        this.m_nativeObjectKey = ByteBuffer.allocateDirect(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "allocateNativeDirect");
        }
    }

    private void sliceNativeDirect() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sliceNativeDirect");
        }
        this.m_nativeObjectKey.rewind();
        this.m_orbk_len = this.m_nativeObjectKey.getInt();
        this.m_ObjectKey = this.m_nativeObjectKey.slice();
        this.m_ObjectKey.limit(this.m_orbk_len);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sliceNativeDirect");
        }
    }

    private void debugPrint() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "m_nativeObjectKey", this.m_nativeObjectKey);
            this.getNativeBytes(false);
            Tr.debug(tc, "m_ObjectKey", this.m_ObjectKey);
            this.getBytes(false);
        }
    }

    protected void buildBOSSObjectKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildBOSSObjectKey");
        }
        if (this.m_ObjectKey != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "ReMarshaling the object key!!", this.m_ObjectKey);
        }
        this.allocateNativeDirect();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "m_orbk_flags", Integer.toHexString(this.m_orbk_flags));
        }
        BOSSObjectKey.buildBOSSObjectKey(this.m_nativeObjectKey, this.m_typeId, this.m_className, this.m_other_data_raw_data[5], this.m_orbk_flags, this.m_other_data_raw_data[9], this.m_other_data_raw_data[7], this.m_applenv);
        this.sliceNativeDirect();
        this.bufferToFlags();
        if (tc.isDebugEnabled()) {
            this.debugPrint();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildBOSSObjectKey");
        }
    }

    public byte[] getServerUUID() {
        if (this.m_UUID == null) {
            if (this.m_ObjectKey == null) {
                this.buildBOSSObjectKey();
            }
            this.m_UUID = new byte[20];
            this.m_ObjectKey.position(12);
            this.m_ObjectKey.get(this.m_UUID);
        }
        return this.m_UUID;
    }

    public int getSCID() {
        return this.m_orbk_scid;
    }

    public int getServerId() {
        return this.m_orbk_serverid;
    }

    public String getGenericServerName() {
        if (this.m_genericServerName == null) {
            if (this.m_generic_server_name == null) {
                if (this.m_ObjectKey == null) {
                    this.buildBOSSObjectKey();
                }
                this.m_generic_server_name = new byte[8];
                this.m_ObjectKey.position(44);
                this.m_ObjectKey.get(this.m_generic_server_name);
            }
            try {
                this.m_genericServerName = new String(this.m_generic_server_name, "Cp1047");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "getGenericServerName could not convert to Cp1047 encoding", unsupportedEncodingException);
                }
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return this.m_genericServerName;
    }

    public byte[] getContainerKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContainerKey");
        }
        if (this.m_other_data_raw_data[5] == null) {
            if (this.m_ObjectKey == null) {
                this.buildBOSSObjectKey();
            }
            if (this.m_other_data_offsets[5] == 0) {
                this.m_other_data_offsets[5] = this.m_ObjectKey.getInt(108);
                this.m_other_data_lengths[5] = this.m_ObjectKey.getInt(112);
            }
            if (this.m_other_data_offsets[5] != 0 && this.m_other_data_lengths[5] != 0) {
                this.m_other_data_raw_data[5] = new byte[this.m_other_data_lengths[5]];
                this.m_ObjectKey.position(this.m_other_data_offsets[5]);
                int n = this.m_ObjectKey.getInt();
                if (n != -1009596952) {
                    INV_OBJREF iNV_OBJREF = new INV_OBJREF("Invalid eye catcher for Container Key portion of a WebSphere Application Server for z/OS object key", -910010560, CompletionStatus.COMPLETED_NO);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "INV_OBJREF exception", iNV_OBJREF);
                    }
                    throw iNV_OBJREF;
                }
                this.m_ObjectKey.get(this.m_other_data_raw_data[5]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContainerKey", this.m_other_data_raw_data[5]);
        }
        return this.m_other_data_raw_data[5];
    }

    private byte[] getOtherDataRawData(int n, int n2, int n3, int n4, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOtherDataRawData");
        }
        if (this.m_other_data_raw_data[n] == null) {
            if (this.m_ObjectKey == null) {
                this.buildBOSSObjectKey();
            }
            if (this.m_other_data_offsets[n] == 0) {
                this.m_other_data_offsets[n] = this.m_ObjectKey.getInt(n2);
                this.m_other_data_lengths[n] = this.m_ObjectKey.getInt(n3);
            }
            if (this.m_other_data_offsets[n] != 0 && this.m_other_data_lengths[n] != 0) {
                int n5;
                int n6 = bl ? this.m_other_data_lengths[n] - 4 : this.m_other_data_lengths[n];
                this.m_other_data_raw_data[n] = new byte[n6];
                this.m_ObjectKey.position(this.m_other_data_offsets[n]);
                if (n4 != 0 && (n5 = this.m_ObjectKey.getInt()) != n4) {
                    INV_OBJREF iNV_OBJREF = new INV_OBJREF("Invalid Object Key Eye Catcher: expecting: " + n4 + "; found: " + n5, -910010560, CompletionStatus.COMPLETED_NO);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "INV_OBJREF exception", iNV_OBJREF);
                    }
                    throw iNV_OBJREF;
                }
                this.m_ObjectKey.get(this.m_other_data_raw_data[n]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOtherDataRawData", this.m_other_data_raw_data[n]);
        }
        return this.m_other_data_raw_data[n];
    }

    public void setFlag(int n) {
        this.m_orbk_flags |= n;
        this.flagsToBuffer();
    }

    public void resetFlag(int n) {
        this.m_orbk_flags &= ~n;
        this.flagsToBuffer();
    }

    public boolean getFlag(int n) {
        this.bufferToFlags();
        return (this.m_orbk_flags & n) != 0;
    }

    private void flagsToBuffer() {
        if (this.m_ObjectKey != null) {
            this.m_ObjectKey.putInt(52, this.m_orbk_flags);
        }
    }

    private void bufferToFlags() {
        if (this.m_ObjectKey != null) {
            this.m_orbk_flags = this.m_ObjectKey.getInt(52);
        }
    }

    public void addQueueByStokenData() {
        this.addQueueByStokenData(ORBEJSBridge.getStoken());
    }

    public void addQueueByStokenData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addQueueByStokenData", byArray);
        }
        this.m_other_data_raw_data[7] = byArray;
        if (this.m_ObjectKey != null && this.getFlag(0x200000)) {
            int n = this.m_ObjectKey.getInt(124);
            this.m_ObjectKey.position(n + 4 + 8);
            this.m_ObjectKey.put(byArray);
        } else {
            this.setFlag(0x200000);
            if (this.m_ObjectKey != null) {
                this.buildBOSSObjectKey();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addQueueByStokenData");
        }
    }

    public void addQueueByApplenvData(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addQueueByApplenvData", string);
        }
        this.setFlag(524288);
        this.m_applenv = string;
        this.m_other_data_raw_data[8] = string.getBytes();
        if (this.m_ObjectKey != null) {
            this.buildBOSSObjectKey();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addQueueByApplenvData");
        }
    }

    private byte[] getNativeBytes(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNativeBytes", new Boolean(bl));
        }
        byte[] byArray = null;
        if (this.m_nativeObjectKey == null && bl) {
            this.buildBOSSObjectKey();
        }
        if (this.m_nativeObjectKey != null) {
            int n = this.m_nativeObjectKey.position();
            this.m_nativeObjectKey.rewind();
            byArray = new byte[this.m_nativeObjectKey.remaining()];
            this.m_nativeObjectKey.get(byArray);
            this.m_nativeObjectKey.position(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNativeBytes", byArray);
        }
        return byArray;
    }

    public byte[] getBytes() {
        return this.getBytes(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBytes", new Boolean(bl));
        }
        byte[] byArray = null;
        if (this.m_ObjectKey == null && bl) {
            this.buildBOSSObjectKey();
        }
        if (this.m_ObjectKey != null) {
            BOSSObjectKey bOSSObjectKey = this;
            synchronized (bOSSObjectKey) {
                int n = this.m_ObjectKey.position();
                this.m_ObjectKey.rewind();
                byArray = new byte[this.m_ObjectKey.remaining()];
                this.m_ObjectKey.get(byArray);
                this.m_ObjectKey.position(n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBytes", byArray);
        }
        return byArray;
    }

    public int length() {
        if (this.m_ObjectKey == null) {
            this.buildBOSSObjectKey();
        }
        return this.m_ObjectKey.limit();
    }

    public void write(CDROutputStream cDROutputStream) {
        cDROutputStream.write_octet_array(this.getBytes(), 0, this.length());
    }

    public String getClassName() {
        if (this.m_className == null) {
            block5: {
                byte[] byArray = this.getOtherDataRawData(4, 100, 104, -1009532446, false);
                if (byArray != null) {
                    try {
                        this.m_className = new String(byArray, 0, byArray.length, "IBM037");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (!tc.isEventEnabled()) break block5;
                        Tr.event(tc, "caught UnsupportedEncodingException", unsupportedEncodingException);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retreived className from raw data", this.m_className);
            }
        }
        return this.m_className;
    }

    private static native void buildBOSSObjectKey(ByteBuffer var0, String var1, String var2, byte[] var3, int var4, byte[] var5, byte[] var6, String var7);

    static {
        String string = System.getProperty("com.ibm.vm.bitmode");
        int n = Integer.parseInt(string);
        if (n == 64) {
            System.loadLibrary("bbgorb");
        } else {
            System.loadLibrary("bboorb");
        }
        tc = Tr.register(BOSSObjectKey.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
        ORBK_EYE_BYTES = new byte[]{-42, -39, -62, -46};
    }
}

