/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.container.resref;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.container.resref.BaseResourceFactory;
import com.ibm.ws390.container.resref.ResourceInfo;
import com.ibm.ws390.container.resref.ResourceRefAddr;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MQJMSAdminObjectFactory
implements ObjectFactory {
    static TraceComponent tc = Tr.register(MQJMSAdminObjectFactory.class);
    private static Class JMSCClass = null;
    private static final String JMSCClassName = "com.ibm.mq.jms.JMSC";
    private static final String RRSQCFClassName = "com.ibm.mq.jms.MQRRSQueueConnectionFactory";
    private static final String RRSTCFClassName = "com.ibm.mq.jms.MQRRSTopicConnectionFactory";
    private static final String QCFClassName = "com.ibm.mq.jms.MQQueueConnectionFactory";
    private static final String TCFClassName = "com.ibm.mq.jms.MQTopicConnectionFactory";
    private static final String QueueClassName = "com.ibm.mq.jms.MQQueue";
    private static final String TopicClassName = "com.ibm.mq.jms.MQTopic";

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance", (Reference)object);
        }
        Reference reference = (Reference)object;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance");
        }
        if ((string = reference.getClassName()).equals(RRSQCFClassName)) {
            return this.getMQQueueConnectionFactory(reference);
        }
        if (string.equals(RRSTCFClassName)) {
            return this.getMQTopicConnectionFactory(reference);
        }
        if (string.equals(QCFClassName)) {
            return this.getMQQueueConnectionFactory(reference);
        }
        if (string.equals(TCFClassName)) {
            return this.getMQTopicConnectionFactory(reference);
        }
        if (string.equals(QueueClassName)) {
            return this.getMQDestination(reference);
        }
        if (string.equals(TopicClassName)) {
            return this.getMQDestination(reference);
        }
        return null;
    }

    private Object getMQQueueConnectionFactory(Reference reference) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMQQueueConnectionFactory");
        }
        Enumeration<RefAddr> enumeration = reference.getAll();
        ResourceRefAddr resourceRefAddr = null;
        Object var4_4 = null;
        Class<?> clazz = Class.forName(reference.getClassName());
        Object obj = clazz.newInstance();
        while (enumeration.hasMoreElements()) {
            resourceRefAddr = (ResourceRefAddr)enumeration.nextElement();
            BaseResourceFactory.driveSetter(resourceRefAddr, obj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMQQueueConnectionFactory", obj);
        }
        return obj;
    }

    private Object getMQTopicConnectionFactory(Reference reference) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMQTopicConnectionFactory");
        }
        Enumeration<RefAddr> enumeration = reference.getAll();
        ResourceRefAddr resourceRefAddr = null;
        Object var4_4 = null;
        Class<?> clazz = Class.forName(reference.getClassName());
        Object obj = clazz.newInstance();
        while (enumeration.hasMoreElements()) {
            resourceRefAddr = (ResourceRefAddr)enumeration.nextElement();
            BaseResourceFactory.driveSetter(resourceRefAddr, obj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMQTopicConnectionFactory", obj);
        }
        return obj;
    }

    private Object getMQDestination(Reference reference) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMQDestination");
        }
        Enumeration<RefAddr> enumeration = reference.getAll();
        ResourceRefAddr resourceRefAddr = null;
        ResourceInfo resourceInfo = null;
        String string = null;
        Class<?> clazz = Class.forName(reference.getClassName());
        Object obj = clazz.newInstance();
        while (enumeration.hasMoreElements()) {
            Method method;
            Object[] objectArray;
            Class[] classArray;
            int n;
            resourceRefAddr = (ResourceRefAddr)enumeration.nextElement();
            String string2 = resourceRefAddr.getType();
            if (string2.equals("MessageRetention")) {
                resourceInfo = (ResourceInfo)resourceRefAddr.getContent();
                string = resourceInfo.getParam();
                if (string == null) continue;
                n = string.equalsIgnoreCase("Yes") ? this.findJMSConstant("MQJMS_MRET_YES") : this.findJMSConstant("MQJMS_MRET_NO");
                classArray = new Class[]{Integer.TYPE};
                objectArray = new Object[]{new Integer(n)};
                method = clazz.getMethod("setMessageRetention", classArray);
                method.invoke(obj, objectArray);
                continue;
            }
            if (string2.equals("CCSID")) {
                resourceInfo = (ResourceInfo)resourceRefAddr.getContent();
                string = resourceInfo.getParam();
                if (string == null) continue;
                n = this.getCCSID(string);
                classArray = new Class[]{Integer.TYPE};
                objectArray = new Object[]{new Integer(n)};
                method = clazz.getMethod("setCCSID", classArray);
                method.invoke(obj, objectArray);
                continue;
            }
            if (string2.equals("Expiry")) {
                resourceInfo = (ResourceInfo)resourceRefAddr.getContent();
                string = resourceInfo.getParam();
                if (string == null) continue;
                n = string.equals("APP") || string.equals("Application") ? this.findJMSConstant("MQJMS_EXP_APP") : (string.equals("UNLIM") || string.equals("Unlimited") ? this.findJMSConstant("MQJMS_EXP_UNLIMITED") : Integer.decode(resourceInfo.getParam()).intValue());
                classArray = new Class[]{Long.TYPE};
                objectArray = new Object[]{new Integer(n)};
                method = clazz.getMethod("setExpiry", classArray);
                method.invoke(obj, objectArray);
                continue;
            }
            if (string2.equals("Priority")) {
                resourceInfo = (ResourceInfo)resourceRefAddr.getContent();
                string = resourceInfo.getParam();
                if (string == null) continue;
                n = string.equals("Application") ? this.findJMSConstant("MQJMS_PRI_APP") : (string.equals("Queue Default") ? this.findJMSConstant("MQJMS_PRI_QDEF") : Integer.decode(resourceInfo.getParam()).intValue());
                classArray = new Class[]{Integer.TYPE};
                objectArray = new Object[]{new Integer(n)};
                method = clazz.getMethod("setPriority", classArray);
                method.invoke(obj, objectArray);
                continue;
            }
            if (string2.equals("Persistence")) {
                n = -559038737;
                resourceInfo = (ResourceInfo)resourceRefAddr.getContent();
                string = resourceInfo.getParam();
                if (string == null) continue;
                if (string.equals("Application")) {
                    n = this.findJMSConstant("MQJMS_PER_APP");
                } else if (string.equals("Queue Default")) {
                    n = this.findJMSConstant("MQJMS_PER_QDEF");
                } else if (string.equals("Persistent")) {
                    n = this.findJMSConstant("MQJMS_PER_PER");
                } else if (string.equals("Non-Persistent")) {
                    n = this.findJMSConstant("MQJMS_PER_NON");
                }
                classArray = new Class[]{Integer.TYPE};
                objectArray = new Object[]{new Integer(n)};
                method = clazz.getMethod("setPersistence", classArray);
                method.invoke(obj, objectArray);
                continue;
            }
            if (string2.equals("TargetClient")) {
                n = -559038737;
                resourceInfo = (ResourceInfo)resourceRefAddr.getContent();
                string = resourceInfo.getParam();
                if (string == null) continue;
                if (string.equals("JMS")) {
                    n = this.findJMSConstant("MQJMS_CLIENT_JMS_COMPLIANT");
                } else if (string.equals("MQ")) {
                    n = this.findJMSConstant("MQJMS_CLIENT_NONJMS_MQ");
                }
                classArray = new Class[]{Integer.TYPE};
                objectArray = new Object[]{new Integer(n)};
                method = clazz.getMethod("setTargetClient", classArray);
                method.invoke(obj, objectArray);
                continue;
            }
            if (string2.equals("Encoding")) {
                resourceInfo = (ResourceInfo)resourceRefAddr.getContent();
                string = resourceInfo.getParam();
                if (string == null) continue;
                n = string.equals("Native") ? this.findJMSConstant("MQJMS_ENCODING_NATIVE") : this.getEncodingValue(string);
                classArray = new Class[]{Integer.TYPE};
                objectArray = new Object[]{new Integer(n)};
                method = clazz.getMethod("setEncoding", classArray);
                method.invoke(obj, objectArray);
                continue;
            }
            BaseResourceFactory.driveSetter(resourceRefAddr, obj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMQDestination", obj);
        }
        return obj;
    }

    private int findJMSConstant(String string) throws Exception {
        if (JMSCClass == null) {
            JMSCClass = Class.forName(JMSCClassName);
        }
        return JMSCClass.getField(string).getInt(null);
    }

    private int getEncodingValue(String string) throws Exception {
        int n;
        if (string.equals("Native")) {
            n = this.findJMSConstant("MQJMS_ENCODING_NATIVE");
        } else {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n2 = string.charAt(0) == 'N' ? this.findJMSConstant("MQJMS_ENCODING_INTEGER_NORMAL") : this.findJMSConstant("MQJMS_ENCODING_INTEGER_REVERSED");
            n3 = string.charAt(1) == 'N' ? this.findJMSConstant("MQJMS_ENCODING_DECIMAL_NORMAL") : this.findJMSConstant("MQJMS_ENCODING_DECIMAL_REVERSED");
            n4 = string.charAt(2) == 'N' ? this.findJMSConstant("MQJMS_ENCODING_FLOAT_IEEE_NORMAL") : (string.charAt(2) == 'R' ? this.findJMSConstant("MQJMS_ENCODING_FLOAT_IEEE_REVERSED") : this.findJMSConstant("MQJMS_ENCODING_FLOAT_S390"));
            n = n2 | n3 | n4;
        }
        return n;
    }

    private int getCCSID(String string) throws Exception {
        block29: {
            block28: {
                if (string.equals("UTF-8")) {
                    return 1208;
                }
                if (string.startsWith("ibm")) {
                    switch (string.length()) {
                        case 7: {
                            return Integer.decode(string.substring(3, 6));
                        }
                        case 8: {
                            return Integer.decode(string.substring(3, 7));
                        }
                    }
                    return Integer.decode(string.substring(3, 5));
                }
                if (!string.startsWith("Windows")) break block28;
                switch (string.length()) {
                    case 13: {
                        if (string.equals("Windows Greek")) {
                            return 1253;
                        }
                        break block29;
                    }
                    case 14: {
                        if (string.equals("Windows Hebrew")) {
                            return 1255;
                        }
                        if (string.equals("Windows Arabic")) {
                            return 1256;
                        }
                        if (string.equals("Windows Baltic")) {
                            return 1257;
                        }
                        break block29;
                    }
                    case 15: {
                        if (string.equals("Windows Latin 1")) {
                            return 1252;
                        }
                        if (string.equals("Windows Latin 2")) {
                            return 1250;
                        }
                        if (string.equals("Windows Turkish")) {
                            return 1254;
                        }
                        break block29;
                    }
                    case 16: {
                        if (string.equals("Windows Cyrillic")) {
                            return 1251;
                        }
                        if (string.equals("Windows Vietnamese")) {
                            return 1258;
                        }
                        break block29;
                    }
                }
                break block29;
            }
            if (string.startsWith("iso-8859")) {
                if (string.equals("iso-8859-6 / arabic / ibm1089")) {
                    return 1089;
                }
                int n = string.indexOf("/ ibm");
                String string2 = string.substring(n + 5, n + 7);
                return Integer.decode(string2);
            }
            if (string.equals("JIS")) {
                return 2022;
            }
            if (string.equals("EUCJIS")) {
                return 954;
            }
            if (string.equals("Unicode")) {
                return 1200;
            }
            if (string.equals("PC Japanese")) {
                return 932;
            }
            if (string.equals("ksc-5601 Korean")) {
                return 5601;
            }
            throw new Exception("Bad character set");
        }
        return -559038737;
    }
}

