/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.jaxws.EndpointReferenceConverter;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wstx.Axis2CoordinationContext;
import com.ibm.ws.wstx.TraceConstants;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws.wstx.handler.WSATConsumer;
import com.ibm.ws.wstx.handler.WSBAConsumer;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public class WSTXConsumerHandler
extends AbstractHandler {
    private static final TraceComponent tc = Tr.register(WSTXConsumerHandler.class, "WSTX", TraceConstants.NLS_FILE);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", messageContext);
        }
        WSTXHelper.traceMessageContext(messageContext);
        try {
            switch (messageContext.FLOW) {
                case 1: {
                    this.handleRequest(messageContext);
                    break;
                }
                case 2: {
                    this.handleResponse(messageContext);
                    break;
                }
                case 4: {
                    this.handleFault(messageContext);
                    break;
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "invoke", WSTXHelper.flow(messageContext.FLOW));
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wstx.handler.WSTXConsumerHandler.invoke", "75", this);
            AxisFault axisFault = AxisFault.makeFault(exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke", axisFault);
            }
            throw axisFault;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", Handler.InvocationResponse.CONTINUE);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void handleFault(MessageContext messageContext) throws AxisFault, WebServiceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault", new Object[]{messageContext, this});
        }
        this.handleResponse(messageContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleFault");
        }
    }

    private void handleResponse(MessageContext messageContext) throws AxisFault, WebServiceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse", new Object[]{messageContext, this});
        }
        if (!WSTXHelper.DISABLED && WSTXHelper.enabledByPolicy(messageContext)) {
            String string = messageContext.getAxisOperation().getMessageExchangePattern();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MEP", string);
            }
            if ("http://www.w3.org/2004/08/wsdl/in-out".equals(string) || "http://www.w3.org/2006/01/wsdl/in-out".equals(string)) {
                this.doDeferredRegistration(messageContext);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse");
        }
    }

    private void handleRequest(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest", new Object[]{messageContext, this});
        }
        try {
            CoordinationContext coordinationContext = WSATConsumer.extractContext(messageContext);
            List list = WSBAConsumer.extractContext(messageContext);
            String string = messageContext.getAxisOperation().getMessageExchangePattern();
            if ("http://www.w3.org/2004/08/wsdl/in-out".equals(string) || "http://www.w3.org/2006/01/wsdl/in-out".equals(string)) {
                if (WSTXHelper.enabledByPolicy(messageContext) && messageContext.isHeaderPresent()) {
                    WSATConsumer.cacheContext(messageContext, coordinationContext);
                    WSBAConsumer.cacheContext(messageContext, list);
                }
            } else if (coordinationContext != null || list != null && !list.isEmpty()) {
                AxisFault axisFault = new AxisFault("Coordination Context received via unsupported message exchange pattern: " + messageContext.getAxisOperation().getMessageExchangePattern());
                axisFault.setFaultCode("MustUnderstand");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleRequest", axisFault);
                }
                throw axisFault;
            }
        }
        catch (AxisFault axisFault) {
            FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.wstx.handler.WSTXConsumerHandler.handleRequest", "153", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest", axisFault);
            }
            throw axisFault;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest");
        }
    }

    private void doDeferredRegistration(MessageContext messageContext) throws AxisFault, WebServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doDeferredRegistration", new Object[]{messageContext, this});
        }
        MessageContext messageContext2 = messageContext.getOperationContext().getMessageContext("In");
        EndpointReference endpointReference = null;
        if (messageContext2 != null) {
            endpointReference = (EndpointReference)messageContext2.getProperty(WSTXHelper.PARTICIPANT_EPR);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "participantEPR", endpointReference);
        }
        if (endpointReference != null) {
            SOAPHeaderBlock sOAPHeaderBlock = WSTXHelper.getSOAPHeader(messageContext).addHeaderBlock("ParticipantRegistration", WSATConsumer.ibmns);
            sOAPHeaderBlock.addChild(EndpointReferenceConverter.serializeEndpointReference(endpointReference, Axis2CoordinationContext.REGISTRATION_SERVICE));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doDeferredRegistration");
        }
    }
}

