/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.ThreadContextManager;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.ActivityContextDescriptorRenderer;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.activity.remote.ServerSideProcessor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ServiceInformation;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.coordination.ServiceManager;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.wstx.TraceConstants;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws.wstx.activity.remote.Axis2ServerSideProcessor;
import com.ibm.ws.wstx.activity.remote.soap.Axis2ActivityContextDescriptorFactory;
import com.ibm.ws.wstx.activity.remote.soap.Axis2ActivityContextDescriptorRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class WSBAConsumer {
    private static final TraceComponent tc = Tr.register(WSBAConsumer.class, "WSTX", TraceConstants.NLS_FILE);
    public static String ACTIVITY_DESCRIPTORS = "ActivityDescriptors";
    private static WSThreadLocal _importedContexts = new WSThreadLocal();
    private static ActivityContextDescriptorFactory _factory = new Axis2ActivityContextDescriptorFactory();
    private static final int SUBORDINATE_TIMEOUT_EXTENSION = 30;

    public static boolean establishContext(MessageContext messageContext) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "establishContext", messageContext);
        }
        List list = (List)messageContext.getProperty(ACTIVITY_DESCRIPTORS);
        _importedContexts.set(list);
        if (list != null) {
            if (tc.isDebugEnabled()) {
                ActivityContextDescriptor.outputDescriptorHierarchy((List)list);
            }
            try {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    for (ActivityContextDescriptor activityContextDescriptor = (ActivityContextDescriptor)iterator.next(); activityContextDescriptor != null; activityContextDescriptor = activityContextDescriptor.getChild()) {
                        ServiceInformation serviceInformation;
                        LocalActivityContext localActivityContext;
                        List list2;
                        LocalActivityContext localActivityContext2 = ThreadContextManager.instance().getContextFromGlobalId(activityContextDescriptor.getId());
                        if (localActivityContext2 != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Context " + activityContextDescriptor.getId() + " is being reimported.");
                            }
                            list2 = activityContextDescriptor.getPropertyGroups();
                            if (activityContextDescriptor.representsAllAncestorNodes()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "HLS has indicated that descriptor represents all ancestor nodes");
                                }
                                ArrayList<LocalActivityContext> arrayList = new ArrayList<LocalActivityContext>();
                                for (localActivityContext = localActivityContext2.getParentContext(); localActivityContext != null; localActivityContext = localActivityContext.getParentContext()) {
                                    arrayList.add(localActivityContext);
                                }
                                int n = arrayList.size();
                                for (int i = n - 1; i >= 0; --i) {
                                    ((LocalActivityContext)arrayList.get(i)).getDistributedContext().reimport(list2);
                                }
                            }
                            localActivityContext2.getDistributedContext().reimport(list2);
                            activityContextDescriptor.setContext(localActivityContext2);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Context " + activityContextDescriptor.getId() + " is being imported.");
                        }
                        list2 = activityContextDescriptor.getPropertyGroups();
                        int n = activityContextDescriptor.getTimeout();
                        if (n > 0) {
                            n = Math.min(n + 30, 1000000000);
                        }
                        if (!(localActivityContext = new DistributedActivityContext(activityContextDescriptor.getServiceName(), activityContextDescriptor.getContextGroup(), activityContextDescriptor.getType(), list2, new GlobalIdImpl(activityContextDescriptor.getId()), n, activityContextDescriptor.getCoordinator(), activityContextDescriptor.getActivitySpecificData())).isHLSRegistered()) {
                            localActivityContext.setCachedContext(activityContextDescriptor);
                        }
                        localActivityContext2 = localActivityContext.getLocalContext();
                        activityContextDescriptor.setContext(localActivityContext2);
                        ServiceManager serviceManager = localActivityContext.getLocalContext().getServiceManager();
                        if (serviceManager == null || !localActivityContext2.notifyImported() || (serviceInformation = activityContextDescriptor.getServiceInformation()) == null) continue;
                        serviceManager.activityImported(serviceInformation);
                    }
                }
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.wstx.handler.WSBAConsumer.establishContext", "170");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "establishContext", (Object)systemException);
                }
                throw systemException;
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException(propertyGroupTooLargeException, "com.ibm.ws.wstx.handler.WSBAConsumer.establishContext", "176");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "establishContext", (Object)propertyGroupTooLargeException);
                }
                throw propertyGroupTooLargeException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "establishContext", Boolean.TRUE);
        }
        return true;
    }

    public static List extractContext(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContext", messageContext);
        }
        List list = null;
        if (!WSTXHelper.DISABLED || HLSInformation.isWebServiceEnabledHLSRegistered()) {
            try {
                list = Axis2ServerSideProcessor.processRequest(_factory, messageContext);
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException(propertyGroupTooLargeException, "com.ibm.ws.wstx.handler.WSBAConsumer.extractInbound", "48");
                AxisFault axisFault = new AxisFault(propertyGroupTooLargeException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractContext", axisFault);
                }
                throw axisFault;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.wstx.handler.WSBAConsumer.extractInbound", "58");
                AxisFault axisFault = new AxisFault(systemException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractContext", axisFault);
                }
                throw axisFault;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContext", list);
        }
        return list;
    }

    public static boolean handleOutbound(MessageContext messageContext) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleOutbound", messageContext);
        }
        if (!WSTXHelper.DISABLED && HLSInformation.isWebServiceEnabledHLSRegistered()) {
            try {
                Axis2ActivityContextDescriptorRenderer axis2ActivityContextDescriptorRenderer = new Axis2ActivityContextDescriptorRenderer(messageContext);
                ServerSideProcessor.processReply((ActivityContextDescriptorRenderer)axis2ActivityContextDescriptorRenderer);
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.wstx.handler.WSBAConsumer.handleOutbound", "231");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", (Object)systemException);
                }
                throw systemException;
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException(propertyGroupTooLargeException, "com.ibm.ws.wstx.handler.WSBAConsumer.handleOutbound", "238");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", (Object)propertyGroupTooLargeException);
                }
                throw propertyGroupTooLargeException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleOutbound", Boolean.TRUE);
        }
        return true;
    }

    public static void cacheContext(MessageContext messageContext, List list) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheContext", new Object[]{messageContext, list});
        }
        messageContext.setProperty(ACTIVITY_DESCRIPTORS, list);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheContext");
        }
    }
}

