/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.wstx.JTAAsyncResponseHelper;
import com.ibm.ws.Transaction.wstx.JTAAsyncResponseTarget;
import com.ibm.ws.Transaction.wstx.WSATAsyncResource;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATCoordinatorPortDistImpl;
import com.ibm.ws.Transaction.wstx.WSATParticipantWrapper;
import com.ibm.ws.Transaction.wstx.WSATServices;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.EnvironmentType;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.wsaddressing.jaxws.EndpointReferenceConverter;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws.wscoor.WSCoorHelper;
import com.ibm.ws.wstx.Axis2CoordinationContext;
import com.ibm.ws.wstx.TraceConstants;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.net.URI;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class WSATGenerator {
    private static final TraceComponent tc = Tr.register(WSATGenerator.class, "WSTX", TraceConstants.NLS_FILE);
    private static final int envType;
    private static final Integer nonPersistentDeliveryMode;
    private static WSThreadLocal _txEstablishedBySystemContextHandler;
    public static final Object NO_TX_ESTABLISHED;
    private static final QName PARTICIPANT_REGISTRATION_ELEMENT_NAME;
    public static URI _coordinatorURI;
    private static final boolean _isZOS;

    public static boolean handleOutbound(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleOutbound", messageContext);
        }
        WSATControlSet.clearTransactionAssociation();
        if (envType == 0) {
            CoordinationContext coordinationContext;
            Object object = WSATGenerator.getTxEstablishedBySystemContextHandler();
            if (object != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "SystemContextHandler driven prior to global handler");
                }
                if (object instanceof TransactionImpl) {
                    coordinationContext = (TransactionImpl)object;
                    if (!coordinationContext.equals((Object)TranManagerSet.instance().getTransactionImpl())) {
                        AxisFault axisFault = new AxisFault("Tx established by SystemContextHandler is no longer on the thread");
                        if (TraceComponent.isAnyTracingEnabled()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Tx established by SystemContextHandler is no longer on the thread");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "handleOutbound", axisFault);
                            }
                        }
                        throw axisFault;
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SystemContextHandler was invoked and did not import a transaction.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleOutbound", Boolean.TRUE);
                        }
                    }
                    return true;
                }
            }
            try {
                coordinationContext = WSATControlSet.getCoordinationContextForCurrentTx(null, (boolean)WSATControlSet.isDeferredRegistrationEnabled());
                if (coordinationContext != null) {
                    if (ServiceHelper.getInitFailed()) {
                        throw new AxisFault("WSAT Initialisation has failed, cannot process request");
                    }
                    if (WSTXHelper.isAsync(messageContext)) {
                        throw new AxisFault("WSAT is not supported on async requests");
                    }
                    String string = messageContext.getAxisOperation().getMessageExchangePattern();
                    if (!"http://www.w3.org/2004/08/wsdl/out-in".equals(string) && !"http://www.w3.org/2006/01/wsdl/out-in".equals(string)) {
                        throw new AxisFault("Unsupported MEP: " + string);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding CoordinationContext to SOAPHeader");
                    }
                    SOAPHeader sOAPHeader = WSTXHelper.getSOAPHeader(messageContext);
                    Axis2CoordinationContext axis2CoordinationContext = new Axis2CoordinationContext(coordinationContext);
                    axis2CoordinationContext.insertIntoSOAPHeader(sOAPHeader);
                    HashMap hashMap = new HashMap();
                    WSCoorHelper.addAffinityToMap((String)coordinationContext.getIdentifier().toString(), hashMap);
                    messageContext.setProperty("com.ibm.ws.webservices.wlmselectioncriteria", hashMap);
                    messageContext.setProperty("deliveryMode", nonPersistentDeliveryMode);
                    WSATControlSet.suspendCurrentTransactionAssociation();
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No CoordinationContext found");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.wstx.handler.WSATGenerator.handleOutbound", "208");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", exception);
                }
                throw AxisFault.makeFault(exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleOutbound", Boolean.TRUE);
        }
        return true;
    }

    public static boolean handleInbound(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInbound", messageContext);
        }
        if (WSTXHelper.DISABLED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleInbound", Boolean.TRUE);
            }
            return true;
        }
        TransactionImpl transactionImpl = WSATControlSet.resumeSuspendedTransactionAssociation();
        if (transactionImpl == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleInbound", Boolean.TRUE);
            }
            return true;
        }
        WSATGenerator.processResponse(messageContext, transactionImpl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInbound", Boolean.TRUE);
        }
        return true;
    }

    protected static void setTxEstablishedBySystemContextHandler(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setTxEstablishedBySystemContextHandler", object);
        }
        _txEstablishedBySystemContextHandler.set(object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setTxEstablishedBySystemContextHandler");
        }
    }

    protected static Object getTxEstablishedBySystemContextHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTxEstablishedBySystemContextHandler");
        }
        Object object = _txEstablishedBySystemContextHandler.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTxEstablishedBySystemContextHandler", object);
        }
        return object;
    }

    private static void processResponse(MessageContext messageContext, TransactionImpl transactionImpl) throws AxisFault {
        Object object;
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processResponse", new Object[]{messageContext, transactionImpl});
        }
        SOAPEnvelope sOAPEnvelope = null;
        EndpointReference endpointReference = null;
        if (messageContext != null && (sOAPEnvelope = messageContext.getEnvelope()) != null) {
            SOAPHeader sOAPHeader;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SOAP Envelope", sOAPEnvelope);
            }
            if ((sOAPHeader = sOAPEnvelope.getHeader()) != null) {
                object2 = sOAPHeader.getChildrenWithName(PARTICIPANT_REGISTRATION_ELEMENT_NAME);
                while (object2.hasNext()) {
                    object = (SOAPHeaderBlock)object2.next();
                    try {
                        endpointReference = EndpointReferenceConverter.createEndpointReferenceFromOMElement(object.getFirstChildWithName(Axis2CoordinationContext.REGISTRATION_SERVICE));
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.wstx.handler.WSATGenerator.processResponse", "292");
                    }
                    if (endpointReference == null) continue;
                    object.detach();
                    break;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SOAP header was null");
            }
        }
        if (sOAPEnvelope == null) {
            transactionImpl.setRollbackOnly();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", "No envelope in response");
            }
            return;
        }
        if (endpointReference == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "processResponse", "No participant EPR");
            }
            object2 = null;
            try {
                object2 = sOAPEnvelope.getBody().getFault();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.wstx.handler.WSATGenerator.processResponse", "302");
            }
            if (object2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processResponse", "No fault in response");
                }
                return;
            }
            if (object2.getDetail() == null) {
                transactionImpl.setRollbackOnly();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", "No participant EPR in response");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "participant EPR", endpointReference);
        }
        if ((object2 = endpointReference.getReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME)) == null) {
            throw new AxisFault("No txID in participant EPR");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "txID", object2);
        }
        try {
            object = WSATControlSet.createEPR((URI)_coordinatorURI);
            object.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, (String)object2);
            object.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, endpointReference.getAddress().getURI().toString());
            String string = null;
            if (_isZOS) {
                string = "" + transactionImpl.getXidImpl().getBqualBranchIndex();
                object.setReferenceParameter(WSTXConstants.BRANCH_ELEMENT_QNAME, string);
            }
            WSATControlSet.pinEPRToServer((EndpointReference)object);
            WSATAsyncResource wSATAsyncResource = new WSATAsyncResource(endpointReference, (EndpointReference)object, (String)object2, string);
            WSATParticipantWrapper wSATParticipantWrapper = new WSATParticipantWrapper(wSATAsyncResource);
            transactionImpl.enlistAsyncResource(wSATParticipantWrapper);
            if (!_isZOS) {
                JTAAsyncResponseHelper jTAAsyncResponseHelper = WSATCoordinatorPortDistImpl.getJTAAsyncResponseHelper();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "AsyncResponseHelper", jTAAsyncResponseHelper);
                }
                jTAAsyncResponseHelper.addResponseTarget((JTAAsyncResponseTarget)wSATParticipantWrapper);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.wstx.handler.WSATGenerator.processResponse", "337");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", exception);
            }
            throw AxisFault.makeFault(exception);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.wstx.handler.WSATGenerator.processResponse", "339");
            AxisFault axisFault = new AxisFault(throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", axisFault);
            }
            throw axisFault;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processResponse");
        }
    }

    static {
        PARTICIPANT_REGISTRATION_ELEMENT_NAME = new QName("http://wstx.Transaction.ws.ibm.com/extension", WSTXConstants.PARTICIPANT_REGISTRATION_ELEMENT_NAME.getLocalName(), "websphere-wsat");
        _isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<clinit>");
        }
        envType = EnvironmentType.getEnvironmentType();
        nonPersistentDeliveryMode = new Integer(1);
        _txEstablishedBySystemContextHandler = new WSThreadLocal();
        NO_TX_ESTABLISHED = new Object();
        if (envType == 0) {
            _coordinatorURI = WSATServices.getWSATCoordinatorURI();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<clinit>");
        }
    }
}

