/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wstx.Axis2CoordinationContext;
import com.ibm.ws.wstx.TraceConstants;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws390.tx.TransactionManagerMessage;
import com.ibm.ws390.tx.WSATJMSSystemContextHandler;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.InvalidTransactionException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class WSATConsumer {
    private static final TraceComponent tc = Tr.register(WSATConsumer.class, "WSTX", TraceConstants.NLS_FILE);
    private static final String WSAT_COORDINATION_TYPE = "http://schemas.xmlsoap.org/ws/2004/10/wsat";
    public static final OMNamespace ibmns = OMAbstractFactory.getOMFactory().createOMNamespace("http://wstx.Transaction.ws.ibm.com/extension", "websphere-wsat");
    private static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();

    public static boolean establishContext(MessageContext messageContext) throws Exception {
        block15: {
            CoordinationContext coordinationContext;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "establishContext", messageContext);
            }
            if ((coordinationContext = (CoordinationContext)messageContext.getProperty(WSAT_COORDINATION_TYPE)) != null) {
                try {
                    WSATControlSet.setImportedTran(null);
                    int n = 0;
                    if (isZOS) {
                        String string = messageContext.getIncomingTransportName();
                        if ("http".equals(string)) {
                            XidImpl xidImpl;
                            HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                            if (httpServletRequest == null) {
                                throw new Exception("No servlet request with xid data, cannot process request");
                            }
                            String string2 = httpServletRequest.getHeader(HttpConstants.HDR_ZOS_TRAN_XID.getName());
                            if (string2 != null) {
                                TransactionManagerMessage transactionManagerMessage = new TransactionManagerMessage(Util.byteArray(string2));
                                xidImpl = transactionManagerMessage.getXid();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Got transaction xid from message context", xidImpl);
                                }
                            } else {
                                throw new Exception("No xid data in servlet request, cannot process request");
                            }
                            n = xidImpl.getBqualBranchIndex();
                            WSATConsumer.checkForTran();
                        } else if ("jms".equals(string)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got messsage from JMS so need xid from sys ctx handler");
                            }
                            if ((n = WSATJMSSystemContextHandler.getBranchIndex()) < 0) {
                                throw new Exception("No xid data in jms system context, cannot process request");
                            }
                            WSATConsumer.checkForTran();
                        }
                    }
                    WSATControlSet.establishCoordinationContext((CoordinationContext)coordinationContext, null, (int)n);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.wstx.handler.WSATConsumer.establishContext", "117");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "establishContext", exception);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "establishContext", Boolean.TRUE);
        }
        return true;
    }

    public static boolean handleOutbound(MessageContext messageContext, MessageContext messageContext2) throws Exception {
        UOWCoordinator uOWCoordinator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleOutbound", new Object[]{messageContext, messageContext2});
        }
        if ((uOWCoordinator = WSATControlSet.getinitialUOW()) != null && uOWCoordinator.isGlobal()) {
            TranManagerSet tranManagerSet;
            TransactionImpl transactionImpl;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got the global tran ctx stored earlier; proceeding with local invocation handler behaviour");
            }
            if ((transactionImpl = (tranManagerSet = TranManagerSet.instance()).getTransactionImpl()) != null) {
                transactionImpl.suspendAssociation();
            }
        } else {
            TransactionImpl transactionImpl;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got the local tran ctx stored earlier; proceeding with remote invocation handler behaviour");
            }
            try {
                transactionImpl = WSATControlSet.cleanupThreadContext();
            }
            catch (InvalidTransactionException invalidTransactionException) {
                AxisFault axisFault = new AxisFault("No WSATRecoveryCoordinator");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", axisFault);
                }
                throw axisFault;
            }
            if (transactionImpl == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", "No transaction returned from cleanupThreadContext()");
                }
                return true;
            }
            WSATRecoveryCoordinator wSATRecoveryCoordinator = transactionImpl.getWSATRecoveryCoordinator();
            if (wSATRecoveryCoordinator == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", "No WSATRecoveryCoordinator as the transaction was not imported");
                }
                return true;
            }
            boolean bl = wSATRecoveryCoordinator.isDeferRegistration();
            if (!bl && !isZOS) {
                int n = Configuration.getAsyncResponseTimeout() / 1000;
                while (wSATRecoveryCoordinator.getSuperiorCoordinator() == null && n-- > 0) {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Waiting for register response");
                        }
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Sleep was interrupted", interruptedException);
                    }
                }
            }
            if (transactionImpl.getWSATRecoveryCoordinator().isRegisterSent()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", "Already sent registration EPR");
                }
                return true;
            }
            if (!bl) {
                if (!isZOS && wSATRecoveryCoordinator.getSuperiorCoordinator() == null) {
                    AxisFault axisFault = new AxisFault("No WSATRecoveryCoordinator");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleOutbound", axisFault);
                    }
                    throw axisFault;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", "Got superior coordinator on another thread");
                }
                return true;
            }
            if (WSATControlSet.needToRegister()) {
                EndpointReference endpointReference = wSATRecoveryCoordinator.getParticipantEPR();
                messageContext.setProperty(WSTXHelper.PARTICIPANT_EPR, endpointReference);
                transactionImpl.getWSATRecoveryCoordinator().setRegisterSent();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No need to register");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleOutbound", Boolean.TRUE);
        }
        return true;
    }

    private static void checkForTran() throws Exception {
        TranManagerSet tranManagerSet = TranManagerSet.instance();
        TransactionImpl transactionImpl = tranManagerSet.getTransactionImpl();
        if (transactionImpl != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got transaction on thread", transactionImpl);
            }
            throw new Exception("Transaction already on thread");
        }
    }

    public static CoordinationContext extractContext(MessageContext messageContext) throws AxisFault {
        SOAPHeader sOAPHeader;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContext", messageContext);
        }
        if ((sOAPHeader = messageContext.getEnvelope().getHeader()) != null) {
            Axis2CoordinationContext axis2CoordinationContext = Axis2CoordinationContext.extractFromSOAPHeader(sOAPHeader, WSAT_COORDINATION_TYPE, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "extractContext", (Object)axis2CoordinationContext);
            }
            return axis2CoordinationContext;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContext", null);
        }
        return null;
    }

    public static void cacheContext(MessageContext messageContext, CoordinationContext coordinationContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheContext", new Object[]{messageContext, coordinationContext});
        }
        if (coordinationContext != null) {
            messageContext.setProperty(coordinationContext.getCoordinationType().toString(), coordinationContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheContext");
        }
    }
}

