/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.activity.remote.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityContext;
import com.ibm.ws.activity.ContextExtractor;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.activity.remote.soap.SOAPActivityContextDescriptor;
import com.ibm.ws.activity.remote.soap.WSActivityContextDescriptorFactory;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.wstx.TraceConstants;
import com.ibm.ws.wstx.activity.remote.soap.Axis2ActivityContextDescriptor;
import java.util.List;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;

public class Axis2ActivityContextDescriptorFactory
extends WSActivityContextDescriptorFactory
implements ActivityContextDescriptorFactory {
    private static final TraceComponent tc = Tr.register(Axis2ActivityContextDescriptorFactory.class, "WSTX", TraceConstants.NLS_FILE);

    public ActivityContextDescriptor createDescriptor(LocalActivityContext localActivityContext, boolean bl) {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createDescriptor", new Object[]{localActivityContext, bl, this});
        }
        Axis2ActivityContextDescriptor axis2ActivityContextDescriptor = null;
        HLSInformation hLSInformation = localActivityContext.getHLSInformation();
        if (hLSInformation != null && ((n = hLSInformation.getWebServicePropagationEnabled()) == 1 || n == 2)) {
            boolean bl2 = n == 2;
            axis2ActivityContextDescriptor = new Axis2ActivityContextDescriptor(localActivityContext, bl2, bl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createDescriptor", axis2ActivityContextDescriptor);
        }
        return axis2ActivityContextDescriptor;
    }

    public List extractDescriptors(Object object) throws SystemException, PropertyGroupTooLargeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractDescriptors", new Object[]{object, this});
        }
        MessageContext messageContext = (MessageContext)object;
        SOAPHeader sOAPHeader = messageContext.getEnvelope().getHeader();
        List list = null;
        if (sOAPHeader != null) {
            list = Axis2ActivityContextDescriptor.extractContextsFromSOAPHeader(sOAPHeader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ActivityContextDescriptor.outputDescriptorHierarchy((List)list);
            }
            for (ContextExtractor contextExtractor : HLSInformation.getContextExtractors()) {
                ActivityContext activityContext;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ContextExtractor", contextExtractor);
                }
                if ((activityContext = contextExtractor.extractContext(object)) != null) {
                    this.mapForeignIds(activityContext);
                    list.add(new SOAPActivityContextDescriptor(activityContext));
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Extracted context", activityContext);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractDescriptors", list);
        }
        return list;
    }
}

