/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.activity.remote;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.ActivityTokenImpl;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.PropertyGroupInfo;
import com.ibm.ws.activity.ThreadContextManager;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.ActivityContextDescriptorRenderer;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.activity.PropertyGroupContext;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroup;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroupManager;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.wstx.TraceConstants;
import java.util.ArrayList;
import java.util.List;

public class Axis2ClientSideProcessor {
    private static final TraceComponent tc = Tr.register(Axis2ClientSideProcessor.class, "WSTX", TraceConstants.NLS_FILE);
    private static WSThreadLocal _internalRequest = new WSThreadLocal();
    private static WSThreadLocal _exportedContexts = new WSThreadLocal();

    public static void resumeAllContexts() throws InvalidActivityException, SystemException {
        LocalActivityContext localActivityContext;
        ActivityTokenImpl activityTokenImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeAllContexts");
        }
        if ((activityTokenImpl = ThreadContextManager.instance().removeFromThreadActivityTokenMap()) != null && (localActivityContext = activityTokenImpl.getContext()) != null) {
            localActivityContext.resume(activityTokenImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeAllContexts");
        }
    }

    public static void processRequest(ActivityContextDescriptorFactory activityContextDescriptorFactory, ActivityContextDescriptorRenderer activityContextDescriptorRenderer) throws SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRequest", new Object[]{activityContextDescriptorFactory, activityContextDescriptorRenderer});
        }
        Axis2ClientSideProcessor.processRequest(activityContextDescriptorFactory, activityContextDescriptorRenderer, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRequest");
        }
    }

    public static void processRequest(ActivityContextDescriptorFactory activityContextDescriptorFactory, ActivityContextDescriptorRenderer activityContextDescriptorRenderer, boolean bl) throws SystemException, PropertyGroupTooLargeException {
        ActivityTokenImpl activityTokenImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRequest", new Object[]{activityContextDescriptorFactory, activityContextDescriptorRenderer, bl});
        }
        Boolean bl2 = (Boolean)_internalRequest.get();
        ArrayList<ActivityContextDescriptor> arrayList = new ArrayList<ActivityContextDescriptor>();
        if ((bl2 == null || !bl2.booleanValue()) && activityContextDescriptorRenderer.renderingStarting() && (activityTokenImpl = ThreadContextManager.instance().getRootActivityToken()) != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (activityTokenImpl != null) {
                LocalActivityContext localActivityContext = activityTokenImpl.getContext();
                String string = localActivityContext.getServiceName();
                if (!arrayList2.contains(string)) {
                    ActivityContextDescriptor activityContextDescriptor = activityContextDescriptorFactory.createDescriptor(localActivityContext, bl);
                    if (activityContextDescriptor != null) {
                        activityContextDescriptorRenderer.render(activityContextDescriptor, true);
                        arrayList.add(activityContextDescriptor);
                    }
                    arrayList2.add(string);
                }
                activityTokenImpl = activityTokenImpl.getChildToken();
            }
        }
        activityContextDescriptorRenderer.renderingComplete();
        if (ActivityService.instance().isServerProcess()) {
            try {
                activityTokenImpl = ThreadContextManager.instance().suspendAllContexts();
                if (activityTokenImpl != null) {
                    ThreadContextManager.instance().addToThreadActivityTokenMap(activityTokenImpl);
                }
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.ClientSideProcessor.processRequest", "96");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processRequest", (Object)systemException);
                }
                throw systemException;
            }
        }
        _exportedContexts.set(arrayList);
        if (tc.isDebugEnabled()) {
            ActivityContextDescriptor.outputDescriptorHierarchy(arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRequest");
        }
    }

    public static void processReply(ActivityContextDescriptorFactory activityContextDescriptorFactory, Object object) throws InvalidActivityException, SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processReply", new Object[]{activityContextDescriptorFactory, object});
        }
        Axis2ClientSideProcessor.processReply(activityContextDescriptorFactory, object, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processReply");
        }
    }

    public static void processReply(ActivityContextDescriptorFactory activityContextDescriptorFactory, Object object, boolean bl) throws InvalidActivityException, SystemException, PropertyGroupTooLargeException {
        List list;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processReply", new Object[]{activityContextDescriptorFactory, object, bl});
        }
        Axis2ClientSideProcessor.resumeAllContexts();
        List list2 = null;
        if (object != null && (list2 = activityContextDescriptorFactory.extractDescriptors(object)) != null) {
            if (tc.isDebugEnabled()) {
                ActivityContextDescriptor.outputDescriptorHierarchy((List)list2);
            }
            object2 = list2.iterator();
            while (object2.hasNext()) {
                for (list = (ActivityContextDescriptor)object2.next(); list != null; list = list.getChild()) {
                    List list32;
                    List list4;
                    LocalActivityContext localActivityContext = ThreadContextManager.instance().getContextFromGlobalId(list.getId());
                    if (localActivityContext == null) continue;
                    ActivityContextDescriptor activityContextDescriptor = localActivityContext.getDistributedContext();
                    if (!bl) {
                        activityContextDescriptor.decRequestCount();
                    }
                    if (activityContextDescriptor.isHLSRegistered()) {
                        list4 = list.getPropertyGroups();
                        if (list4 != null) {
                            for (List list32 : list4) {
                                String string = list32.getPropertyGroupName();
                                PropertyGroupInfo propertyGroupInfo = localActivityContext.getPropertyGroupInfo(list32.getPropertyGroupName());
                                if (propertyGroupInfo._demarshalResponse) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Calling PGManager " + string + " to demarshal PropertyGroupContext");
                                    }
                                    PropertyGroupManager propertyGroupManager = propertyGroupInfo._manager;
                                    PropertyGroup propertyGroup = localActivityContext.getPropertyGroup(string);
                                    propertyGroupManager.unmarshalResponse((PropertyGroupContext)list32, propertyGroup);
                                    continue;
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "PropertyGroupManager " + string + " is not configured to unmarshal responses");
                            }
                        }
                        if (activityContextDescriptor.getSuperiorCoordinatorProxy() != null || localActivityContext.getCoordinatorRef() != null) continue;
                        activityContextDescriptor.setSuperiorCoordinatorProxy(list.getCoordinator(), false);
                        continue;
                    }
                    list4 = activityContextDescriptor.getCachedContext();
                    boolean bl2 = false;
                    if (list4.getCoordinator() == null && list.getCoordinator() != null) {
                        list4.setCoordinator(list.getCoordinator());
                        bl2 = true;
                    }
                    if ((list32 = list.getPropertyGroups()) != null && list32.size() > 0) {
                        list4.setPropertyGroups(list32);
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    activityContextDescriptor.setCachedContext((ActivityContextDescriptor)list4);
                }
            }
        }
        if (!((object2 = (Boolean)_internalRequest.get()) != null && ((Boolean)object2).booleanValue() || (list = (List)_exportedContexts.get()) == null || list2 != null && list.size() == list2.size())) {
            for (ActivityContextDescriptor activityContextDescriptor : list) {
                if (list2.contains(activityContextDescriptor)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exported context not found in response. Decrementing active request count", activityContextDescriptor);
                }
                while (activityContextDescriptor != null) {
                    if (!bl) {
                        activityContextDescriptor.getContext().getDistributedContext().decRequestCount();
                    }
                    activityContextDescriptor = activityContextDescriptor.getChild();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processReply");
        }
    }

    public static void setInternalRequest(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInternalRequest", bl);
        }
        _internalRequest.set(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInternalRequest");
        }
    }
}

