/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wstx.TraceConstants;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws.wstx.handler.WSATConsumer;
import com.ibm.ws.wstx.handler.WSBAConsumer;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.ThreadContextMigrator;

public class WSTXServerTCMImpl
implements ThreadContextMigrator {
    private static final TraceComponent tc = Tr.register(WSTXServerTCMImpl.class, "WSTX", TraceConstants.NLS_FILE);

    public void migrateContextToThread(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateContextToThread", messageContext);
        }
        if (!WSTXHelper.DISABLED) {
            try {
                WSATConsumer.establishContext(messageContext);
                WSBAConsumer.establishContext(messageContext);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wstx.WSTXServerTCMImpl.migrateContextToThread", "42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "migrateContextToThread", exception);
                }
                throw AxisFault.makeFault(exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateContextToThread");
        }
    }

    public void cleanupThread(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupThread", new Object[]{messageContext, this});
        }
        WSTXHelper.traceMessageContext(messageContext);
        Object object = messageContext.getProperty(WSTXHelper.THREAD_CLEANED_UP);
        if (object == null) {
            messageContext.setProperty(WSTXHelper.THREAD_CLEANED_UP, Boolean.TRUE);
            try {
                MessageContext messageContext2 = messageContext.getOperationContext().getMessageContext("Out");
                this.handleOutbound(messageContext, messageContext2);
            }
            catch (AxisFault axisFault) {
                FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.wstx.WSTXServerTCMImpl.cleanupThread", "71", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "cleanupThread", axisFault);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Thread already cleaned up");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupThread");
        }
    }

    public void migrateThreadToContext(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateThreadToContext", messageContext);
        }
        MessageContext messageContext2 = messageContext.getOperationContext().getMessageContext("In");
        this.cleanupThread(messageContext2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateThreadToContext");
        }
    }

    public void cleanupContext(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "cleanupContext", messageContext);
        }
        WSTXHelper.traceMessageContext(messageContext);
    }

    private void handleOutbound(MessageContext messageContext, MessageContext messageContext2) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleOutbound", new Object[]{messageContext, messageContext2});
        }
        if (!WSTXHelper.DISABLED) {
            try {
                WSBAConsumer.handleOutbound(messageContext2);
                WSATConsumer.handleOutbound(messageContext, messageContext2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wstx.WSTXServerTCMImpl.cleanupThread", "63", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", exception);
                }
                throw AxisFault.makeFault(exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleOutbound");
        }
    }
}

