/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wstx.TraceConstants;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws.wstx.handler.WSATGenerator;
import com.ibm.ws.wstx.handler.WSBAGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.ThreadContextMigrator;

public class WSTXClientTCMImpl
implements ThreadContextMigrator {
    private static final TraceComponent tc = Tr.register(WSTXClientTCMImpl.class, "WSTX", TraceConstants.NLS_FILE);

    public void migrateContextToThread(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "migrateContextToThread", messageContext.getEnvelope());
        }
    }

    public void cleanupThread(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "cleanupThread", messageContext);
        }
    }

    public void migrateThreadToContext(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateThreadToContext", messageContext);
        }
        if (!WSTXHelper.DISABLED && WSTXHelper.enabledByPolicy(messageContext)) {
            WSATGenerator.handleOutbound(messageContext);
            WSBAGenerator.handleOutbound(messageContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateThreadToContext");
        }
    }

    public void cleanupContext(MessageContext messageContext) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanupContext", messageContext);
            }
            WSTXHelper.traceMessageContext(messageContext);
            if (!WSTXHelper.DISABLED && WSTXHelper.enabledByPolicy(messageContext)) {
                try {
                    MessageContext messageContext2 = messageContext.getOperationContext().getMessageContext("In");
                    this.handleInbound(messageContext2);
                }
                catch (AxisFault axisFault) {
                    FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.wstx.WSTXClientTCMImpl.cleanupContext", "79", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "cleanupContext", axisFault);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupContext");
        }
    }

    private void handleInbound(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInbound", messageContext);
        }
        WSBAGenerator.handleInbound(messageContext);
        WSATGenerator.handleInbound(messageContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInbound");
        }
    }
}

