/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class Transform
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "Transform";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private static final QName ATTR_ALGORITHM_Q = new QName("", "Algorithm");
    private static final String ELEM_XPATH = "XPath";
    private String fAlgorithm;

    public Transform() {
        this(null);
    }

    public Transform(OMElement oMElement) {
        super(oMElement);
        if (oMElement != null) {
            if (!Transform.isOfType(oMElement)) {
                throw new IllegalArgumentException("Not Transform element");
            }
            this.fAlgorithm = oMElement.getAttributeValue(ATTR_ALGORITHM_Q);
            this.init(oMElement);
        }
    }

    public static boolean isOfType(OMElement oMElement) {
        return oMElement != null && NAME.equals(oMElement.getLocalName()) && NAMESPACE.equals(oMElement.getNamespace() == null ? "" : oMElement.getNamespace().getName());
    }

    private void init(OMNode oMNode) {
        if (!(oMNode instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode oMNode2 = ((OMContainer)((Object)oMNode)).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
            switch (oMNode2.getType()) {
                case 1: {
                    OMElement oMElement = (OMElement)oMNode2;
                    if (!this.isParameter(oMElement)) continue block4;
                    super.addElement(oMElement);
                    continue block4;
                }
                case 9: {
                    this.init(oMNode2);
                }
            }
        }
    }

    private boolean isParameter(OMElement oMElement) {
        String string = oMElement.getNamespace() == null ? "" : oMElement.getNamespace().getName();
        String string2 = oMElement.getLocalName();
        return string != null && (!string.equals(NAMESPACE) || string2 != null && string2.equals(ELEM_XPATH));
    }

    public void setAlgorithm(String string) {
        this.fAlgorithm = string;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public void addParameter(OMElement oMElement) {
        if (oMElement != null) {
            if (!this.isParameter(oMElement)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(oMElement);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public OMElement createElement(OMFactory oMFactory, boolean bl) throws StructureException {
        if (oMFactory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement oMElement = oMFactory.createOMElement(NAME, NAMESPACE, "");
        if (bl) {
            oMElement.declareDefaultNamespace(NAMESPACE);
        }
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        oMElement.addAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm), null);
        super.createElement(oMElement, oMFactory, NAMESPACE);
        return oMElement;
    }
}

