/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyName;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.RetrievalMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class KeyInfo
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "KeyInfo";
    private static final String ATTR_ID = "Id";
    private static final QName ATTR_ID_Q = new QName("", "Id");
    private static final String ELEM_KEY_VALUE = "KeyValue";
    private static final String ELEM_X509_DATA = "X509Data";
    private static final String ELEM_PGP_DATA = "PGPData";
    private static final String ELEM_SPKI_DATA = "SPKIData";
    private static final String ELEM_MGMT_DATA = "MgmtData";
    private String fId;

    public KeyInfo() {
        this(null);
    }

    public KeyInfo(OMElement oMElement) {
        super(oMElement);
        if (oMElement != null) {
            if (!KeyInfo.isOfType(oMElement)) {
                throw new IllegalArgumentException("Not KeyInfo element");
            }
            this.fId = oMElement.getAttributeValue(ATTR_ID_Q);
            this.init(oMElement);
        }
    }

    public static boolean isOfType(OMElement oMElement) {
        return oMElement != null && NAME.equals(oMElement.getLocalName()) && NAMESPACE.equals(oMElement.getNamespace() == null ? "" : oMElement.getNamespace().getName());
    }

    private void init(OMNode oMNode) {
        if (!(oMNode instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode oMNode2 = ((OMContainer)((Object)oMNode)).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
            switch (oMNode2.getType()) {
                case 1: {
                    OMElement oMElement = (OMElement)oMNode2;
                    Object object = null;
                    if (EncryptedKey.isOfType(oMElement)) {
                        object = new EncryptedKey(oMElement);
                    } else if (KeyName.isOfType(oMElement)) {
                        object = new KeyName(oMElement);
                    } else if (RetrievalMethod.isOfType(oMElement)) {
                        object = new RetrievalMethod(oMElement);
                    } else if (this.isKeyId(oMElement)) {
                        object = oMElement;
                    }
                    super.addElement(object);
                    continue block4;
                }
                case 9: {
                    this.init(oMNode2);
                }
            }
        }
    }

    private boolean isKeyId(OMElement oMElement) {
        String string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
        String string2 = oMElement.getLocalName();
        return string != null && (!string.equals(NAMESPACE) || string2 != null && (string2.equals(ELEM_KEY_VALUE) || string2.equals(ELEM_X509_DATA) || string2.equals(ELEM_PGP_DATA) || string2.equals(ELEM_SPKI_DATA) || string2.equals(ELEM_MGMT_DATA)));
    }

    public void setId(String string) {
        this.fId = string;
    }

    public String getId() {
        return this.fId;
    }

    public void addEncryptedKey(EncryptedKey encryptedKey) {
        super.addElement(encryptedKey);
    }

    public void addKeyName(KeyName keyName) {
        super.addElement(keyName);
    }

    public void addRetrievalMethod(RetrievalMethod retrievalMethod) {
        super.addElement(retrievalMethod);
    }

    public void addKeyId(OMElement oMElement) {
        if (oMElement != null) {
            if (!this.isKeyId(oMElement)) {
                throw new IllegalArgumentException("Wrong key id");
            }
            super.addElement(oMElement);
        }
    }

    public List getKeyIds() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public OMElement createElement(OMFactory oMFactory, boolean bl) throws StructureException {
        if (oMFactory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement oMElement = oMFactory.createOMElement(NAME, NAMESPACE, "");
        if (bl) {
            oMElement.declareDefaultNamespace(NAMESPACE);
        }
        if (this.fId != null) {
            oMElement.addAttribute(ATTR_ID, Util.normalize(this.fId), null);
        }
        if (this.fElements.isEmpty()) {
            throw new StructureException("Key ids not specified");
        }
        super.createElement(oMElement, oMFactory, NAMESPACE);
        return oMElement;
    }
}

