/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.core.EngineFactory;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeySize;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.OAEPParams;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class EncryptionMethod
extends ElementsType {
    public static final String TRIPLEDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES128_CBC = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES192_CBC = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES256_CBC = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String RSA_1_5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static final String KW_TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String KW_AES128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String KW_AES192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String KW_AES256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptionMethod";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private static final QName ATTR_ALGORITHM_Q = new QName("", "Algorithm");
    private String fAlgorithm;
    private KeySize fKeySize;
    private OAEPParams fOaepParams;
    private AlgorithmParameterSpec fSpec;
    private boolean fDoneSpecCreation;
    private EngineFactory fEngineFactory;

    public EncryptionMethod() {
        this(null);
    }

    public EncryptionMethod(OMElement oMElement) {
        super(oMElement);
        if (oMElement != null) {
            if (!EncryptionMethod.isOfType(oMElement)) {
                throw new IllegalArgumentException("Not EncryptionMethod element");
            }
            this.fAlgorithm = oMElement.getAttributeValue(ATTR_ALGORITHM_Q);
            this.init(oMElement);
        }
        this.fDoneSpecCreation = false;
    }

    public static boolean isOfType(OMElement oMElement) {
        return oMElement != null && NAME.equals(oMElement.getLocalName()) && NAMESPACE.equals(oMElement.getNamespace() == null ? "" : oMElement.getNamespace().getName());
    }

    private void init(OMNode oMNode) {
        if (!(oMNode instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode oMNode2 = ((OMContainer)((Object)oMNode)).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
            switch (oMNode2.getType()) {
                case 1: {
                    OMElement oMElement = (OMElement)oMNode2;
                    if (KeySize.isOfType(oMElement)) {
                        this.fKeySize = new KeySize(oMElement);
                        continue block4;
                    }
                    if (OAEPParams.isOfType(oMElement)) {
                        this.fOaepParams = new OAEPParams(oMElement);
                        continue block4;
                    }
                    if (!this.isParameter(oMElement)) continue block4;
                    super.addElement(oMElement);
                    continue block4;
                }
                case 9: {
                    this.init(oMNode2);
                }
            }
        }
    }

    private boolean isParameter(OMElement oMElement) {
        String string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
        return string != null && !string.equals(NAMESPACE);
    }

    public void setAlgorithm(String string) {
        this.fAlgorithm = string;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public AlgorithmParameterSpec getParameterSpec(EngineFactory engineFactory) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (this.fDoneSpecCreation) {
            return this.fSpec;
        }
        this.fEngineFactory = engineFactory;
        this.fSpec = engineFactory.unmarshalParameter(this.fAlgorithm, this.getBase());
        this.fDoneSpecCreation = true;
        return this.fSpec;
    }

    public void setParameterSpec(EngineFactory engineFactory, AlgorithmParameterSpec algorithmParameterSpec) {
        this.fEngineFactory = engineFactory;
        this.fSpec = algorithmParameterSpec;
        this.fDoneSpecCreation = true;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public OMElement createElement(OMFactory oMFactory, boolean bl) throws StructureException {
        if (oMFactory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement oMElement = oMFactory.createOMElement(NAME, NAMESPACE, "");
        if (bl) {
            oMElement.declareDefaultNamespace(NAMESPACE);
        }
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        oMElement.addAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm), null);
        if (this.fEngineFactory != null) {
            try {
                this.fEngineFactory.marshalParameter(this.fAlgorithm, this.fSpec, oMElement);
            }
            catch (Exception exception) {
                throw new StructureException(exception.getMessage());
            }
        } else {
            OMElement oMElement2;
            if (this.fKeySize != null) {
                oMElement2 = this.fKeySize.createElement(oMFactory, false);
                oMElement.addChild(oMElement2);
            }
            if (this.fOaepParams != null) {
                oMElement2 = this.fOaepParams.createElement(oMFactory, false);
                oMElement.addChild(oMElement2);
            }
            super.createElement(oMElement, oMFactory, NAMESPACE);
        }
        return oMElement;
    }
}

