/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionProperties;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;

public abstract class EncryptedType
extends Type {
    private static final String ATTR_ID = "Id";
    private static final String ATTR_TYPE = "Type";
    private static final String ATTR_MIME_TYPE = "MimeType";
    private static final String ATTR_ENCODING = "Encoding";
    private static final QName ATTR_ID_Q = new QName("", "Id");
    private static final QName ATTR_TYPE_Q = new QName("", "Type");
    private static final QName ATTR_MIME_TYPE_Q = new QName("", "MimeType");
    private static final QName ATTR_ENCODING_Q = new QName("", "Encoding");
    private String fId;
    private String fType;
    private String fMimeType;
    private String fEncoding;
    private EncryptionMethod fEncryptionMethod;
    private KeyInfo fKeyInfo;
    private CipherData fCipherData;
    private EncryptionProperties fEncryptionProperties;

    public EncryptedType(OMElement oMElement) {
        super(oMElement);
        if (oMElement != null) {
            this.fId = oMElement.getAttributeValue(ATTR_ID_Q);
            if (!EncryptedHeader.isOfType(oMElement)) {
                this.fType = oMElement.getAttributeValue(ATTR_TYPE_Q);
                this.fMimeType = oMElement.getAttributeValue(ATTR_MIME_TYPE_Q);
                this.fEncoding = oMElement.getAttributeValue(ATTR_ENCODING_Q);
            }
            this.init(oMElement);
        }
    }

    public static EncryptedType getInstance(OMElement oMElement) {
        if (oMElement == null) {
            throw new NullPointerException("Element not specified");
        }
        EncryptedType encryptedType = null;
        if (EncryptedData.isOfType(oMElement)) {
            encryptedType = new EncryptedData(oMElement);
        } else if (EncryptedKey.isOfType(oMElement)) {
            encryptedType = new EncryptedKey(oMElement);
        } else if (EncryptedHeader.isOfType(oMElement)) {
            encryptedType = new EncryptedHeader(oMElement);
        } else {
            throw new IllegalArgumentException("Unknown element type: " + oMElement.getQName());
        }
        return encryptedType;
    }

    private void init(OMNode oMNode) {
        if (!(oMNode instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode oMNode2 = ((OMContainer)((Object)oMNode)).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
            switch (oMNode2.getType()) {
                case 1: {
                    OMElement oMElement = (OMElement)oMNode2;
                    if (EncryptionMethod.isOfType(oMElement)) {
                        this.fEncryptionMethod = new EncryptionMethod(oMElement);
                        continue block4;
                    }
                    if (KeyInfo.isOfType(oMElement)) {
                        this.fKeyInfo = new KeyInfo(oMElement);
                        continue block4;
                    }
                    if (CipherData.isOfType(oMElement)) {
                        this.fCipherData = new CipherData(oMElement);
                        continue block4;
                    }
                    if (EncryptionProperties.isOfType(oMElement)) {
                        this.fEncryptionProperties = new EncryptionProperties(oMElement);
                        continue block4;
                    }
                    if (!EncryptedData.isOfType(oMElement)) continue block4;
                    this.fType = "http://www.w3.org/2001/04/xmlenc#Element";
                    this.fMimeType = oMElement.getAttributeValue(ATTR_MIME_TYPE_Q);
                    this.fEncoding = oMElement.getAttributeValue(ATTR_ENCODING_Q);
                    this.init(oMNode2);
                    continue block4;
                }
                case 9: {
                    this.init(oMNode2);
                }
            }
        }
    }

    public void setId(String string) {
        this.fId = string;
    }

    public String getId() {
        return this.fId;
    }

    public void setType(String string) {
        this.fType = string;
    }

    public String getType() {
        return this.fType;
    }

    public void setMimeType(String string) {
        this.fMimeType = string;
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public void setEncoding(String string) {
        this.fEncoding = string;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.fEncryptionMethod = encryptionMethod;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.fEncryptionMethod;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.fKeyInfo = keyInfo;
    }

    public KeyInfo getKeyInfo() {
        return this.fKeyInfo;
    }

    public void setCipherData(CipherData cipherData) {
        this.fCipherData = cipherData;
    }

    public CipherData getCipherData() {
        return this.fCipherData;
    }

    public void setEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.fEncryptionProperties = encryptionProperties;
    }

    public EncryptionProperties getEncryptionProperties() {
        return this.fEncryptionProperties;
    }

    void createElement(OMElement oMElement, OMFactory oMFactory) throws StructureException {
        OMElement oMElement2;
        if (this.fId != null) {
            oMElement.addAttribute(ATTR_ID, Util.normalize(this.fId), null);
        }
        if (this.fType != null) {
            oMElement.addAttribute(ATTR_TYPE, Util.normalize(this.fType), null);
        }
        if (this.fMimeType != null) {
            oMElement.addAttribute(ATTR_MIME_TYPE, Util.normalize(this.fMimeType), null);
        }
        if (this.fEncoding != null) {
            oMElement.addAttribute(ATTR_ENCODING, Util.normalize(this.fEncoding), null);
        }
        if (this.fEncryptionMethod != null) {
            oMElement2 = this.fEncryptionMethod.createElement(oMFactory, false);
            oMElement.addChild(oMElement2);
        }
        if (this.fKeyInfo != null) {
            oMElement2 = this.fKeyInfo.createElement(oMFactory, true);
            oMElement.addChild(oMElement2);
        }
        if (this.fCipherData == null) {
            throw new StructureException("CipherData not specified");
        }
        oMElement2 = this.fCipherData.createElement(oMFactory, false);
        oMElement.addChild(oMElement2);
        if (this.fEncryptionProperties != null) {
            oMElement2 = this.fEncryptionProperties.createElement(oMFactory, false);
            oMElement.addChild(oMElement2);
        }
    }

    void createElement(OMElement oMElement, OMElement oMElement2, OMFactory oMFactory, OMNamespace oMNamespace) throws StructureException {
        OMElement oMElement3;
        if (this.fId != null) {
            oMElement.addAttribute(ATTR_ID, Util.normalize(this.fId), oMNamespace);
        }
        if (this.fMimeType != null) {
            oMElement2.addAttribute(ATTR_MIME_TYPE, Util.normalize(this.fMimeType), null);
        }
        if (this.fEncoding != null) {
            oMElement2.addAttribute(ATTR_ENCODING, Util.normalize(this.fEncoding), null);
        }
        if (this.fEncryptionMethod != null) {
            oMElement3 = this.fEncryptionMethod.createElement(oMFactory, false);
            oMElement2.addChild(oMElement3);
        }
        if (this.fKeyInfo != null) {
            oMElement3 = this.fKeyInfo.createElement(oMFactory, true);
            oMElement2.addChild(oMElement3);
        }
        if (this.fCipherData == null) {
            throw new StructureException("CipherData not specified");
        }
        oMElement3 = this.fCipherData.createElement(oMFactory, false);
        oMElement2.addChild(oMElement3);
        if (this.fEncryptionProperties != null) {
            oMElement3 = this.fEncryptionProperties.createElement(oMFactory, false);
            oMElement2.addChild(oMElement3);
        }
    }
}

