/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CarriedKeyName;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class EncryptedKey
extends EncryptedType {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptedKey";
    private static final String ATTR_RECIPIENT = "Recipient";
    private static final QName ATTR_RECIPIENT_Q = new QName("", "Recipient");
    public static final String TYPE = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    private String fRecipient;
    private ReferenceList fReferenceList;
    private CarriedKeyName fKeyName;

    public EncryptedKey() {
        this(null);
    }

    public EncryptedKey(OMElement oMElement) {
        super(oMElement);
        if (oMElement != null) {
            if (!EncryptedKey.isOfType(oMElement)) {
                throw new IllegalArgumentException("Not EncryptedKey element");
            }
            this.fRecipient = oMElement.getAttributeValue(ATTR_RECIPIENT_Q);
            this.init(oMElement);
        }
    }

    public static boolean isOfType(OMElement oMElement) {
        return oMElement != null && NAME.equals(oMElement.getLocalName()) && NAMESPACE.equals(oMElement.getNamespace() == null ? "" : oMElement.getNamespace().getName());
    }

    private void init(OMNode oMNode) {
        if (!(oMNode instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode oMNode2 = ((OMContainer)((Object)oMNode)).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
            switch (oMNode2.getType()) {
                case 1: {
                    OMElement oMElement = (OMElement)oMNode2;
                    if (ReferenceList.isOfType(oMElement)) {
                        this.fReferenceList = new ReferenceList(oMElement);
                        continue block4;
                    }
                    if (!CarriedKeyName.isOfType(oMElement)) continue block4;
                    this.fKeyName = new CarriedKeyName(oMElement);
                    continue block4;
                }
                case 9: {
                    this.init(oMNode2);
                }
            }
        }
    }

    public void setRecipient(String string) {
        this.fRecipient = string;
    }

    public String getRecipient() {
        return this.fRecipient;
    }

    public void setReferenceList(ReferenceList referenceList) {
        this.fReferenceList = referenceList;
    }

    public ReferenceList getReferenceList() {
        return this.fReferenceList;
    }

    public void setCarriedKeyName(CarriedKeyName carriedKeyName) {
        this.fKeyName = carriedKeyName;
    }

    public CarriedKeyName getCarriedKeyName() {
        return this.fKeyName;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public OMElement createElement(OMFactory oMFactory, boolean bl) throws StructureException {
        OMElement oMElement;
        if (oMFactory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement oMElement2 = oMFactory.createOMElement(NAME, NAMESPACE, "");
        if (bl) {
            oMElement2.declareDefaultNamespace(NAMESPACE);
        }
        super.createElement(oMElement2, oMFactory);
        if (this.fRecipient != null) {
            oMElement2.addAttribute(ATTR_RECIPIENT, Util.normalize(this.fRecipient), null);
        }
        if (this.fReferenceList != null) {
            oMElement = this.fReferenceList.createElement(oMFactory, false);
            oMElement2.addChild(oMElement);
        }
        if (this.fKeyName != null) {
            oMElement = this.fKeyName.createElement(oMFactory, false);
            oMElement2.addChild(oMElement);
        }
        return oMElement2;
    }
}

