/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class EncryptedHeader
extends EncryptedData {
    private static final String HEADERNAMESPACE = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    private static final String HEADERNAME = "EncryptedHeader";
    private static final String ATTR_ACTOR = "actor";
    private static final String ATTR_ROLE = "role";
    private static final String ATTR_RELAY = "relay";
    private static final String ATTR_MU = "mustUnderstand";
    private static final QName ATTR_ACTOR_Q = new QName("", "actor");
    private static final QName ATTR_ROLE_Q = new QName("", "role");
    private static final QName ATTR_RELAY_Q = new QName("", "relay");
    private static final QName ATTR_MU_Q = new QName("", "mustUnderstand");
    private String fActor;
    private String fRole;
    private String fRelay;
    private String fMustUnderstand;
    private String fSoapNs;
    private String fWsuNs;
    private String fSoapNsPrefix;
    private String fWsuNsPrefix;
    private String fWsse11NsPrefix;

    public EncryptedHeader() {
        this(null);
    }

    public EncryptedHeader(OMElement oMElement) {
        super(oMElement);
        if (oMElement != null) {
            if (!EncryptedHeader.isOfType(oMElement)) {
                throw new IllegalArgumentException("Not EncryptedHeader element");
            }
            if (oMElement != null) {
                this.fActor = oMElement.getAttributeValue(ATTR_ACTOR_Q);
                this.fRole = oMElement.getAttributeValue(ATTR_ROLE_Q);
                this.fRelay = oMElement.getAttributeValue(ATTR_RELAY_Q);
                this.fMustUnderstand = oMElement.getAttributeValue(ATTR_MU_Q);
            }
        }
    }

    public static boolean isOfType(OMElement oMElement) {
        return oMElement != null && HEADERNAME.equals(oMElement.getLocalName()) && HEADERNAMESPACE.equals(oMElement.getNamespace() == null ? "" : oMElement.getNamespace().getName());
    }

    public void setMustUnderstand(String string) {
        this.fMustUnderstand = string;
    }

    public String getMustUnderstand() {
        return this.fMustUnderstand;
    }

    public void setActor(String string) {
        this.fActor = string;
    }

    public String getActor() {
        return this.fActor;
    }

    public void setRole(String string) {
        this.fRole = string;
    }

    public String getRole() {
        return this.fRole;
    }

    public void setRelay(String string) {
        this.fRelay = string;
    }

    public String getRelay() {
        return this.fRelay;
    }

    public void setSoapNs(String string) {
        this.fSoapNs = string;
    }

    public String getSoapNs() {
        return this.fSoapNs;
    }

    public void setSoapNsPrefix(String string) {
        this.fSoapNsPrefix = string;
    }

    public String getSoapNsPrefix() {
        return this.fSoapNsPrefix;
    }

    public void setWsuNs(String string) {
        this.fWsuNs = string;
    }

    public String getWsuNs() {
        return this.fWsuNs;
    }

    public void setWsuNsPrefix(String string) {
        this.fWsuNsPrefix = string;
    }

    public String getWsuNsPrefix() {
        return this.fWsuNsPrefix;
    }

    public void setWsse11NsPrefix(String string) {
        this.fWsse11NsPrefix = string;
    }

    public String getWsse11NsPrefix() {
        return this.fWsse11NsPrefix;
    }

    public String getNamespaceURI() {
        return HEADERNAMESPACE;
    }

    public OMElement createElement(OMFactory oMFactory, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws StructureException {
        if (oMFactory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement oMElement = null;
        if (this.fWsse11NsPrefix != null) {
            oMElement = oMFactory.createOMElement(HEADERNAME, HEADERNAMESPACE, this.fWsse11NsPrefix);
            if (bl4) {
                oMElement.declareNamespace(HEADERNAMESPACE, this.fWsse11NsPrefix);
            }
        } else {
            oMElement = oMFactory.createOMElement(HEADERNAME, HEADERNAMESPACE, "");
            if (bl) {
                oMElement.declareDefaultNamespace(HEADERNAMESPACE);
            }
        }
        OMNamespace oMNamespace = null;
        OMNamespace oMNamespace2 = null;
        if (this.fSoapNsPrefix != null) {
            oMNamespace = oMFactory.createOMNamespace(this.fSoapNs, this.fSoapNsPrefix);
            if (bl2) {
                oMElement.declareNamespace(this.fSoapNs, this.fSoapNsPrefix);
            }
        }
        if (this.fWsuNsPrefix != null) {
            oMNamespace2 = oMFactory.createOMNamespace(this.fWsuNs, this.fWsuNsPrefix);
            if (bl3) {
                oMElement.declareNamespace(this.fWsuNs, this.fWsuNsPrefix);
            }
        }
        if (this.fActor != null) {
            oMElement.addAttribute(ATTR_ACTOR, Util.normalize(this.fActor), oMNamespace);
        }
        if (this.fRole != null) {
            oMElement.addAttribute(ATTR_ROLE, Util.normalize(this.fRole), oMNamespace);
        }
        if (this.fRelay != null) {
            oMElement.addAttribute(ATTR_RELAY, Util.normalize(this.fRelay), oMNamespace);
        }
        if (this.fMustUnderstand != null) {
            oMElement.addAttribute(ATTR_MU, Util.normalize(this.fMustUnderstand), oMNamespace);
        }
        super.createElement(oMElement, oMFactory, bl, oMNamespace2);
        return oMElement;
    }

    public void initFromEncryptedData(EncryptedData encryptedData) {
        if (encryptedData != null) {
            this.setCipherData(encryptedData.getCipherData());
            this.setEncoding(encryptedData.getEncoding());
            this.setEncryptionMethod(encryptedData.getEncryptionMethod());
            this.setEncryptionProperties(encryptedData.getEncryptionProperties());
            this.setId(encryptedData.getId());
            this.setKeyInfo(encryptedData.getKeyInfo());
            this.setMimeType(encryptedData.getMimeType());
            this.setType(encryptedData.getType());
        }
    }
}

