/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class DigestMethod
extends ElementsType {
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String RIPEMD160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "DigestMethod";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private static final QName ATTR_ALGORITHM_Q = new QName("", "Algorithm");
    private String fAlgorithm;

    public DigestMethod() {
        this(null);
    }

    public DigestMethod(OMElement oMElement) {
        super(oMElement);
        if (oMElement != null) {
            if (!DigestMethod.isOfType(oMElement)) {
                throw new IllegalArgumentException("Not DigestMethod element");
            }
            this.fAlgorithm = oMElement.getAttributeValue(ATTR_ALGORITHM_Q);
            this.init(oMElement);
        }
    }

    public static boolean isOfType(OMElement oMElement) {
        return oMElement != null && NAME.equals(oMElement.getLocalName()) && NAMESPACE.equals(oMElement.getNamespace() == null ? "" : oMElement.getNamespace().getName());
    }

    private void init(OMNode oMNode) {
        if (!(oMNode instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode oMNode2 = ((OMContainer)((Object)oMNode)).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
            switch (oMNode2.getType()) {
                case 1: {
                    OMElement oMElement = (OMElement)oMNode2;
                    if (!this.isParameter(oMElement)) continue block4;
                    super.addElement(oMElement);
                    continue block4;
                }
                case 9: {
                    this.init(oMNode2);
                }
            }
        }
    }

    private boolean isParameter(OMElement oMElement) {
        String string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
        return string != null && !string.equals(NAMESPACE);
    }

    public void setAlgorithm(String string) {
        this.fAlgorithm = string;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public void addParameter(OMElement oMElement) {
        if (oMElement != null) {
            if (!this.isParameter(oMElement)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(oMElement);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public OMElement createElement(OMFactory oMFactory, boolean bl) throws StructureException {
        if (oMFactory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement oMElement = oMFactory.createOMElement(NAME, NAMESPACE, "");
        if (bl) {
            oMElement.declareDefaultNamespace(NAMESPACE);
        }
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        oMElement.addAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm), null);
        super.createElement(oMElement, oMFactory, NAMESPACE);
        return oMElement;
    }
}

