/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CarriedKeyName;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyName;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.RetrievalMethod;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.xml.sax.EntityResolver;

public class KeyInfoResolverBase
implements KeyInfoResolver {
    private static final boolean DEBUG = false;
    protected boolean fInEncryptMode;
    private AlgorithmParameterSpec fKeyGenParameters;
    private AlgorithmFactory fAlgorithmFactory;
    private IDResolver fIdResolver;
    private EntityResolver fEntityResolver;
    private EncryptedKeyRetriever fEncryptedKeyRetriever;

    public void setAlgorithmFactory(AlgorithmFactory algorithmFactory) {
        this.fAlgorithmFactory = algorithmFactory;
    }

    public void setIdResolver(IDResolver iDResolver) {
        this.fIdResolver = iDResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fEntityResolver = entityResolver;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever encryptedKeyRetriever) {
        this.fEncryptedKeyRetriever = encryptedKeyRetriever;
    }

    protected Key resolveEncryptedKey(EncryptedKey encryptedKey, EncryptionMethod encryptionMethod, Key key) throws KeyInfoResolvingException {
        if (this.fInEncryptMode) {
            EncryptionContext encryptionContext = new EncryptionContext();
            encryptionContext.setAlgorithmFactory(this.fAlgorithmFactory);
            if (key == null) {
                encryptionContext.setEncryptedType(null, null, encryptionMethod, null);
                try {
                    key = encryptionContext.generateKey();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                encryptionContext.setKey(null);
            }
            encryptionContext.setData(key);
            encryptionContext.setEncryptedType(encryptedKey, null, null, null);
            encryptionContext.setKeyInfoResolver(this);
            try {
                encryptionContext.encrypt();
            }
            catch (KeyInfoResolvingException keyInfoResolvingException) {
                throw keyInfoResolvingException;
            }
            catch (Exception exception) {}
        } else {
            DecryptionContext decryptionContext;
            block11: {
                decryptionContext = new DecryptionContext();
                decryptionContext.setEncryptedType(encryptedKey, null, null, null);
                decryptionContext.setEncryptionMethod(encryptionMethod);
                decryptionContext.setAlgorithmFactory(this.fAlgorithmFactory);
                decryptionContext.setKeyInfoResolver(this);
                decryptionContext.setIdResolver(this.fIdResolver);
                decryptionContext.setEntityResolver(this.fEntityResolver);
                decryptionContext.setEncryptedKeyRetriever(this.fEncryptedKeyRetriever);
                try {
                    decryptionContext.decrypt();
                }
                catch (KeyInfoResolvingException keyInfoResolvingException) {
                    throw keyInfoResolvingException;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (!(exception instanceof XSignatureException) || (exception2 = ((XSignatureException)exception).getException()) == null) break block11;
                    Exception exception3 = exception2;
                }
            }
            key = (Key)decryptionContext.getData();
        }
        return key;
    }

    protected Key resolveKeyName(KeyName keyName, EncryptionMethod encryptionMethod, Key key) throws KeyInfoResolvingException {
        OMElement oMElement;
        String string;
        if (!this.fInEncryptMode && (string = keyName.getName()) != null && (oMElement = DOMUtil.getOwnerDocument(keyName.getBase()).getOMDocumentElement()) != null) {
            ArrayList arrayList = new ArrayList();
            this.addEncryptedKeys(oMElement, string, arrayList);
            Iterator iterator = arrayList.iterator();
            while (key == null && iterator.hasNext()) {
                key = this.resolveEncryptedKey((EncryptedKey)iterator.next(), encryptionMethod, key);
            }
        }
        return key;
    }

    private void addEncryptedKeys(OMNode oMNode, String string, List list) {
        if (oMNode.getType() == 1) {
            OMElement oMElement = (OMElement)oMNode;
            if (EncryptedKey.isOfType(oMElement)) {
                this.addEncryptedKeys(new EncryptedKey((OMElement)oMNode), string, list);
            } else {
                for (OMNode oMNode2 = oMElement.getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
                    this.addEncryptedKeys(oMNode2, string, list);
                }
            }
        }
    }

    private void addEncryptedKeys(EncryptedKey encryptedKey, String string, List list) {
        Object object;
        CarriedKeyName carriedKeyName = encryptedKey.getCarriedKeyName();
        if (carriedKeyName != null && (object = carriedKeyName.getName()) != null && ((String)object).equals(string)) {
            list.add(encryptedKey);
        }
        if ((object = encryptedKey.getKeyInfo()) != null) {
            for (Object e : ((KeyInfo)object).getKeyIds()) {
                if (!(e instanceof EncryptedKey)) continue;
                this.addEncryptedKeys((EncryptedKey)e, string, list);
            }
        }
    }

    protected Key resolveRetrievalMethod(RetrievalMethod retrievalMethod, EncryptionMethod encryptionMethod, Key key) throws KeyInfoResolvingException {
        if (!this.fInEncryptMode) {
            Object object;
            block4: {
                SignatureContext signatureContext = new SignatureContext();
                signatureContext.setAlgorithmFactory(this.fAlgorithmFactory);
                signatureContext.setIDResolver(this.fIdResolver);
                signatureContext.setEntityResolver(this.fEntityResolver);
                object = null;
                try {
                    object = signatureContext.retrieve(retrievalMethod.getBase());
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (!(exception instanceof XSignatureException) || (exception2 = ((XSignatureException)exception).getException()) == null) break block4;
                    Exception exception3 = exception2;
                }
            }
            if (object instanceof EncryptedKey) {
                key = this.resolveEncryptedKey((EncryptedKey)object, encryptionMethod, key);
            }
        }
        return key;
    }

    protected Key resolveKeyId(OMElement oMElement, EncryptionMethod encryptionMethod, Key key) throws KeyInfoResolvingException {
        return key;
    }

    public void setOperationMode(int n) {
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation mode: " + n);
            }
        }
        this.fInEncryptMode = bl;
    }

    public Key resolve(KeyInfo keyInfo, EncryptionMethod encryptionMethod) throws KeyInfoResolvingException {
        if (keyInfo == null) {
            throw new NullPointerException("KeyInfo not specified");
        }
        Key key = null;
        for (Object e : keyInfo.getKeyIds()) {
            if (e instanceof EncryptedKey) {
                key = this.resolveEncryptedKey((EncryptedKey)e, encryptionMethod, key);
            } else if (e instanceof KeyName) {
                key = this.resolveKeyName((KeyName)e, encryptionMethod, key);
            } else if (e instanceof RetrievalMethod) {
                key = this.resolveRetrievalMethod((RetrievalMethod)e, encryptionMethod, key);
            } else if (e instanceof OMElement) {
                key = this.resolveKeyId((OMElement)e, encryptionMethod, key);
            }
            if (this.fInEncryptMode || key == null) continue;
            break;
        }
        return key;
    }
}

