/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.core.EncryptionEngine;
import com.ibm.ws.wssecurity.core.KeyGenerationEngine;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DOMSerializationEngine;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedTypeContainer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionOutputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceOutputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class EncryptionContext {
    private static final boolean DEBUG = false;
    private Object fData;
    private EncryptedTypeContainer fEncryptedTypeContainer;
    private Key fKey;
    private OutputStream fOut;
    private AlgorithmFactory fAlgorithmFactory;
    private KeyInfoResolver fKeyInfoResolver;
    private HWKeyCache fHWKeyCache;
    private OMElement fEncryptedType;
    private ResourceShower shower;
    private Provider hwAccelerationProvider = null;
    private Provider hwKeyStoreProvider = null;
    private String _hwConfigName = null;
    private String _hwKeyStoreName = null;
    private String allCryptoOffload = null;
    private String encAlgorithm = null;
    private Boolean _offload = Boolean.TRUE;
    private boolean _mtomOptimize = false;
    private String _endpointReference = null;
    private boolean debug = false;

    public EncryptionContext() {
        this.fAlgorithmFactory = AlgorithmFactory.getInstance();
        this.fHWKeyCache = HWKeyCache.getInstance();
    }

    public void setEncAlgorithm(String string) {
        this.encAlgorithm = string;
    }

    public void setHWKeyStoreName(String string) {
        this._hwKeyStoreName = string;
    }

    public void setOffload(Boolean bl) {
        this._offload = bl;
    }

    public String getHWKeyStoreName() {
        return this._hwKeyStoreName;
    }

    public void setHWConfigName(String string) {
        this._hwConfigName = string;
    }

    public String getHWConfigName() {
        return this._hwConfigName;
    }

    public void setEndpointReference(String string) {
        this._endpointReference = string;
    }

    public String getEndpointReference() {
        return this._endpointReference;
    }

    public boolean shouldChangeProvider() {
        return this._hwConfigName != null && this._hwConfigName.length() > 0 && HWKeyCache.isHWEncAlgorithm(this.encAlgorithm) && this._offload != false;
    }

    public boolean useHWKeyStore() {
        return this._hwKeyStoreName != null && this._hwKeyStoreName.length() > 0;
    }

    public Provider getHWAccelerationProvider() {
        return this.hwAccelerationProvider;
    }

    public Provider getHWKeyStoreProvider() {
        return this.hwKeyStoreProvider;
    }

    public void setHWAccelerationProvider(Provider provider, Integer n) {
        if (this.shouldChangeProvider()) {
            this.hwAccelerationProvider = provider;
            this.fHWKeyCache.setProvider(provider, n);
        }
    }

    public void setHWKeyStoreProvider(Provider provider) {
        this.hwKeyStoreProvider = provider;
    }

    public boolean isHWAccelerationProvider() {
        return this.hwAccelerationProvider != null;
    }

    public boolean isHWKeyStoreProvider() {
        return this.hwKeyStoreProvider != null;
    }

    public void clearLocalProviderMap() {
        this.fAlgorithmFactory.clearLocalProviderMap();
    }

    public void setCryptoOffloadProperty(String string) {
        this.allCryptoOffload = string;
    }

    public void setMTOMOptimize(boolean bl) {
        this._mtomOptimize = bl;
    }

    public void setData(InputStream inputStream) {
        this.fData = inputStream;
    }

    public void setData(byte[] byArray) {
        this.fData = byArray;
    }

    public void setData(OMElement oMElement) {
        this.fData = oMElement;
    }

    public void setData(Key key) {
        this.fData = key;
    }

    public void setEncryptedType(OMElement oMElement, String string, OMElement oMElement2, OMElement oMElement3) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(oMElement, string, oMElement2, oMElement3);
    }

    void setEncryptedType(EncryptedType encryptedType, String string, EncryptionMethod encryptionMethod, KeyInfo keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encryptedType, string, encryptionMethod, keyInfo);
    }

    public boolean setHWKeyFromCache(PublicKey publicKey) throws Exception {
        this.fKey = this.fHWKeyCache.translate(publicKey);
        return this.fKey != null;
    }

    public void setKey(Key key) {
        this.fKey = key;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.fOut = outputStream;
    }

    public void setAlgorithmFactory(AlgorithmFactory algorithmFactory) {
        if (algorithmFactory == null) {
            throw new NullPointerException("AlgorithmFactory is null.");
        }
        this.fAlgorithmFactory = algorithmFactory;
    }

    public void setKeyInfoResolver(KeyInfoResolver keyInfoResolver) {
        this.fKeyInfoResolver = keyInfoResolver;
    }

    public InputStream getEncryptedType() {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.fEncryptedType != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.serialize(this.fEncryptedType));
        }
        return byteArrayInputStream;
    }

    private byte[] serialize(OMElement oMElement) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DOMSerializationEngine.XMLElement xMLElement = new DOMSerializationEngine.XMLElement();
        ((DOMSerializationEngine)xMLElement).setOutputStream(byteArrayOutputStream);
        try {
            ArrayList<OMElement> arrayList = new ArrayList<OMElement>();
            arrayList.add(oMElement);
            ((DOMSerializationEngine)xMLElement).serialize(arrayList.iterator());
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public OMElement getEncryptedTypeAsElement() {
        return this.fEncryptedType;
    }

    public Key getKey() {
        return this.fKey;
    }

    public void encrypt() throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        Object object;
        OutputStream outputStream = null;
        if (this.fData == null) {
            throw new NullPointerException("Data not specified");
        }
        if (this.fData instanceof InputStream) {
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, EncryptionContext, encrypt, fData is instance of InputStream");
            }
            outputStream = this.getEncryptionOutputStream();
            if (this.shower != null) {
                outputStream = this.getResourceOutputStream(outputStream);
            }
            Util.getBytes((InputStream)this.fData, outputStream);
            if (this.shower != null) {
                outputStream = this.showResource((ResourceOutputStream)outputStream);
            }
        } else if (this.fData instanceof byte[]) {
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, EncryptionContext, encrypt, fData is instance of byte[]");
            }
            outputStream = this.getEncryptionOutputStream();
            if (this.shower != null) {
                outputStream = this.getResourceOutputStream(outputStream);
            }
            outputStream.write((byte[])this.fData);
            if (this.shower != null) {
                outputStream = this.showResource((ResourceOutputStream)outputStream);
            }
        } else if (this.fData instanceof OMElement) {
            if (this.debug) {
                System.out.println("HWC: EncryptionContext, encrypt, fData is instance of OMElement");
            }
            outputStream = this.getEncryptionOutputStream();
            if (this.shower != null) {
                outputStream = this.getResourceOutputStream(outputStream);
            }
            this.serialize((OMElement)this.fData, outputStream);
            if (this.shower != null) {
                outputStream = this.showResource((ResourceOutputStream)outputStream);
            }
        } else if (this.fData instanceof Key) {
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, EncryptionContext, encrypt, fData is instance of Key");
            }
            object = this.getEncryptionEngine(3);
            outputStream = this.getOutputStream();
            try {
                outputStream.write(object.wrap((Key)this.fData));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (this.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    outputStream = this.getOutputStream();
                    outputStream.write(object.wrap((Key)this.fData));
                }
                throw outOfMemoryError;
            }
            outputStream.flush();
            this.fAlgorithmFactory.releaseEncryptionEngine((EncryptionEngine)object);
            if (this.shower != null) {
                this.showResource((Key)this.fData);
            }
        }
        this.doFinal(outputStream);
        if (this.debug) {
            System.out.println("HWC: EncryptionContext, encrypt, after clearLocalProviderMap");
            object = (Provider)this.fAlgorithmFactory.getLocalProvider("HWCONFIG");
            if (object != null) {
                System.out.println("HWC: EncryptionContext, encrypt, alg factory's hw provider: " + ((Provider)object).getName());
            } else {
                System.out.println("HWC: EncryptionContext, encrypt, alg factory's hw provider is cleared");
            }
        }
    }

    public EncryptionOutputStream getEncryptionOutputStream() throws IOException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        EncryptionEngine encryptionEngine = this.getEncryptionEngine(1);
        OutputStream outputStream = this.getOutputStream();
        EncryptionOutputStream encryptionOutputStream = new EncryptionOutputStream(outputStream, encryptionEngine, this.fAlgorithmFactory);
        return encryptionOutputStream;
    }

    private EncryptionEngine getEncryptionEngine(int n) throws InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptionMethod encryptionMethod = this.fEncryptedTypeContainer.getEM();
        if (encryptionMethod == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        String string = encryptionMethod.getAlgorithm();
        if (string == null) {
            throw new StructureException("Algorithm attribute not specified");
        }
        Key key = this._getKey();
        if (key == null) {
            throw new NullPointerException("Key not specified or obtained");
        }
        if (this.isHWAccelerationProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else if (!(string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
            if (this.debug) {
                System.out.println("HWC: Hardware provider instance is : " + this.getHWAccelerationProvider().getName());
            }
        }
        if (this.isHWKeyStoreProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else if (!(string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
        }
        EncryptionEngine encryptionEngine = this.fAlgorithmFactory.getEncryptionEngine(string);
        AlgorithmParameterSpec algorithmParameterSpec = encryptionMethod.getParameterSpec(this.fAlgorithmFactory);
        encryptionEngine.init(n, key, algorithmParameterSpec);
        return encryptionEngine;
    }

    private Key _getKey() throws KeyInfoResolvingException {
        KeyInfo keyInfo;
        if (this.fKey == null && (keyInfo = this.fEncryptedTypeContainer.getKI()) != null && this.fKeyInfoResolver != null) {
            this.fKey = this.fKeyInfoResolver.resolve(keyInfo, this.fEncryptedTypeContainer.getEM());
        }
        return this.fKey;
    }

    private OutputStream getOutputStream() throws StructureException {
        OutputStream outputStream = null;
        if (this.hasCipherValue()) {
            outputStream = new ByteArrayOutputStream();
        } else if (this.fOut != null) {
            outputStream = this.fOut;
        } else {
            throw new NullPointerException("Neither CipherValue element nor output stream specified");
        }
        return outputStream;
    }

    private boolean hasCipherValue() throws StructureException {
        EncryptedType encryptedType = this.fEncryptedTypeContainer.getET();
        if (encryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        return this.getCipherValue(encryptedType) != null;
    }

    private CipherValue getCipherValue(EncryptedType encryptedType) throws StructureException {
        CipherData cipherData = encryptedType.getCipherData();
        if (cipherData == null) {
            throw new StructureException("CipherData element not specified");
        }
        Type type = cipherData.getCipherData();
        if (type == null) {
            throw new StructureException("Neither CipherValue nor CipherReference element specified");
        }
        CipherValue cipherValue = null;
        if (type instanceof CipherValue) {
            cipherValue = (CipherValue)type;
        }
        return cipherValue;
    }

    private void serialize(OMElement oMElement, OutputStream outputStream) throws IOException, NoSuchAlgorithmException, StructureException {
        Object object;
        String string = this.fEncryptedTypeContainer.getType();
        if (string == null) {
            throw new StructureException("Type attribute not specified");
        }
        Iterator iterator = null;
        if (string.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            object = new ArrayList<OMElement>();
            ((ArrayList)object).add(oMElement);
            iterator = ((ArrayList)object).iterator();
        } else if (string.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            iterator = DOMUtil.getChildNodes(oMElement);
        } else {
            throw new StructureException("Unknown type: " + string);
        }
        object = this.fAlgorithmFactory.getDOMSerializationEngine(string);
        ((DOMSerializationEngine)object).setOutputStream(outputStream);
        ((DOMSerializationEngine)object).serialize(iterator);
    }

    public void doFinal(OutputStream outputStream) throws IOException, StructureException {
        if (outputStream instanceof EncryptionOutputStream) {
            EncryptionOutputStream encryptionOutputStream = (EncryptionOutputStream)outputStream;
            encryptionOutputStream.doFinal();
            encryptionOutputStream.flush();
            outputStream = encryptionOutputStream.getOutputStream();
        }
        this.fEncryptedType = this.getEncryptedType(outputStream);
    }

    private OMElement getEncryptedType(OutputStream outputStream) throws StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptedType encryptedType = this.fEncryptedTypeContainer.getET();
        if (encryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        CipherValue cipherValue = this.getCipherValue(encryptedType);
        if (cipherValue != null) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)outputStream;
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.setCipherValue(cipherValue, byteArrayOutputStream.toByteArray());
        }
        return encryptedType.getBase();
    }

    private void setCipherValue(CipherValue cipherValue, byte[] byArray) throws StructureException {
        OMElement oMElement = cipherValue.getBase();
        cipherValue = new CipherValue();
        cipherValue.setValue(byArray);
        OMElement oMElement2 = cipherValue.createElement(oMElement.getOMFactory(), false, this._mtomOptimize);
        DOMUtil.removeChildNodes(oMElement);
        DOMUtil.moveChildNodes(oMElement2, oMElement);
    }

    public Key generateKey() throws Exception {
        try {
            this.fKey = this.fHWKeyCache.generate(this.getEndpointReference());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            HWKeyCache.setCapacityReached();
            this.fKey = this.fHWKeyCache.generate(this.getEndpointReference());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.fKey == null) {
            KeyGenerationEngine keyGenerationEngine = this.getKeyGenerationEngine();
            this.fKey = keyGenerationEngine.generateKey();
            this.fAlgorithmFactory.releaseKeyGenerationEngine(keyGenerationEngine);
            this.fHWKeyCache.addGeneratedKey(this.getEndpointReference(), this.fKey);
            if (this.debug) {
                System.out.println("HWC: EncryptionContext generateKey, about to call clearLocalProviderMap");
            }
            if (this.debug) {
                System.out.println("HWC: EncryptionContext, generateKey, after clearLocalProviderMap");
                Provider provider = (Provider)this.fAlgorithmFactory.getLocalProvider("HWCONFIG");
                if (provider != null) {
                    System.out.println("HWC: EncryptionContext, generateKey, alg factory's hw provider: " + provider.getName());
                } else {
                    System.out.println("HWC: EncryptionContext, generateKey, alg factory's hw provider is cleared");
                }
            }
        }
        return this.fKey;
    }

    private KeyGenerationEngine getKeyGenerationEngine() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptionMethod encryptionMethod = this.fEncryptedTypeContainer.getEM();
        if (encryptionMethod == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        String string = encryptionMethod.getAlgorithm();
        if (string == null) {
            throw new StructureException("Algorithm attribute not specified");
        }
        if (this.isHWAccelerationProvider()) {
            this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            if (this.debug) {
                System.out.println("HWC: EncryptionContext, getKeyGenerationEngine, hwprovider: " + this.getHWAccelerationProvider().getName());
            }
        }
        if (this.isHWKeyStoreProvider()) {
            this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        if (this.debug) {
            System.out.println("HWC: EncryptionContext, getKeyGenerationEngine, about to call AlgorithmFactory's and uri is : " + string);
        }
        KeyGenerationEngine keyGenerationEngine = this.fAlgorithmFactory.getKeyGenerationEngine(string, this.fEncryptedTypeContainer.getType());
        AlgorithmParameterSpec algorithmParameterSpec = encryptionMethod.getParameterSpec(this.fAlgorithmFactory);
        keyGenerationEngine.init(algorithmParameterSpec);
        return keyGenerationEngine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replace() throws StructureException {
        if (this.fEncryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element obtained");
        }
        if (!(this.fData instanceof OMElement)) throw new RuntimeException("Instance of unknown class: " + this.fData.getClass().getName());
        OMElement oMElement = (OMElement)this.fData;
        OMElement oMElement2 = this.fEncryptedType;
        String string = this.fEncryptedTypeContainer.getType();
        if (string.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            oMElement2 = (OMElement)DOMUtil.replaceNode((OMNode)oMElement, oMElement2);
        } else {
            if (!string.equals("http://www.w3.org/2001/04/xmlenc#Content")) throw new StructureException("Unknown type: " + string);
            oMElement2 = (OMElement)DOMUtil.replaceNodes(DOMUtil.getChildNodes(oMElement), oMElement2);
        }
        this.fEncryptedType = oMElement2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replace(OMElement oMElement) throws StructureException {
        if (this.fEncryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element obtained");
        }
        if (oMElement == null) throw new RuntimeException("No element specified to replace");
        OMElement oMElement2 = oMElement;
        OMElement oMElement3 = this.fEncryptedType;
        String string = this.fEncryptedTypeContainer.getType();
        if (string.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            oMElement3 = (OMElement)DOMUtil.replaceNode((OMNode)oMElement2, oMElement3);
        } else {
            if (!string.equals("http://www.w3.org/2001/04/xmlenc#Content")) throw new StructureException("Unknown type: " + string);
            oMElement3 = (OMElement)DOMUtil.replaceNodes(DOMUtil.getChildNodes(oMElement2), oMElement3);
        }
        this.fEncryptedType = oMElement3;
    }

    public void setResourceShower(ResourceShower resourceShower) {
        this.shower = resourceShower;
    }

    private ResourceOutputStream getResourceOutputStream(OutputStream outputStream) {
        return new ResourceOutputStream(outputStream, this.shower, this.fData, this.fEncryptedTypeContainer.getEncryptedType());
    }

    private OutputStream showResource(ResourceOutputStream resourceOutputStream) {
        resourceOutputStream.showResource();
        return resourceOutputStream.getOutputStream();
    }

    private void showResource(Key key) {
        this.shower.showEncryptedResource(key.getEncoded(), this.fData, this.fEncryptedTypeContainer.getEncryptedType());
    }
}

