/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import org.apache.axiom.om.OMElement;

class EncryptedTypeContainer {
    private EncryptedType fEncryptedType;
    private String fType;
    private EncryptionMethod fEncryptionMethod;
    private KeyInfo fKeyInfo;

    EncryptedTypeContainer(OMElement oMElement, String string, OMElement oMElement2, OMElement oMElement3) {
        this.fType = string;
        this.setEncryptionMethod(oMElement2);
        this.setKeyInfo(oMElement3);
        this.setEncryptedType(oMElement);
    }

    EncryptedTypeContainer(EncryptedType encryptedType, String string, EncryptionMethod encryptionMethod, KeyInfo keyInfo) {
        this.fType = string;
        this.fEncryptionMethod = encryptionMethod;
        this.fKeyInfo = keyInfo;
        this.setET(encryptedType);
    }

    void setEncryptedType(OMElement oMElement) {
        EncryptedType encryptedType = null;
        if (oMElement != null) {
            encryptedType = EncryptedType.getInstance(oMElement);
        }
        this.setET(encryptedType);
    }

    void setET(EncryptedType encryptedType) {
        this.fEncryptedType = encryptedType;
        if (encryptedType != null) {
            if (this.fType == null) {
                this.fType = encryptedType.getType();
                if (this.fType == null && encryptedType instanceof EncryptedHeader) {
                    this.fType = "http://www.w3.org/2001/04/xmlenc#Element";
                }
            }
            if (this.fEncryptionMethod == null) {
                this.fEncryptionMethod = encryptedType.getEncryptionMethod();
            }
            if (this.fKeyInfo == null) {
                this.fKeyInfo = encryptedType.getKeyInfo();
            }
        }
    }

    OMElement getEncryptedType() {
        OMElement oMElement = null;
        if (this.fEncryptedType != null) {
            oMElement = this.fEncryptedType.getBase();
        }
        return oMElement;
    }

    EncryptedType getET() {
        return this.fEncryptedType;
    }

    void setType(String string) {
        this.fType = string;
    }

    String getType() {
        return this.fType;
    }

    void setEncryptionMethod(OMElement oMElement) {
        EncryptionMethod encryptionMethod = null;
        if (oMElement != null) {
            encryptionMethod = new EncryptionMethod(oMElement);
        }
        this.fEncryptionMethod = encryptionMethod;
    }

    void setEM(EncryptionMethod encryptionMethod) {
        this.fEncryptionMethod = encryptionMethod;
    }

    OMElement getEncryptionMethod() {
        OMElement oMElement = null;
        if (this.fEncryptionMethod != null) {
            oMElement = this.fEncryptionMethod.getBase();
        }
        return oMElement;
    }

    EncryptionMethod getEM() {
        return this.fEncryptionMethod;
    }

    void setKeyInfo(OMElement oMElement) {
        KeyInfo keyInfo = null;
        if (oMElement != null) {
            keyInfo = new KeyInfo(oMElement);
        }
        this.fKeyInfo = keyInfo;
    }

    void setKI(KeyInfo keyInfo) {
        this.fKeyInfo = keyInfo;
    }

    OMElement getKeyInfo() {
        OMElement oMElement = null;
        if (this.fKeyInfo != null) {
            oMElement = this.fKeyInfo.getBase();
        }
        return oMElement;
    }

    KeyInfo getKI() {
        return this.fKeyInfo;
    }
}

