/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.core.EncryptionEngine;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.AdoptingDOMBuilder;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.FastBAOutputStream;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedTypeContainer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionInputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceInputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.XMLWriter;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherReference;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.DsTransforms;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Transforms;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.TransformsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.xml.sax.EntityResolver;

public class DecryptionContext {
    private static final boolean DEBUG = false;
    private static final Class[] adoptNodeArgs = new Class[]{OMNode.class};
    private EncryptedTypeContainer fEncryptedTypeContainer;
    private EncryptionMethod fEncryptionMethod;
    private Key fKey;
    private AlgorithmFactory fAlgorithmFactory;
    private KeyInfoResolver fKeyInfoResolver;
    private IDResolver fIdResolver;
    private EntityResolver fEntityResolver;
    private EncryptedKeyRetriever fEncryptedKeyRetriever;
    private HWKeyCache fHWKeyCache;
    private Object fData;
    private String fType;
    private String fMimeType;
    private String fEncoding;
    private ResourceShower shower;
    private String encAlgorithm = null;
    private Provider hwAccelerationProvider = null;
    private Provider hwKeyStoreProvider = null;
    private String _hwConfigName = null;
    private String _hwKeyStoreName = null;
    private String allCryptoOffload = null;
    private Boolean _offload = Boolean.TRUE;
    private boolean debug = false;
    private Map fContext = null;

    public DecryptionContext() {
        this.fAlgorithmFactory = AlgorithmFactory.getInstance();
        this.fHWKeyCache = HWKeyCache.getInstance();
    }

    public Provider getHWAccelerationProvider() {
        return this.hwAccelerationProvider;
    }

    public Provider getHWKeyStoreProvider() {
        return this.hwKeyStoreProvider;
    }

    public void setEncAlgorithm(String string) {
        this.encAlgorithm = string;
    }

    public void setHWKeyStoreName(String string) {
        this._hwKeyStoreName = string;
    }

    public String getHWKeyStoreName() {
        return this._hwKeyStoreName;
    }

    public void setHWConfigName(String string) {
        this._hwConfigName = string;
    }

    public String getHWConfigName() {
        return this._hwConfigName;
    }

    public void setOffload(Boolean bl) {
        this._offload = bl;
    }

    public boolean shouldChangeProvider() {
        return this._hwConfigName != null && this._hwConfigName.length() > 0 && HWKeyCache.isHWEncAlgorithm(this.encAlgorithm) && this._offload != false;
    }

    public boolean useHWKeyStore() {
        return this._hwKeyStoreName != null && this._hwKeyStoreName.length() > 0;
    }

    public void setHWAccelerationProvider(Provider provider, Integer n) {
        if (this.shouldChangeProvider()) {
            this.hwAccelerationProvider = provider;
            this.fHWKeyCache.setProvider(provider, n);
        }
    }

    public void setHWKeyStoreProvider(Provider provider) {
        this.hwKeyStoreProvider = provider;
    }

    public boolean isHWAccelerationProvider() {
        return this.hwAccelerationProvider != null;
    }

    public boolean isHWKeyStoreProvider() {
        return this.hwKeyStoreProvider != null;
    }

    public void setCryptoOffloadProperty(String string) {
        this.allCryptoOffload = string;
    }

    public String getCryptoOffladProperty() {
        return this.allCryptoOffload;
    }

    public void clearLocalProviderMap() {
        this.fAlgorithmFactory.clearLocalProviderMap();
    }

    public void setEncryptedType(InputStream inputStream, String string, OMElement oMElement, OMElement oMElement2) throws IOException, XMLStreamException {
        OMElement oMElement3 = null;
        if (inputStream != null) {
            StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(inputStream);
            oMElement3 = stAXOMBuilder.getDocumentElement();
        }
        this.setEncryptedType(oMElement3, string, oMElement, oMElement2);
    }

    public void setEncryptedType(OMElement oMElement, String string, OMElement oMElement2, OMElement oMElement3) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(oMElement, string, oMElement2, oMElement3);
    }

    void setEncryptedType(EncryptedType encryptedType, String string, EncryptionMethod encryptionMethod, KeyInfo keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encryptedType, string, encryptionMethod, keyInfo);
    }

    public void setEncryptionMethod(OMElement oMElement) {
        EncryptionMethod encryptionMethod = null;
        if (oMElement != null) {
            encryptionMethod = new EncryptionMethod(oMElement);
        }
        this.setEncryptionMethod(encryptionMethod);
    }

    void setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.fEncryptionMethod = encryptionMethod;
    }

    public void updateHWCache() throws Exception {
        this.fKey = this.fHWKeyCache.translate(this.fKey);
    }

    public void setHWKey(Key key) throws Exception {
        this.fKey = this.fHWKeyCache.translate(key);
    }

    public void setKey(Key key) {
        this.fKey = key;
    }

    public void setAlgorithmFactory(AlgorithmFactory algorithmFactory) {
        if (algorithmFactory == null) {
            throw new NullPointerException("AlgorithmFacotry is null.");
        }
        this.fAlgorithmFactory = algorithmFactory;
    }

    public void setKeyInfoResolver(KeyInfoResolver keyInfoResolver) {
        this.fKeyInfoResolver = keyInfoResolver;
    }

    public void setIdResolver(IDResolver iDResolver) {
        this.fIdResolver = iDResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fEntityResolver = entityResolver;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever encryptedKeyRetriever) {
        this.fEncryptedKeyRetriever = encryptedKeyRetriever;
    }

    public Object getData() {
        return this.fData;
    }

    public Iterator getDataAsNodeList() throws IOException, StructureException, XMLStreamException {
        if (this.fData != null) {
            if (this.fType == null) {
                throw new StructureException("Type attribute not specified");
            }
            if (this.fType.equals("http://www.w3.org/2001/04/xmlenc#Element") || this.fType.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                if (this.fData instanceof InputStream) {
                    OMElement oMElement = this.fEncryptedTypeContainer.getET().getBase();
                    byte[] byArray = Util.getBytes((InputStream)this.fData);
                    if (EncryptedHeader.isOfType(oMElement)) {
                        OMElement oMElement2 = oMElement.getFirstElement();
                        this.fData = DOMUtil.getChildNodes(this.parseData(byArray, oMElement2, true));
                        this.fData = this.replaceOMElementWithSOAPHeaderBlock((Iterator)this.fData, oMElement);
                    } else {
                        this.fData = DOMUtil.getChildNodes(this.parseData(byArray, oMElement, true));
                        if (oMElement instanceof SOAPHeaderBlock) {
                            this.fData = this.replaceOMElementWithSOAPHeaderBlock((Iterator)this.fData, oMElement);
                        }
                    }
                } else if (!(this.fData instanceof Iterator)) {
                    throw new RuntimeException("Instance of unknown class: " + this.fData.getClass().getName());
                }
            } else {
                throw new StructureException("Unknown type: " + this.fType);
            }
        }
        return (Iterator)this.fData;
    }

    private Iterator replaceOMElementWithSOAPHeaderBlock(Iterator iterator, OMElement oMElement) throws StructureException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        SOAPFactory sOAPFactory = null;
        OMFactory oMFactory = oMElement.getOMFactory();
        if (oMFactory instanceof SOAPFactory) {
            sOAPFactory = (SOAPFactory)oMFactory;
        } else {
            object = ((OMElement)oMElement.getParent()).getNamespace().getNamespaceURI();
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(object)) {
                sOAPFactory = OMAbstractFactory.getSOAP11Factory();
            } else if ("http://www.w3.org/2003/05/soap-envelope".equals(object)) {
                sOAPFactory = OMAbstractFactory.getSOAP12Factory();
            }
        }
        if (sOAPFactory == null) {
            throw new StructureException("No SOAPFactory.");
        }
        while (iterator.hasNext()) {
            object = (OMNode)iterator.next();
            if (object instanceof OMElement) {
                OMElement oMElement2 = (OMElement)object;
                SOAPHeaderBlock sOAPHeaderBlock = sOAPFactory.createSOAPHeaderBlock(oMElement2.getLocalName(), oMElement2.getNamespace());
                Iterator iterator2 = oMElement2.getAllDeclaredNamespaces();
                while (iterator2.hasNext()) {
                    sOAPHeaderBlock.declareNamespace((OMNamespace)iterator2.next());
                }
                Iterator iterator3 = oMElement2.getAllAttributes();
                while (iterator3.hasNext()) {
                    sOAPHeaderBlock.addAttribute((OMAttribute)iterator3.next());
                }
                Iterator iterator4 = oMElement2.getChildren();
                while (iterator4.hasNext()) {
                    OMNode oMNode = (OMNode)iterator4.next();
                    sOAPHeaderBlock.addChild(oMNode);
                }
                arrayList.add(sOAPHeaderBlock);
                continue;
            }
            arrayList.add(object);
        }
        return arrayList.iterator();
    }

    public String getType() {
        return this.fType;
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public Key getKey() {
        return this.fKey;
    }

    public void decrypt() throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither encrypted data nor key specified");
        }
        EncryptedType encryptedType = this.fEncryptedTypeContainer.getET();
        if (encryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        if (encryptedType instanceof EncryptedData || encryptedType instanceof EncryptedHeader) {
            if (this.debug) {
                System.out.println("HWC: decrypt, data");
            }
            EncryptionEngine encryptionEngine = this.getEncryptionEngine(2);
            InputStream inputStream = this.getInputStream();
            this.fData = new EncryptionInputStream(inputStream, encryptionEngine, this.fAlgorithmFactory);
            if (this.debug) {
                System.out.println("HWC: decrypt data, after EncryptionInputStream");
            }
            if (this.shower != null) {
                this.fData = this.getResourceInputStream((InputStream)this.fData);
            }
        } else if (encryptedType instanceof EncryptedKey) {
            if (this.debug) {
                System.out.println("HWC: decrypt, key");
            }
            EncryptionEngine encryptionEngine = this.getEncryptionEngine(4);
            byte[] byArray = Util.getBytes(this.getInputStream());
            if (this.fEncryptionMethod == null) {
                throw new NullPointerException("EncryptionMethod element not specified");
            }
            String string = this.fEncryptionMethod.getAlgorithm();
            if (string == null) {
                throw new StructureException("Algorithm attribute not specified");
            }
            String string2 = this.fEncryptedTypeContainer.getType();
            try {
                this.fData = encryptionEngine.unwrap(byArray, string, string2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (this.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    string2 = this.fEncryptedTypeContainer.getType();
                    this.fData = encryptionEngine.unwrap(byArray, string, string2);
                }
                throw outOfMemoryError;
            }
            this.fAlgorithmFactory.releaseEncryptionEngine(encryptionEngine);
            if (this.debug) {
                System.out.println("HWC: decrypt, key unwrap is done");
            }
            if (this.shower != null) {
                this.showResource((Key)this.fData);
            }
        }
        this.fType = this.fEncryptedTypeContainer.getType();
        this.fMimeType = encryptedType.getMimeType();
        this.fEncoding = encryptedType.getEncoding();
    }

    private EncryptionEngine getEncryptionEngine(int n) throws InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        EncryptionMethod encryptionMethod = this.fEncryptedTypeContainer.getEM();
        if (encryptionMethod == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        String string = encryptionMethod.getAlgorithm();
        if (string == null) {
            throw new StructureException("Algorithm attribute not specified");
        }
        Key key = this._getKey();
        if (key == null) {
            throw new NullPointerException("Key not specified or obtained");
        }
        if (this.isHWAccelerationProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else if (!(string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
        }
        if (this.isHWKeyStoreProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else if (!(string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
        }
        EncryptionEngine encryptionEngine = this.fAlgorithmFactory.getEncryptionEngine(string);
        AlgorithmParameterSpec algorithmParameterSpec = encryptionMethod.getParameterSpec(this.fAlgorithmFactory);
        encryptionEngine.init(n, key, algorithmParameterSpec);
        return encryptionEngine;
    }

    public Key _getKey() throws KeyInfoResolvingException {
        Object object;
        if (this.fKey == null && (object = this.fEncryptedTypeContainer.getKI()) != null && this.fKeyInfoResolver != null) {
            this.fKey = this.fKeyInfoResolver.resolve((KeyInfo)object, this.fEncryptedTypeContainer.getEM());
        }
        if (this.fKey == null && (object = this.fEncryptedTypeContainer.getET().getId()) != null && this.fEncryptedKeyRetriever != null && this.fKeyInfoResolver != null) {
            KeyInfo keyInfo = new KeyInfo();
            Iterator iterator = this.fEncryptedKeyRetriever.retrieve((String)object).iterator();
            while (iterator.hasNext()) {
                keyInfo.addEncryptedKey((EncryptedKey)iterator.next());
            }
            this.fKey = this.fKeyInfoResolver.resolve(keyInfo, this.fEncryptedTypeContainer.getEM());
        }
        return this.fKey;
    }

    private InputStream getInputStream() throws StructureException, XSignatureException {
        CipherData cipherData = this.fEncryptedTypeContainer.getET().getCipherData();
        if (cipherData == null) {
            throw new StructureException("CipherData element not specified");
        }
        Type type = cipherData.getCipherData();
        byte[] byArray = null;
        if (type == null) {
            throw new StructureException("Neither CipherValue nor CipherReference element specified");
        }
        if (type instanceof CipherValue) {
            byArray = ((CipherValue)type).getValue();
            if (byArray == null) {
                throw new StructureException("Cipher value not specified");
            }
        } else if (type instanceof CipherReference) {
            Object object;
            CipherReference cipherReference = (CipherReference)type;
            String string = cipherReference.getURI();
            if (string == null) {
                throw new StructureException("URI attribute not specified");
            }
            OMElement oMElement = cipherReference.getBase();
            Transforms transforms = cipherReference.getTransforms();
            if (transforms != null) {
                object = new DsTransforms();
                Object object2 = transforms.getTransforms().iterator();
                while (object2.hasNext()) {
                    ((TransformsType)object).addTransform((Transform)object2.next());
                }
                object2 = ((DsTransforms)object).createElement(oMElement.getOMFactory(), true);
                oMElement = oMElement.cloneOMElement();
                oMElement.addChild((OMNode)object2);
            }
            object = new SignatureContext();
            ((SignatureContext)object).setAlgorithmFactory(this.fAlgorithmFactory);
            ((SignatureContext)object).setIDResolver(this.fIdResolver);
            ((SignatureContext)object).setEntityResolver(this.fEntityResolver);
            byArray = (byte[])((SignatureContext)object).retrieve(oMElement);
        }
        return new ByteArrayInputStream(byArray);
    }

    public void replace() throws IOException, StructureException, XMLStreamException {
        Iterator iterator = this.getDataAsNodeList();
        if (iterator == null) {
            throw new NullPointerException("Data not obtained");
        }
        this.fData = DOMUtil.replaceNode((OMNode)this.fEncryptedTypeContainer.getET().getBase(), iterator);
    }

    private static void serializeNamespaceDecls(OMNode oMNode, XMLWriter xMLWriter) throws IOException {
        Map map = DOMUtil.getNamespaceDeclAttrNodes(oMNode);
        if (map == null || map.size() <= 0) {
            return;
        }
        for (OMNamespace oMNamespace : map.values()) {
            if (oMNamespace.getPrefix() == null || oMNamespace.getPrefix().length() == 0) {
                xMLWriter.printText(" xmlns=\"");
            } else {
                if (oMNamespace.getPrefix().equals("xml")) continue;
                xMLWriter.printText(" xmlns:");
                xMLWriter.printText(oMNamespace.getPrefix());
                xMLWriter.printText("=\"");
            }
            String string = oMNamespace.getName();
            if (string == null) {
                string = "";
            }
            xMLWriter.printEscaped(string);
            xMLWriter.printText('\"');
        }
    }

    public static byte[] wrapData(byte[] byArray, OMNode oMNode) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XMLWriter xMLWriter = new XMLWriter(byteArrayOutputStream);
            xMLWriter.printText("<dummy");
            DecryptionContext.serializeNamespaceDecls(oMNode, xMLWriter);
            xMLWriter.printText('>');
            xMLWriter.flush();
            if (byArray != null) {
                byteArrayOutputStream.write(byArray);
            }
            xMLWriter.printText("</dummy>");
            xMLWriter.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    private OMElement parseData(byte[] byArray, OMNode oMNode, boolean bl) throws IOException, XMLStreamException {
        FastBAOutputStream fastBAOutputStream = byArray != null ? new FastBAOutputStream(byArray.length * 2 + 1) : new FastBAOutputStream();
        XMLWriter xMLWriter = new XMLWriter(fastBAOutputStream);
        xMLWriter.printText("<dummy");
        DecryptionContext.serializeNamespaceDecls(oMNode, xMLWriter);
        xMLWriter.printText('>');
        xMLWriter.flush();
        if (byArray != null) {
            fastBAOutputStream.write(byArray);
        }
        xMLWriter.printText("</dummy>");
        xMLWriter.flush();
        fastBAOutputStream.close();
        InputStream inputStream = fastBAOutputStream.createInputStream();
        if (oMNode != null) {
            AdoptingDOMBuilder adoptingDOMBuilder = new AdoptingDOMBuilder();
            return adoptingDOMBuilder.parseElement(inputStream, bl);
        }
        return null;
    }

    public void setResourceShower(ResourceShower resourceShower) {
        this.shower = resourceShower;
    }

    private ResourceInputStream getResourceInputStream(InputStream inputStream) {
        return new ResourceInputStream(inputStream, this.shower, this.fData, this.fEncryptedTypeContainer.getEncryptedType());
    }

    private void showResource(Key key) {
        this.shower.showEncryptedResource(key.getEncoded(), this.fData, this.fEncryptedTypeContainer.getEncryptedType());
    }

    public Map getContext() {
        return this.fContext;
    }

    public void setContext(Map map) {
        this.fContext = map;
    }
}

