/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.BufferedWriter;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.Serializer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public abstract class DOMSerializationEngine {
    public abstract String getType();

    public abstract void setOutputStream(OutputStream var1);

    public abstract void serialize(Iterator var1) throws IOException;

    private static Throwable unwrapException(TransformerException transformerException) {
        Throwable throwable = transformerException.getException();
        if (throwable == null) {
            throwable = transformerException;
        }
        return throwable;
    }

    public static class XMLElement
    extends XMLContent {
        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Element";
        }

        public void serialize(ArrayList arrayList) throws IOException {
            if (arrayList != null) {
                OMElement oMElement = DOMUtil.getFirstElement(arrayList);
                ArrayList<OMElement> arrayList2 = new ArrayList<OMElement>();
                if (oMElement != null) {
                    arrayList2.add(oMElement);
                }
                arrayList = arrayList2;
            }
            super.serialize(arrayList.iterator());
        }
    }

    public static class XMLContent
    extends DOMSerializationEngine {
        private Writer fOut;

        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Content";
        }

        public void setOutputStream(OutputStream outputStream) {
            try {
                this.fOut = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Internal Error: " + unsupportedEncodingException.toString());
            }
        }

        public void serialize(Iterator iterator) throws IOException {
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Serializer.serialize((OMNode)iterator.next(), this.fOut);
                }
                this.fOut.flush();
            }
        }
    }
}

