/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.util;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.pkcs11.PKCS11Object;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;

public class HWKeyCache {
    private static final boolean DEBUG = false;
    private static HWKeyCache s_theInstance;
    private static Provider _provider;
    private static HashMap fKey2TKey;
    private static HashMap fTKey2TTime;
    private static LinkedList fKey;
    private static Hashtable fAlg2Factory;
    private static int maxKeysOnCard;
    private static long entryRefresh;
    private static byte[] lock;
    private static boolean cacheSizeSet;

    private HWKeyCache() {
        fAlg2Factory = new Hashtable();
        fKey2TKey = new HashMap();
        fTKey2TTime = new HashMap();
        fKey = new LinkedList();
    }

    public void setScanParameters(long l) {
        entryRefresh = l * 3600000L;
        if (entryRefresh > 300000L) {
            entryRefresh -= 300000L;
        }
    }

    public static boolean isHWSigAlgorithm(String string) {
        boolean bl = false;
        if (string != null && (string.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || string.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1"))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isHWEncAlgorithm(String string) {
        boolean bl = false;
        if (string != null && (string.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || string.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"))) {
            bl = true;
        }
        return bl;
    }

    public static HWKeyCache getInstance() {
        return s_theInstance;
    }

    public void setProvider(Provider provider, Integer n) {
        if (_provider == null && provider != null) {
            _provider = provider;
            maxKeysOnCard = n;
            try {
                fAlg2Factory.put("RSA", KeyFactory.getInstance("RSA", provider));
                fAlg2Factory.put("DSA", KeyFactory.getInstance("DSA", provider));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    public static boolean cacheInitialized() {
        return _provider != null && maxKeysOnCard > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key generate(String string) throws Exception {
        Key key = null;
        Long l = null;
        if (string == null) return key;
        byte[] byArray = lock;
        synchronized (lock) {
            key = (Key)fKey2TKey.get(string);
            if (key != null && entryRefresh > 0L && ((l = (Long)fTKey2TTime.get(key)) == null || System.currentTimeMillis() - l > entryRefresh)) {
                HWKeyCache.remove(string);
                return null;
            }
            if (key == null) return key;
            fKey.remove(string);
            fKey.addFirst(string);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return key;
        }
    }

    public void addGeneratedKey(String string, Key key) {
        if (string != null && key != null) {
            fKey2TKey.put(string, key);
            fKey.addFirst(string);
            fTKey2TTime.put(key, new Long(System.currentTimeMillis()));
        }
    }

    public void addGeneratedKey(byte[] byArray, Key key) {
        if (byArray != null && key != null) {
            fKey2TKey.put(byArray, key);
            fKey.addFirst(byArray);
            fTKey2TTime.put(key, new Long(System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key generate(byte[] byArray) throws Exception {
        Key key = null;
        Long l = null;
        if (byArray == null) return key;
        byte[] byArray2 = lock;
        synchronized (lock) {
            key = (Key)fKey2TKey.get(byArray);
            if (key != null && entryRefresh > 0L && ((l = (Long)fTKey2TTime.get(key)) == null || System.currentTimeMillis() - l > entryRefresh)) {
                HWKeyCache.remove(byArray);
                return null;
            }
            if (key == null) return key;
            fKey.remove(byArray);
            fKey.addFirst(byArray);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Key translate(Key key) throws Exception {
        Key key2 = null;
        Long l = null;
        if (!HWKeyCache.cacheInitialized()) {
            return key2;
        }
        if (key == null) {
            return key2;
        }
        byte[] byArray = lock;
        synchronized (lock) {
            key2 = (Key)fKey2TKey.get(key);
            if (key2 != null && entryRefresh > 0L && ((l = (Long)fTKey2TTime.get(key2)) == null || System.currentTimeMillis() - l > entryRefresh)) {
                HWKeyCache.remove(key);
                key2 = null;
            }
            if (key2 != null) {
                fKey.remove(key);
                fKey.addFirst(key);
            } else {
                KeyFactory keyFactory = null;
                Throwable throwable = null;
                try {
                    if (fKey.size() >= maxKeysOnCard) {
                        HWKeyCache.reduceKeysOnCardPercent(75);
                    }
                    try {
                        keyFactory = (KeyFactory)fAlg2Factory.get(key.getAlgorithm());
                        if (keyFactory == null) {
                            String string = key.getAlgorithm();
                            keyFactory = KeyFactory.getInstance(string, _provider);
                            fAlg2Factory.put(string, keyFactory);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        key2 = keyFactory.translateKey(key);
                        if (key2 == null) {
                            // empty if block
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        if (!cacheSizeSet) {
                            HWKeyCache.setMaxKeysOnCardPercent(80);
                            HWKeyCache.reduceKeysOnCardPercent(75);
                        } else {
                            throwable = outOfMemoryError;
                        }
                    }
                    catch (Exception exception) {
                        throwable = exception;
                    }
                    if (key2 == null && throwable == null) {
                        try {
                            key2 = keyFactory.translateKey(key);
                            if (key2 == null) {
                                // empty if block
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throwable = outOfMemoryError;
                        }
                        catch (Exception exception) {
                            throwable = exception;
                        }
                    }
                    if (key2 == null) {
                        if (throwable == null) throw new Exception("Unable to translate key");
                        throw new Exception("Unable to translate key", throwable);
                    }
                    fKey2TKey.put(key, key2);
                    fKey.addFirst(key);
                    fTKey2TTime.put(key2, new Long(System.currentTimeMillis()));
                }
                catch (Exception exception) {
                    key2 = null;
                    throw exception;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return key2;
        }
    }

    private static boolean remove(Key key) {
        boolean bl = false;
        fKey.remove(key);
        PKCS11Key pKCS11Key = (PKCS11Key)fKey2TKey.remove(key);
        fTKey2TTime.remove(pKCS11Key);
        if (pKCS11Key != null) {
            try {
                PKCS11Object pKCS11Object = pKCS11Key.getObject();
                if (pKCS11Object != null) {
                    pKCS11Object.destroy();
                }
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private static void remove(String string) {
        fKey.remove(string);
        fTKey2TTime.remove(string);
    }

    private static void remove(byte[] byArray) {
        fKey.remove(byArray);
        fTKey2TTime.remove(byArray);
    }

    private static boolean removeLast() {
        boolean bl = false;
        Key key = (Key)fKey.getLast();
        bl = HWKeyCache.remove(key);
        return bl;
    }

    private static boolean removeLast(int n) {
        boolean bl = false;
        if (n > fKey.size()) {
            n = fKey.size();
        } else {
            for (int i = 0; i < n && (bl = HWKeyCache.removeLast()); ++i) {
            }
        }
        return bl;
    }

    private static boolean reduceKeysOnCardPercent(int n) {
        int n2 = fKey.size() - maxKeysOnCard * n / 100;
        boolean bl = HWKeyCache.removeLast(n2);
        return bl;
    }

    private static int setMaxKeysOnCardPercent(int n) {
        maxKeysOnCard = fKey.size() * n / 100;
        cacheSizeSet = true;
        return maxKeysOnCard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeAllEntries() {
        if (!HWKeyCache.cacheInitialized()) return;
        byte[] byArray = lock;
        synchronized (lock) {
            HWKeyCache.reduceKeysOnCardPercent(0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setCapacityReached() {
        if (!HWKeyCache.cacheInitialized() || cacheSizeSet) return;
        byte[] byArray = lock;
        synchronized (lock) {
            HWKeyCache.setMaxKeysOnCardPercent(80);
            HWKeyCache.reduceKeysOnCardPercent(75);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        _provider = null;
        fKey2TKey = null;
        fTKey2TTime = null;
        fKey = null;
        fAlg2Factory = null;
        maxKeysOnCard = 0;
        entryRefresh = 0L;
        lock = new byte[0];
        cacheSizeSet = false;
        s_theInstance = new HWKeyCache();
    }
}

