/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMAttributeWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.XPathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenException;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;
import org.jaxen.XPathFunctionContext;

public class XPathTransformer
extends Transform
implements ErrorListener {
    private static final boolean DEBUG = false;
    private static final String clsName = XPathTransformer.class.getName();
    OMElement xpathExpression;

    public void setParameter(OMNode oMNode) {
        if (oMNode.getType() != 1) {
            throw new IllegalArgumentException("The parameter must be ELEMENT_NODE.");
        }
        this.xpathExpression = (OMElement)oMNode;
    }

    public String getURI() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    public void transform(TransformContext transformContext) throws TransformException {
        try {
            ArrayList arrayList = transformContext.getNodeset();
            OMNode oMNode = this.xpathExpression.getFirstOMChild();
            if (oMNode == null) {
                oMNode = this.xpathExpression;
            }
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            XPath xPath = XPathTransformer.createXPath(this.xpathExpression, transformContext);
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                Object object = null;
                if (e instanceof OMNode) {
                    object = xPath.evaluate(e);
                } else if (e instanceof OMNamespaceWithOwner) {
                    object = xPath.evaluate(((OMNamespaceWithOwner)e).getOwnerElement());
                } else if (e instanceof OMAttributeWithOwner) {
                    object = xPath.evaluate(((OMAttributeWithOwner)e).getOwnerElement());
                }
                if (object == null || !(object instanceof Boolean) || !Boolean.TRUE.equals(object)) continue;
                arrayList2.add(e);
            }
            transformContext.setContent(arrayList2);
        }
        catch (JaxenException jaxenException) {
            if (transformContext.isDebug()) {
                jaxenException.printStackTrace();
            }
            throw new TransformException("Error occured in an XPath transform: " + jaxenException.getMessage());
        }
        catch (TransformerException transformerException) {
            if (transformContext.isDebug()) {
                transformerException.printStackTrace();
            }
            throw new TransformException("Error occured in an XPath transform: " + transformerException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            if (transformContext.isDebug()) {
                runtimeException.printStackTrace();
            }
            throw new TransformException("Error occured in an XPath transform: " + runtimeException.getMessage());
        }
    }

    private static void dumpNode(OMNode oMNode) {
    }

    public void error(TransformerException transformerException) {
        transformerException.printStackTrace();
    }

    public void fatalError(TransformerException transformerException) {
        transformerException.printStackTrace();
    }

    public void warning(TransformerException transformerException) {
        transformerException.printStackTrace();
    }

    public OMElement createTransformElement(OMDocument oMDocument, IndentConfig indentConfig) {
        OMElement oMElement = this.xpathExpression;
        OMElement oMElement2 = super.createTransformElement(oMDocument.getOMDocumentElement().getOMFactory(), indentConfig);
        DOMUtil.addIndent(oMElement2, indentConfig, 5);
        oMElement2.addChild(oMElement);
        DOMUtil.addIndent(oMElement2, indentConfig, 4);
        return oMElement2;
    }

    static XPath createXPath(OMNode oMNode, TransformContext transformContext) throws TransformerException {
        XPathUtil.AXIOMXPathWithIR aXIOMXPathWithIR = null;
        try {
            XPathUtil.DocumentNavigatorWithIR documentNavigatorWithIR = new XPathUtil.DocumentNavigatorWithIR(transformContext.getIDResolver());
            aXIOMXPathWithIR = new XPathUtil.AXIOMXPathWithIR(DOMUtil.getStringValue(oMNode), documentNavigatorWithIR);
            SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
            simpleNamespaceContext.addElementNamespaces(documentNavigatorWithIR, oMNode);
            aXIOMXPathWithIR.setNamespaceContext(simpleNamespaceContext);
            XPathFunctionContext xPathFunctionContext = new XPathFunctionContext(false);
            xPathFunctionContext.registerFunction(null, "here", new FuncHere(oMNode));
            aXIOMXPathWithIR.setFunctionContext(xPathFunctionContext);
        }
        catch (UnsupportedAxisException unsupportedAxisException) {
            throw new TransformerException(unsupportedAxisException.getClass().getName() + ": " + unsupportedAxisException.getMessage());
        }
        catch (JaxenException jaxenException) {
            throw new TransformerException(jaxenException.getClass().getName() + ": " + jaxenException.getMessage());
        }
        return aXIOMXPathWithIR;
    }

    public static class FuncHere
    implements Function {
        OMNode here;

        public FuncHere(OMNode oMNode) {
            this.here = oMNode;
        }

        public Object call(Context context, List list) throws FunctionCallException {
            try {
                return this.here;
            }
            catch (Exception exception) {
                throw new FunctionCallException("here(): " + exception.getMessage());
            }
        }
    }
}

