/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.Enveloped;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XPathTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.jaxen.JaxenException;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;

public class XPath2Transformer
extends Transform {
    private static final int FILTER_INVALID = -1;
    private static final int FILTER_UNION = 1;
    private static final int FILTER_SUBTRACT = 2;
    private static final int FILTER_INTERSECT = 3;
    private List xpathNodes;

    public String getURI() {
        return "http://www.w3.org/2002/06/xmldsig-filter2";
    }

    public void setParameter(OMNode oMNode) {
        Vector<OMNode> vector = new Vector<OMNode>();
        while (oMNode != null) {
            vector.addElement(oMNode);
            oMNode = DOMUtil.getNextElement(oMNode);
        }
        this.xpathNodes = vector;
    }

    public void transform(TransformContext transformContext) throws TransformException {
        ArrayList arrayList = transformContext.getNodeset();
        int n = arrayList.size();
        if (n <= 0) {
            return;
        }
        Object e = arrayList.get(0);
        OMDocument oMDocument = DOMUtil.getOwnerDocument((OMNode)e);
        int n2 = this.xpathNodes.size();
        List[] listArray = new List[n2 + 1];
        int[] nArray = new int[n2 + 1];
        listArray[0] = Collections.singletonList(oMDocument.getOMDocumentElement());
        nArray[0] = 1;
        Iterator iterator = this.xpathNodes.iterator();
        int n3 = 1;
        while (iterator.hasNext()) {
            OMNode oMNode = (OMNode)iterator.next();
            listArray[n3] = XPath2Transformer.eval(oMNode, oMDocument, transformContext);
            nArray[n3] = XPath2Transformer.getFilter(oMNode);
            if (nArray[n3] == -1) {
                throw new TransformException("XPath element has no valid Filter attribute.");
            }
            ++n3;
        }
        ArrayList arrayList2 = new ArrayList();
        block1: for (int i = 0; i < n; ++i) {
            e = arrayList.get(i);
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != 1 || !XPath2Transformer.contain(listArray[j], e)) continue;
                boolean bl = true;
                for (int k = j + 1; k < nArray.length; ++k) {
                    if (nArray[k] == 1) continue;
                    if (nArray[k] == 3) {
                        if (XPath2Transformer.contain(listArray[k], e)) continue;
                        bl = false;
                        break;
                    }
                    if (nArray[k] != 2 || !XPath2Transformer.contain(listArray[k], e)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                arrayList2.add(e);
                continue block1;
            }
        }
        transformContext.setContent(arrayList2);
    }

    private static int getFilter(OMNode oMNode) {
        String string = ((OMElement)oMNode).getAttributeValue(new QName("", "Filter"));
        if ("union".equals(string)) {
            return 1;
        }
        if ("subtract".equals(string)) {
            return 2;
        }
        if ("intersect".equals(string)) {
            return 3;
        }
        return -1;
    }

    private static boolean contain(List list, Object object) {
        for (OMNode oMNode : list) {
            if (oMNode != object && !Enveloped.isAncestorOrSelf(object, oMNode)) continue;
            return true;
        }
        return false;
    }

    private static List eval(OMNode oMNode, OMDocument oMDocument, TransformContext transformContext) throws TransformException {
        Object object;
        try {
            XPath xPath = XPathTransformer.createXPath(oMNode, transformContext);
            object = xPath.evaluate(oMDocument.getOMDocumentElement());
            if (!(object instanceof List)) {
                throw new TransformException("The result of xpath evaluation for '" + DOMUtil.getStringValue(oMNode) + "' is not a nodeset: " + object.toString());
            }
        }
        catch (TransformerException transformerException) {
            throw new TransformException("Error occured in an XPath evaluation: " + transformerException.getMessage());
        }
        catch (UnsupportedAxisException unsupportedAxisException) {
            throw new TransformException("Error occured in an XPath evaluation: " + unsupportedAxisException.getMessage());
        }
        catch (JaxenException jaxenException) {
            throw new TransformException("Error occured in an XPath evaluation: " + jaxenException.getMessage());
        }
        return (List)object;
    }

    public OMElement createTransformElement(OMFactory oMFactory, IndentConfig indentConfig) {
        throw new RuntimeException("Not supported.");
    }
}

