/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.Canonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.DecryptionTransformer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class XMLDecryptionTransformer2
extends DecryptionTransformer {
    private static final boolean DEBUG = false;

    private ArrayList decryptXML(ArrayList arrayList, TransformContext transformContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        Map map = this.decryptNodeSet(arrayList, transformContext);
        byte[] byArray = Canonicalizer.serializeSubset(arrayList, false, map);
        OMDocument oMDocument = this.parseOctets(byArray, transformContext);
        return XPathCanonicalizer.toNodeset(oMDocument.getOMDocumentElement(), null, true);
    }

    private Map decryptNodeSet(ArrayList arrayList, TransformContext transformContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        HashMap hashMap = new HashMap();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof OMElement) || !this.isEncryptedData((OMElement)e)) continue;
            ArrayList arrayList2 = this.decryptEncryptedData((OMElement)e, transformContext);
            hashMap.put(e, arrayList2);
            Map map = this.decryptNodeSet(arrayList2, transformContext);
            hashMap.putAll(map);
        }
        return hashMap;
    }

    private ArrayList decryptEncryptedData(OMElement oMElement, TransformContext transformContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        byte[] byArray = this.decryptEncryptedData(transformContext.getSignatureContext(), oMElement);
        byArray = DecryptionContext.wrapData(byArray, oMElement);
        OMDocument oMDocument = this.parseOctets(byArray, transformContext);
        OMElement oMElement2 = oMDocument.getOMDocumentElement();
        return this.convertToNodeSet(oMElement2);
    }

    private byte[] decryptEncryptedData(SignatureContext signatureContext, OMElement oMElement) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        DecryptionContext decryptionContext = this.createDecryptionContext(signatureContext);
        decryptionContext.setEncryptedType(oMElement, null, null, null);
        decryptionContext.decrypt();
        String string = decryptionContext.getType();
        if (string == null) {
            throw new StructureException("Type attribute not specified");
        }
        if (!string.equals("http://www.w3.org/2001/04/xmlenc#Element") && !string.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            throw new StructureException("Unknown type: " + string);
        }
        return Util.getBytes((InputStream)decryptionContext.getData());
    }

    private OMDocument parseOctets(byte[] byArray, TransformContext transformContext) throws TransformException {
        transformContext.setContent(byArray, "UTF-8");
        return transformContext.getDocument();
    }

    private ArrayList convertToNodeSet(OMElement oMElement) {
        ArrayList arrayList = new ArrayList();
        for (OMNode oMNode = oMElement.getFirstOMChild(); oMNode != null; oMNode = oMNode.getNextOMSibling()) {
            ArrayList arrayList2 = XPathCanonicalizer.toNodeset(oMNode, null, true);
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(arrayList2.get(i));
            }
        }
        return arrayList;
    }

    public String getURI() {
        return "http://www.w3.org/2002/07/decrypt#XML";
    }

    public void transform(TransformContext transformContext) throws TransformException {
        ArrayList arrayList = null;
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                arrayList = XPathCanonicalizer.toNodeset(transformContext.getDocument().getOMDocumentElement(), null, true);
                break;
            }
            case 3: {
                arrayList = XPathCanonicalizer.toNodeset(transformContext.getNode(), null, true);
                break;
            }
            case 2: {
                arrayList = transformContext.getNodeset();
            }
        }
        if (arrayList != null) {
            try {
                arrayList = this.decryptXML(arrayList, transformContext);
            }
            catch (TransformException transformException) {
                throw transformException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Exception exception2;
                Exception exception3;
                if (exception instanceof XSignatureException && (exception3 = ((XSignatureException)exception).getException()) != null) {
                    exception2 = exception3;
                }
                throw new TransformException(exception2.getMessage());
            }
        }
        transformContext.setContent(arrayList);
    }
}

