/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.DecryptionTransformer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.xml.sax.SAXException;

public class XMLDecryptionTransformer
extends DecryptionTransformer {
    private static final boolean DEBUG = false;
    private boolean fReplace;
    private boolean fContinue;
    private Set fFailedEncryptedData = new HashSet();

    public void setReplaceEncryptedData(boolean bl) {
        this.fReplace = bl;
    }

    public void setContinueProcessing(boolean bl) {
        this.fContinue = bl;
    }

    private boolean containsEncryptedData(ArrayList arrayList) throws StructureException {
        return this.getIndexOfEncryptedData(arrayList) >= 0;
    }

    private ArrayList cloneNodeSet(ArrayList arrayList, TransformContext transformContext) throws TransformException {
        byte[] byArray = XPathCanonicalizer.serializeSubset(arrayList, true);
        byArray = DecryptionContext.wrapData(byArray, (OMNode)arrayList.get(0));
        OMElement oMElement = this.parseOctets(byArray, transformContext).getOMDocumentElement();
        return this.convertToNodeSet(oMElement);
    }

    private ArrayList decryptIncludedNodes(ArrayList arrayList, TransformContext transformContext) throws Exception {
        while (true) {
            if (!this.isSingleRooted(arrayList)) {
                throw new TransformException("Not single-rooted node-set");
            }
            int n = this.getIndexOfEncryptedData(arrayList);
            if (n < 0) break;
            try {
                arrayList = this.decrypt(arrayList, n, transformContext);
            }
            catch (Exception exception) {
                if (!this.fContinue) {
                    throw exception;
                }
                Exception exception2 = this.getInnerException(exception);
                this.fFailedEncryptedData.add(arrayList.get(n));
            }
        }
        return arrayList;
    }

    private boolean isSingleRooted(ArrayList arrayList) {
        boolean bl = true;
        if (arrayList.size() > 0) {
            Object e = arrayList.get(0);
            if (e instanceof OMNamespace) {
                return false;
            }
            if (e instanceof OMAttribute) {
                return false;
            }
            int n = arrayList.size();
            for (int i = 1; i < n; ++i) {
                Object e2 = arrayList.get(i);
                if (!(e2 instanceof OMNode) || DOMUtil.isDescendantNode((OMNode)e2, (OMNode)e)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private int getIndexOfEncryptedData(ArrayList arrayList) throws StructureException {
        int n = -1;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof OMNode) || !this.isEncryptedData((OMNode)e)) continue;
            n = i;
            break;
        }
        return n;
    }

    boolean isEncryptedData(OMNode oMNode) throws StructureException {
        return super.isEncryptedData(oMNode) && !this.fFailedEncryptedData.contains(oMNode);
    }

    private ArrayList decrypt(ArrayList arrayList, int n, TransformContext transformContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, TransformException, XSignatureException, XMLStreamException {
        int n2 = this.getIndexOfNextNode(arrayList, n);
        ArrayList arrayList2 = this.getSubNodeSet(arrayList, n, n2);
        arrayList2 = this.decryptEncryptedData(arrayList2, n == 0, transformContext);
        return this.replaceSubNodeSet(arrayList, n, n2, arrayList2);
    }

    private int getIndexOfNextNode(ArrayList arrayList, int n) {
        int n2;
        while (!(arrayList.get(n) instanceof OMNode)) {
            ++n;
        }
        OMNode oMNode = (OMNode)arrayList.get(n);
        int n3 = arrayList.size();
        for (n2 = n + 1; n2 < n3 && (!(arrayList.get(n2) instanceof OMNode) || DOMUtil.isDescendantNode((OMNode)arrayList.get(n2), oMNode)); ++n2) {
        }
        return n2;
    }

    private ArrayList getSubNodeSet(ArrayList arrayList, int n, int n2) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = n; i < n2; ++i) {
            arrayList2.add(arrayList.get(i));
        }
        return arrayList2;
    }

    private ArrayList decryptEncryptedData(ArrayList arrayList, boolean bl, TransformContext transformContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, TransformException, XSignatureException, XMLStreamException {
        byte[] byArray = XPathCanonicalizer.serializeSubset(arrayList, false);
        byArray = this.decryptEncryptedData(transformContext.getSignatureContext(), byArray, bl);
        byArray = DecryptionContext.wrapData(byArray, (OMNode)arrayList.get(0));
        OMElement oMElement = this.parseOctets(byArray, transformContext).getOMDocumentElement();
        oMElement = oMElement.cloneOMElement();
        return this.convertToNodeSet(oMElement);
    }

    private byte[] decryptEncryptedData(SignatureContext signatureContext, byte[] byArray, boolean bl) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, XSignatureException, XMLStreamException {
        DecryptionContext decryptionContext = this.createDecryptionContext(signatureContext);
        decryptionContext.setEncryptedType(new ByteArrayInputStream(byArray), null, null, null);
        decryptionContext.decrypt();
        String string = decryptionContext.getType();
        if (string == null) {
            throw new StructureException("Type attribute not specified");
        }
        if (!string.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            if (string.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                if (bl) {
                    throw new StructureException("Wrong type: " + string);
                }
            } else {
                throw new StructureException("Unknown type: " + string);
            }
        }
        return Util.getBytes((InputStream)decryptionContext.getData());
    }

    private OMDocument parseOctets(byte[] byArray, TransformContext transformContext) throws TransformException {
        transformContext.setContent(byArray, "UTF-8");
        return transformContext.getDocument();
    }

    private ArrayList convertToNodeSet(OMNode oMNode) {
        ArrayList arrayList = new ArrayList();
        for (OMNode oMNode2 = ((OMContainer)((Object)oMNode)).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
            ArrayList arrayList2 = XPathCanonicalizer.toNodeset(oMNode2, null, true);
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(arrayList2.get(i));
            }
        }
        return arrayList;
    }

    private ArrayList replaceSubNodeSet(ArrayList arrayList, int n, int n2, ArrayList arrayList2) {
        int n3;
        ArrayList arrayList3 = new ArrayList();
        for (n3 = 0; n3 < n; ++n3) {
            arrayList3.add(arrayList.get(n3));
        }
        int n4 = arrayList2.size();
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList3.add(arrayList2.get(n3));
        }
        n4 = arrayList.size();
        for (n3 = n2; n3 < n4; ++n3) {
            arrayList3.add(arrayList.get(n3));
        }
        OMNode oMNode = (OMNode)arrayList.get(n);
        OMContainer oMContainer = oMNode.getParent();
        if (oMContainer != null) {
            OMNode oMNode2 = (OMNode)arrayList2.get(0);
            OMNode oMNode3 = oMNode2.getNextOMSibling();
            oMNode.insertSiblingBefore(oMNode2);
            oMNode.detach();
            oMNode = oMNode2.getNextOMSibling();
            oMNode2 = oMNode3;
            while (oMNode2 != null) {
                oMNode3 = oMNode2.getNextOMSibling();
                if (oMNode == null) {
                    oMContainer.addChild(oMNode2);
                } else {
                    oMNode.insertSiblingBefore(oMNode2);
                }
                oMNode2 = oMNode3;
            }
        }
        return arrayList3;
    }

    private Exception getInnerException(Exception exception) {
        Exception exception2;
        if (exception instanceof SAXException) {
            Exception exception3 = ((SAXException)exception).getException();
            if (exception3 != null) {
                exception = exception3;
            }
        } else if (exception instanceof XSignatureException && (exception2 = ((XSignatureException)exception).getException()) != null) {
            exception = exception2;
        }
        return exception;
    }

    public String getURI() {
        return "http://www.w3.org/2001/04/decrypt#";
    }

    public void transform(TransformContext transformContext) throws TransformException {
        ArrayList arrayList = null;
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                arrayList = XPathCanonicalizer.toNodeset(transformContext.getDocument().getOMDocumentElement(), null, true);
                break;
            }
            case 3: {
                arrayList = XPathCanonicalizer.toNodeset(transformContext.getNode(), null, true);
                break;
            }
            case 2: {
                arrayList = transformContext.getNodeset();
            }
        }
        if (arrayList != null) {
            if (!this.isSingleRooted(arrayList)) {
                throw new TransformException("Not single-rooted node-set");
            }
            try {
                if (this.containsEncryptedData(arrayList)) {
                    if (!this.fReplace) {
                        arrayList = this.cloneNodeSet(arrayList, transformContext);
                    }
                    arrayList = this.decryptIncludedNodes(arrayList, transformContext);
                }
            }
            catch (TransformException transformException) {
                throw transformException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Exception exception2 = this.getInnerException(exception);
                throw new TransformException(exception2.getMessage());
            }
        }
        transformContext.setContent(arrayList);
    }
}

