/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Except;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public abstract class DecryptionTransformer
extends Transform {
    private static final boolean DEBUG = false;
    public static final String XML = "http://www.w3.org/2001/04/decrypt#";
    public static final String XML2 = "http://www.w3.org/2002/07/decrypt#XML";
    public static final String BINARY = "http://www.w3.org/2002/07/decrypt#Binary";
    public static final QName ID_Q = new QName("", "Id");
    private List fParameters = new ArrayList();
    private Set fExceptedIds;

    DecryptionTransformer() {
    }

    boolean isEncryptedData(OMNode oMNode) throws StructureException {
        OMElement oMElement;
        boolean bl = false;
        if (oMNode.getType() == 1 && EncryptedData.isOfType(oMElement = (OMElement)oMNode)) {
            if (this.fExceptedIds == null) {
                this.setExceptedIds();
            }
            bl = !this.fExceptedIds.contains(oMElement.getAttributeValue(ID_Q));
        }
        return bl;
    }

    private void setExceptedIds() throws StructureException {
        this.fExceptedIds = new HashSet();
        Iterator iterator = this.fParameters.iterator();
        while (iterator.hasNext()) {
            String string = ((Except)iterator.next()).getURI();
            if (string == null) {
                throw new StructureException("URI attribute not specified");
            }
            if (!(string = string.trim()).startsWith("#") || string.length() < 2) {
                throw new StructureException("Wrong URI: " + string);
            }
            string = string.substring(1);
            string = this.getId(string);
            this.fExceptedIds.add(string);
        }
    }

    private String getId(String string) {
        char c;
        String string2;
        String string3 = string;
        if (string.startsWith("xpointer(") && string.endsWith(")") && (string2 = string3.substring(9, string.length() - 1).trim()).startsWith("id(") && string2.endsWith(")") && (string2 = string2.substring(3, string3.length() - 1).trim()).length() > 2 && ((c = string2.charAt(0)) == '\"' || c == '\'') && c == string2.charAt(string2.length() - 1)) {
            string3 = string2.substring(1, string2.length() - 1);
        }
        return string3;
    }

    DecryptionContext createDecryptionContext(SignatureContext signatureContext) {
        DecryptionContext decryptionContext = new DecryptionContext();
        decryptionContext.setAlgorithmFactory(signatureContext.getAlgorithmFactory());
        decryptionContext.setEncryptedKeyRetriever(signatureContext.getEncryptedKeyRetriever());
        decryptionContext.setEntityResolver(signatureContext.getEntityResolver());
        decryptionContext.setIdResolver(signatureContext.getIDResolver());
        decryptionContext.setKeyInfoResolver(signatureContext.getKeyInfoResolver());
        return decryptionContext;
    }

    public void setParameter(OMNode oMNode) {
        block4: for (OMNode oMNode2 = oMNode; oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
            switch (oMNode2.getType()) {
                case 1: {
                    OMElement oMElement = (OMElement)oMNode2;
                    if (!Except.isOfType(oMElement)) continue block4;
                    Except except = new Except(oMElement);
                    this.fParameters.add(except);
                    continue block4;
                }
                case 9: {
                    this.setParameter(((OMContainer)((Object)oMNode2)).getFirstOMChild());
                }
            }
        }
    }

    public OMElement createTransformElement(OMFactory oMFactory) {
        OMElement oMElement = super.createTransformElement(oMFactory);
        Iterator iterator = this.fParameters.iterator();
        while (iterator.hasNext()) {
            try {
                OMElement oMElement2 = ((Except)iterator.next()).createElement(oMFactory, true);
                oMElement.addChild(oMElement2);
            }
            catch (StructureException structureException) {
                throw new RuntimeException(structureException.getMessage());
            }
        }
        return oMElement;
    }
}

