/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wssecurity.core.SignatureEngine;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ProcessKey;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceValidity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ValidityDOM;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class XSignature {
    private static final TraceComponent tc = Tr.register(XSignature.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    static final boolean DEBUG = false;
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String TYPE_MANIFEST = "http://www.w3.org/2000/09/xmldsig#Manifest";
    public static final String TYPE_OBJECT = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final QName ALGO_Q = new QName("", "Algorithm");
    public static final QName ID_Q = new QName("", "Id");
    public static long signTime = 0L;
    public static long canonicalizeTime = 0L;

    private XSignature() {
    }

    static final OMElement getFirstChild(OMNode oMNode, String string) {
        return DOMUtil.getFirstChildElementNamed(oMNode, XMLDSIG_NAMESPACE, string);
    }

    static final boolean isDsigElement(OMElement oMElement) {
        String string;
        String string2 = string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
        if (string == null) {
            return false;
        }
        return string.equals(XMLDSIG_NAMESPACE);
    }

    static final boolean isDsigElement(OMElement oMElement, String string) {
        String string2;
        String string3 = string2 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
        if (string2 == null) {
            return false;
        }
        return string2.equals(XMLDSIG_NAMESPACE) && oMElement.getLocalName().equals(string);
    }

    static byte[] getSignedInfoOctets(SignatureContext signatureContext, OMElement oMElement) throws SignatureStructureException, NoSuchAlgorithmException, IOException {
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "CanonicalizationMethod");
        if (oMElement2 == null) {
            throw new SignatureStructureException("No CanonicalizationMethod element.  This implementation always requires a CanonicalizationMethod.");
        }
        String string = oMElement2.getAttributeValue(ALGO_Q);
        if (string == null || string.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the CanonicalizationMethod element.");
        }
        AlgorithmFactory algorithmFactory = signatureContext.getAlgorithmFactory();
        Canonicalizer canonicalizer = algorithmFactory.getCanonicalizer(string);
        if (canonicalizer == null) {
            throw new NoSuchAlgorithmException("No canonicalization algorithm: " + string);
        }
        canonicalizer.setParameter(DOMUtil.getFirstChildElement(oMElement2));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long l = System.currentTimeMillis();
        canonicalizer.canonicalize(oMElement, byteArrayOutputStream);
        canonicalizeTime += System.currentTimeMillis() - l;
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (signatureContext.getResourceShower() != null) {
            signatureContext.getResourceShower().showSignedResource(signatureContext.getOwnerElement(), -1, "_SignedInfo_", null, byArray, null);
        }
        return byArray;
    }

    static SignatureEngine getSignatureEngine(OMElement oMElement, AlgorithmFactory algorithmFactory) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "SignatureMethod");
        if (oMElement2 == null) {
            throw new SignatureStructureException("No SignatureMethod element.");
        }
        String string = oMElement2.getAttributeValue(ALGO_Q);
        if (string == null || string.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the SignatureMethod element.");
        }
        AlgorithmParameterSpec algorithmParameterSpec = algorithmFactory.unmarshalParameter(string, oMElement2);
        SignatureEngine signatureEngine = algorithmFactory.getSignatureEngine(string);
        signatureEngine.setParameter(algorithmParameterSpec);
        return signatureEngine;
    }

    public static void resetDigestTime() {
        ReferenceProcessor.digestTime = 0L;
    }

    public static long getDigestTime() {
        return ReferenceProcessor.digestTime;
    }

    static void calculateSignatureValue(OMElement oMElement, SignatureEngine signatureEngine, Key key, byte[] byArray) throws SignatureStructureException, InvalidKeyException, SignatureException {
        long l = System.currentTimeMillis();
        signatureEngine.initSign(key);
        signatureEngine.update(byArray);
        byte[] byArray2 = signatureEngine.sign();
        signTime += System.currentTimeMillis() - l;
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "SignatureValue");
        if (oMElement2 == null) {
            throw new SignatureStructureException("No SignatureValue element.");
        }
        DOMUtil.removeAllChildren(oMElement2);
        String string = Base64.encode(byArray2);
        OMNode oMNode = oMElement2.getPreviousOMSibling();
        if (oMNode != null && oMNode.getType() == 4) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = (((OMText)oMNode).getText().length() - 1) * 2;
            stringBuffer.append(Base64.format(string, n, "\n", ""));
            for (int i = 0; i < n / 2; ++i) {
                stringBuffer.append(" ");
            }
            string = new String(stringBuffer);
        }
        DOMUtil.appendText(oMElement2, string);
    }

    static boolean verifySignatureValue(OMElement oMElement, SignatureEngine signatureEngine, Key key, byte[] byArray) throws SignatureStructureException, InvalidKeyException, SignatureException {
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "SignatureValue");
        if (oMElement2 == null) {
            throw new SignatureStructureException("No SignatureValue element.");
        }
        byte[] byArray2 = Base64.decode(DOMUtil.getStringValue(oMElement2));
        signatureEngine.initVerify(key);
        signatureEngine.update(byArray);
        boolean bl = signatureEngine.verify(byArray2);
        return bl;
    }

    static OMElement internalSign(SignatureContext signatureContext, Key key) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, SignatureException, TransformException, IOException {
        Object object;
        OMNode oMNode;
        OMElement oMElement = signatureContext.getSignatureElement();
        IDResolverWrapper iDResolverWrapper = null;
        if (signatureContext.getUseInternalIDResolver()) {
            iDResolverWrapper = new IDResolverWrapper(DOMUtil.getOwnerDocument(oMElement), signatureContext.getIDResolver());
            oMNode = DOMUtil.getFirstChild2(oMElement);
            while (oMNode != null) {
                OMElement oMElement2;
                if (oMNode.getType() == 1 && XSignature.isDsigElement(oMElement2 = (OMElement)oMNode) && XSignature.isDsigElement(oMElement2, "Object") && (object = oMElement2.getAttributeValue(ID_Q)) != null && ((String)object).length() != 0) {
                    iDResolverWrapper.registerID((String)object, oMElement2);
                }
                oMNode = DOMUtil.getNextSibling2(oMNode);
            }
            signatureContext.setWrappedIDResolver(iDResolverWrapper);
        }
        if ((oMNode = DOMUtil.getFirstChildElement(oMElement)) == null) {
            throw new SignatureStructureException("No SignedInfo element.");
        }
        int n = 0;
        object = XSignature.getFirstChild(oMNode, "Reference");
        while (object != null) {
            if (!XSignature.isDsigElement((OMElement)object, "Reference")) {
                throw new SignatureStructureException("A Reference element is expected: " + object.getLocalName());
            }
            ReferenceProcessor.substDigest(signatureContext, (OMElement)object, n++);
            object = DOMUtil.getNextElement((OMNode)object);
        }
        object = XSignature.getSignedInfoOctets(signatureContext, (OMElement)oMNode);
        if (key != null) {
            AlgorithmFactory algorithmFactory = signatureContext.getAlgorithmFactory();
            SignatureEngine signatureEngine = XSignature.getSignatureEngine((OMElement)oMNode, algorithmFactory);
            try {
                XSignature.calculateSignatureValue(oMElement, signatureEngine, key, (byte[])object);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (signatureContext.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    XSignature.calculateSignatureValue(oMElement, signatureEngine, key, (byte[])object);
                }
                throw outOfMemoryError;
            }
            algorithmFactory.releaseSignatureEngine(signatureEngine);
        }
        return oMElement;
    }

    static Validity internalVerify(SignatureContext signatureContext, Key object) {
        OMElement oMElement = signatureContext.getSignatureElement();
        IDResolverWrapper iDResolverWrapper = null;
        if (signatureContext.getUseInternalIDResolver()) {
            iDResolverWrapper = new IDResolverWrapper(DOMUtil.getOwnerDocument(oMElement), signatureContext.getIDResolver());
        }
        ValidityDOM validityDOM = new ValidityDOM();
        try {
            Object object2;
            Object object3 = DOMUtil.getFirstChild2(oMElement);
            while (object3 != null) {
                if (object3.getType() == 1 && XSignature.isDsigElement((OMElement)(object2 = (OMElement)object3))) {
                    String string;
                    if (XSignature.isDsigElement((OMElement)object2, "KeyInfo")) {
                        if (object == null) {
                            object = ProcessKey.processKeyInfo(signatureContext, (OMElement)object2);
                        }
                    } else if (XSignature.isDsigElement((OMElement)object2, "Object") && iDResolverWrapper != null && (string = object2.getAttributeValue(ID_Q)) != null && string.length() != 0) {
                        iDResolverWrapper.registerID(string, (OMElement)object2);
                    }
                }
                object3 = DOMUtil.getNextSibling2((OMNode)object3);
            }
            if (object == null) {
                throw new SignatureStructureException("No KeyInfo element.");
            }
            if (signatureContext.isHWAccelerationProvider() && (object2 = (PublicKey)((HWKeyCache)(object3 = HWKeyCache.getInstance())).translate((Key)object)) != null) {
                object = object2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key translated by HWCache");
                }
            }
            signatureContext.setWrappedIDResolver(iDResolverWrapper);
            XSignature.verify2(signatureContext, validityDOM, (Key)object);
        }
        catch (SignatureStructureException signatureStructureException) {
            validityDOM.setSignedInfoMessage(signatureStructureException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            validityDOM.setSignedInfoMessage(noSuchAlgorithmException.getMessage());
        }
        catch (CertificateException certificateException) {
            validityDOM.setSignedInfoMessage(certificateException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            validityDOM.setSignedInfoMessage(invalidKeySpecException.getMessage());
        }
        catch (IOException iOException) {
            validityDOM.setSignedInfoMessage(iOException.getMessage());
        }
        catch (TransformException transformException) {
            validityDOM.setSignedInfoMessage(transformException.getMessage());
        }
        catch (Exception exception) {
            validityDOM.setSignedInfoMessage(exception.getMessage());
        }
        validityDOM.setCoreValidity();
        return validityDOM;
    }

    private static void verify2(SignatureContext signatureContext, Verifier verifier, Key key) {
        boolean bl = false;
        try {
            Object object;
            OMElement oMElement = signatureContext.getSignatureElement();
            OMElement oMElement2 = DOMUtil.getFirstChildElement(oMElement);
            if (oMElement2 == null) {
                throw new SignatureStructureException("No SignedInfo element.");
            }
            int n = 0;
            Object object2 = XSignature.getFirstChild(oMElement2, "Reference");
            while (object2 != null) {
                if (!XSignature.isDsigElement((OMElement)object2, "Reference")) {
                    throw new SignatureStructureException("A Reference element is expected: " + object2.getQName());
                }
                object = ReferenceProcessor.verify(signatureContext, (OMElement)object2, n++);
                verifier.addReferenceValidity((ReferenceValidity)object);
                object2 = DOMUtil.getNextElement((OMNode)object2);
            }
            object2 = signatureContext.getAlgorithmFactory();
            object = XSignature.getSignedInfoOctets(signatureContext, oMElement2);
            SignatureEngine signatureEngine = XSignature.getSignatureEngine(oMElement2, (AlgorithmFactory)object2);
            try {
                bl = XSignature.verifySignatureValue(oMElement, signatureEngine, key, object);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (signatureContext.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    object = XSignature.getSignedInfoOctets(signatureContext, oMElement2);
                    bl = XSignature.verifySignatureValue(oMElement, signatureEngine, key, object);
                }
                throw outOfMemoryError;
            }
            ((AlgorithmFactory)object2).releaseSignatureEngine(signatureEngine);
            if (!bl) {
                verifier.setSignedInfoMessage("SignatureValue mismatched.");
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.close();
            verifier.setSignedInfoMessage(stringWriter.toString());
        }
        verifier.setSignedInfoValidity(bl);
    }

    static class IDResolverWrapper
    implements IDResolver {
        IDResolver next;
        Hashtable hash;
        OMDocument doc;

        IDResolverWrapper(OMDocument oMDocument, IDResolver iDResolver) {
            this.doc = oMDocument;
            this.next = iDResolver;
            this.hash = null;
        }

        void registerID(String string, OMElement oMElement) {
            if (this.hash == null) {
                this.hash = new Hashtable();
            }
            this.hash.put(string, oMElement);
        }

        public OMElement resolveID(OMDocument oMDocument, String string) {
            OMElement oMElement = null;
            if (oMDocument == this.doc && this.hash != null && (oMElement = (OMElement)this.hash.get(string)) != null) {
                return oMElement;
            }
            if (this.next == null) {
                return null;
            }
            return this.next.resolveID(oMDocument, string);
        }
    }

    static interface Verifier {
        public void addReferenceValidity(ReferenceValidity var1);

        public void setSignedInfoMessage(String var1);

        public void setSignedInfoValidity(boolean var1);
    }
}

