/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfoGenerator;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Reference;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class TemplateGenerator
implements IndentConfig {
    Vector objects;
    String defaultDigestAlgorithm;
    String c11r;
    String signatureMethod;
    AlgorithmParameterSpec signatureSpec;
    KeyInfoGenerator keyGen;
    OMFactory factory;
    OMElement signedInfoElement;
    OMElement manifestElement;
    OMElement signatureElement;
    String prefix = "ds";
    private static QName ID_Q = new QName("", "Id");
    boolean doIndent = false;
    int indentUnit = 2;

    public TemplateGenerator() {
    }

    public TemplateGenerator(OMFactory oMFactory, String string, String string2, String string3) {
        this();
        this.setDocument(oMFactory);
        this.setDefaultDigestMethod(string);
        this.setCanonicalizer(string2);
        this.setSignatureMethod(string3);
    }

    public TemplateGenerator(OMFactory oMFactory, String string, String string2, String string3, KeyInfoGenerator keyInfoGenerator) {
        this();
        this.setDocument(oMFactory);
        this.setDefaultDigestMethod(string);
        this.setCanonicalizer(string2);
        this.setSignatureMethod(string3);
        this.setKeyInfoGenerator(keyInfoGenerator);
    }

    public void setDefaultDigestMethod(String string) {
        this.defaultDigestAlgorithm = string;
    }

    public Reference createReference(String string) {
        Reference reference = new Reference(this, string, null);
        reference.setDigestMethod(this.defaultDigestAlgorithm);
        return reference;
    }

    public Reference createReference(OMElement oMElement) {
        String string = oMElement.getAttributeValue(ID_Q);
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("This Object element has no Id attribute.");
        }
        Reference reference = new Reference(this, "#" + string, oMElement);
        reference.setDigestMethod(this.defaultDigestAlgorithm);
        return reference;
    }

    public Reference createReference(OMElement oMElement, String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("This Object element has no Id attribute.");
        }
        Reference reference = new Reference(this, "#" + string, oMElement);
        reference.setDigestMethod(this.defaultDigestAlgorithm);
        return reference;
    }

    public OMElement wrapWithObject(OMNode oMNode, String string) {
        OMElement oMElement = this.createElementNS("Object", "dsig");
        TemplateGenerator.fixupNamespace(oMElement);
        oMElement.declareNamespace(oMNode.getOMFactory().createOMNamespace("", ""));
        oMElement.addAttribute("Id", string, null);
        oMElement.addChild(oMNode);
        return oMElement;
    }

    public void addReference(Reference reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        if (this.objects == null) {
            this.objects = new Vector();
        }
        this.objects.addElement(reference);
    }

    public void removeAllReferences() {
        if (this.objects != null) {
            this.objects.removeAllElements();
        }
    }

    public void setCanonicalizer(String string) {
        this.c11r = string;
    }

    public void setSignatureMethod(String string) {
        this.signatureMethod = string;
    }

    public void setSignatureMethodParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        this.signatureSpec = algorithmParameterSpec;
    }

    public void setKeyInfoGenerator(KeyInfoGenerator keyInfoGenerator) {
        this.keyGen = keyInfoGenerator;
    }

    public void setDocument(OMFactory oMFactory) {
        this.factory = oMFactory;
    }

    public OMFactory getDocument() {
        return this.factory;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setIndentation(boolean bl) {
        this.doIndent = bl;
    }

    public boolean doIndentation() {
        return this.doIndent;
    }

    public void setUnit(int n) {
        this.indentUnit = n;
    }

    public int getUnit() {
        return this.indentUnit;
    }

    public synchronized OMElement getSignedInfoElement() {
        try {
            return this.getSignedInfoElement(null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Internal Error: " + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("Internal Error: " + noSuchProviderException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Internal Error: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    public synchronized OMElement getSignedInfoElement(AlgorithmFactory algorithmFactory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (this.signedInfoElement != null) {
            return this.signedInfoElement;
        }
        this.signatureElement = this.createElementNS("Signature");
        TemplateGenerator.fixupNamespace(this.signatureElement);
        DOMUtil.addIndent(this.signatureElement, this, 1);
        this.signedInfoElement = this.createElementNS("SignedInfo");
        this.signatureElement.addChild(this.signedInfoElement);
        OMElement oMElement = this.signedInfoElement;
        DOMUtil.addIndent(oMElement, this, 2);
        if (this.c11r == null) {
            throw new RuntimeException("You must specify a CanonicalizationMethod in this implementation.");
        }
        OMElement oMElement2 = this.createElementNS("CanonicalizationMethod");
        oMElement2.addAttribute("Algorithm", this.c11r, null);
        oMElement.addChild(oMElement2);
        DOMUtil.addIndent(oMElement, this, 2);
        if (this.signatureMethod == null) {
            throw new RuntimeException("You must specify a SignatureMethod.");
        }
        OMElement oMElement3 = this.createElementNS("SignatureMethod");
        oMElement3.addAttribute("Algorithm", this.signatureMethod, null);
        oMElement.addChild(oMElement3);
        if (algorithmFactory != null && this.signatureSpec != null) {
            algorithmFactory.marshalParameter(this.signatureMethod, this.signatureSpec, oMElement3);
        }
        DOMUtil.addIndent(oMElement, this, 2);
        if (this.objects == null || this.objects.size() == 0) {
            throw new RuntimeException("No resources are registered.");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            Reference reference = (Reference)this.objects.elementAt(i);
            OMElement oMElement4 = reference.getReferenceElement(this);
            oMElement.addChild(oMElement4);
            DOMUtil.addIndent(oMElement, this, i == this.objects.size() - 1 ? 1 : 2);
        }
        return oMElement;
    }

    public synchronized OMElement getManifestElement() {
        if (this.manifestElement != null) {
            return this.manifestElement;
        }
        this.manifestElement = this.createElementNS("Manifest");
        TemplateGenerator.fixupNamespace(this.manifestElement);
        DOMUtil.addIndent(this.manifestElement, this, 2);
        if (this.objects == null || this.objects.size() == 0) {
            throw new RuntimeException("No resources are registered.");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            Reference reference = (Reference)this.objects.elementAt(i);
            OMElement oMElement = reference.getReferenceElement(this);
            this.manifestElement.addChild(oMElement);
            DOMUtil.addIndent(this.manifestElement, this, i == this.objects.size() - 1 ? 1 : 2);
        }
        return this.manifestElement;
    }

    public synchronized OMElement getSignatureElement() {
        try {
            return this.getSignatureElement(null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Internal Error: " + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("Internal Error: " + noSuchProviderException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Internal Error: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    public synchronized OMElement getSignatureElement(AlgorithmFactory algorithmFactory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (this.signatureElement != null) {
            return this.signatureElement;
        }
        this.getSignedInfoElement(algorithmFactory);
        OMElement oMElement = this.signatureElement;
        DOMUtil.addIndent(oMElement, this, 1);
        oMElement.addChild(this.createElementNS("SignatureValue"));
        if (this.keyGen != null) {
            DOMUtil.addIndent(oMElement, this, 1);
            oMElement.addChild(this.keyGen.getKeyInfoElement(this.factory));
        }
        Vector<OMElement> vector = new Vector<OMElement>(this.objects.size());
        for (int i = 0; i < this.objects.size(); ++i) {
            OMElement oMElement2;
            Reference reference = (Reference)this.objects.elementAt(i);
            if (!reference.isEnvelopedObject() || TemplateGenerator.contains(vector, oMElement2 = reference.getObjectElement())) continue;
            vector.addElement(oMElement2);
            DOMUtil.addIndent(oMElement, this, 1);
            oMElement.addChild(oMElement2);
        }
        DOMUtil.addIndent(oMElement, this, 0);
        return oMElement;
    }

    private static boolean contains(Vector vector, Object object) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) != object) continue;
            return true;
        }
        return false;
    }

    final OMElement createElementNS(String string) {
        return this.factory.createOMElement(string, "http://www.w3.org/2000/09/xmldsig#", this.prefix);
    }

    final OMElement createElementNS(String string, String string2) {
        return this.factory.createOMElement(string, "http://www.w3.org/2000/09/xmldsig#", string2);
    }

    private static void fixupNamespace(OMElement oMElement) {
        oMElement.declareNamespace(oMElement.getNamespace());
    }
}

