/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.core.SignatureEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureEngineRSA
implements SignatureEngine {
    private Signature signature;
    private String uri;

    public SignatureEngineRSA(String string, Provider provider) throws NoSuchAlgorithmException {
        this.signature = provider == null ? Signature.getInstance("SHA1withRSA") : Signature.getInstance("SHA1withRSA", provider);
        this.uri = string;
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("This algorithm supports  no AlgorithmParameterSpec.");
        }
    }

    public String getURI() {
        return this.uri;
    }

    public void initSign(Key key) throws InvalidKeyException {
        this.signature.initSign((PrivateKey)key);
    }

    public void initVerify(Key key) throws InvalidKeyException {
        this.signature.initVerify((PublicKey)key);
    }

    public void update(byte[] byArray) throws SignatureException {
        this.signature.update(byArray);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.signature.update(byArray, n, n2);
    }

    public byte[] sign() throws SignatureException {
        return this.signature.sign();
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        return this.signature.verify(byArray);
    }
}

