/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.core.SignatureEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureEngineDSA
implements SignatureEngine {
    private Signature signature;
    private String uri;

    public SignatureEngineDSA(String string, Provider provider) throws NoSuchAlgorithmException {
        this.signature = provider == null ? Signature.getInstance("SHA1withDSA") : Signature.getInstance("SHA1withDSA", provider);
        this.uri = string;
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("This algorithm supports  no AlgorithmParameterSpec.");
        }
    }

    public String getURI() {
        return this.uri;
    }

    public void initSign(Key key) throws InvalidKeyException {
        this.signature.initSign((PrivateKey)key);
    }

    public void initVerify(Key key) throws InvalidKeyException {
        this.signature.initVerify((PublicKey)key);
    }

    public void update(byte[] byArray) throws SignatureException {
        this.signature.update(byArray);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.signature.update(byArray, n, n2);
    }

    public byte[] sign() throws SignatureException {
        return SignatureEngineDSA.decodeRSfromASN1(this.signature.sign());
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        return this.signature.verify(SignatureEngineDSA.encodeRSinASN1(byArray));
    }

    private static byte[] encodeRSinASN1(byte[] byArray) throws SignatureException {
        if (byArray.length != 40) {
            throw new SignatureException("Invalid DSA signature value size: " + byArray.length);
        }
        int n = byArray.length / 2;
        int n2 = byArray[0] < 0 ? 21 : 20;
        int n3 = byArray[n] < 0 ? 21 : 20;
        byte[] byArray2 = new byte[n2 + n3 + 6];
        byArray2[0] = 48;
        byArray2[1] = (byte)(n2 + n3 + 4);
        byArray2[2] = 2;
        byArray2[3] = (byte)n2;
        if (byArray[0] < 0) {
            byArray2[4] = 0;
            System.arraycopy(byArray, 0, byArray2, 5, 20);
        } else {
            System.arraycopy(byArray, 0, byArray2, 4, 20);
        }
        byArray2[4 + n2] = 2;
        byArray2[5 + n2] = (byte)n3;
        if (byArray[n] < 0) {
            byArray2[6 + n2] = 0;
            System.arraycopy(byArray, n, byArray2, 7 + n2, byArray.length - n);
        } else {
            System.arraycopy(byArray, n, byArray2, 6 + n2, byArray.length - n);
        }
        return byArray2;
    }

    private static byte[] decodeRSfromASN1(byte[] byArray) {
        int n;
        byte by = byArray[3];
        byte by2 = byArray[4 + by + 1];
        byte[] byArray2 = new byte[40];
        if (by < 20) {
            for (n = 0; n < 20 - by; ++n) {
                byArray2[n] = 0;
            }
            System.arraycopy(byArray, 4, byArray2, 20 - by, by);
        } else {
            System.arraycopy(byArray, 4 + by - 20, byArray2, 0, 20);
        }
        if (by2 < 20) {
            for (n = 0; n < 20 - by2; ++n) {
                byArray2[20 + n] = 0;
            }
            System.arraycopy(byArray, 4 + by + 2, byArray2, 40 - by2, by2);
        } else {
            System.arraycopy(byArray, 4 + by + 2 + by2 - 20, byArray2, 20, 20);
        }
        return byArray2;
    }
}

