/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfoGenerator;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ManifestProcessor;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.NullURIHandler;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ProcessKey;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignature;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.XPathUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.Key;
import java.security.Provider;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SignatureContext {
    private EncryptedKeyRetriever encryptedKeyRetriever = null;
    private KeyInfoResolver keyInfoResolver = null;
    EntityResolver entityResolver = null;
    IDResolver idResolver = null;
    AlgorithmFactory aFactory = null;
    ResourceShower shower = null;
    NullURIHandler nullHandler = null;
    boolean useInternalIDResolver = true;
    IDResolver wrappedIDResolver = null;
    boolean verifyManifest = false;
    OMElement signature;
    OMElement owner;
    Map _context = null;
    private String _hwKeyStoreName;
    private String _hwConfigName;
    private String sigAlgorithm = null;
    private Boolean _offload = Boolean.TRUE;
    private Provider hwAccelerationProvider = null;
    private Provider hwKeyStoreProvider = null;
    private static QName TYPE_Q = new QName("", "Type");

    public SignatureContext() {
        this.aFactory = AlgorithmFactory.getInstance();
    }

    public Provider getHWAccelerationProvider() {
        return this.hwAccelerationProvider;
    }

    public Provider getHWKeyStoreProvider() {
        return this.hwKeyStoreProvider;
    }

    public void setHWAccelerationProvider(Provider provider) {
        if (this.shouldChangeProvider()) {
            this.hwAccelerationProvider = provider;
        }
    }

    public void setHWKeyStoreProvider(Provider provider) {
        this.hwKeyStoreProvider = provider;
    }

    public boolean isHWAccelerationProvider() {
        return this.hwAccelerationProvider != null;
    }

    public boolean isHWKeyStoreProvider() {
        return this.hwKeyStoreProvider != null;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setSigAlgorithm(String string) {
        this.sigAlgorithm = string;
    }

    public String getSigAlgorithm() {
        return this.sigAlgorithm;
    }

    public void setHWKeyStoreName(String string) {
        this._hwKeyStoreName = string;
    }

    public String getHWKeyStoreName() {
        return this._hwKeyStoreName;
    }

    public void setHWConfigName(String string) {
        this._hwConfigName = string;
    }

    public void setOffload(Boolean bl) {
        this._offload = bl;
    }

    public String getHWConfigName() {
        return this._hwConfigName;
    }

    public boolean shouldChangeProvider() {
        return this._hwConfigName != null && this._hwConfigName.length() > 0 && HWKeyCache.isHWSigAlgorithm(this.sigAlgorithm) && this._offload != false;
    }

    public boolean useHWKeyStore() {
        return this._hwKeyStoreName != null && this._hwKeyStoreName.length() > 0;
    }

    public IDResolver getIDResolver() {
        return this.idResolver;
    }

    public void setIDResolver(IDResolver iDResolver) {
        this.idResolver = iDResolver;
    }

    void setWrappedIDResolver(IDResolver iDResolver) {
        this.wrappedIDResolver = iDResolver;
    }

    IDResolver getIDResolver0() {
        return this.wrappedIDResolver != null ? this.wrappedIDResolver : this.idResolver;
    }

    public EncryptedKeyRetriever getEncryptedKeyRetriever() {
        return this.encryptedKeyRetriever;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever encryptedKeyRetriever) {
        this.encryptedKeyRetriever = encryptedKeyRetriever;
    }

    public KeyInfoResolver getKeyInfoResolver() {
        return this.keyInfoResolver;
    }

    public void setKeyInfoResolver(KeyInfoResolver keyInfoResolver) {
        this.keyInfoResolver = keyInfoResolver;
    }

    public AlgorithmFactory getAlgorithmFactory() {
        return this.aFactory;
    }

    public void setAlgorithmFactory(AlgorithmFactory algorithmFactory) {
        this.aFactory = algorithmFactory;
    }

    public ResourceShower getResourceShower() {
        return this.shower;
    }

    public void setResourceShower(ResourceShower resourceShower) {
        this.shower = resourceShower;
    }

    public NullURIHandler getNullURIHandler() {
        return this.nullHandler;
    }

    public void setNullURIHandler(NullURIHandler nullURIHandler) {
        this.nullHandler = nullURIHandler;
    }

    public boolean getUseInternalIDResolver() {
        return this.useInternalIDResolver;
    }

    public void setUseInternalIDResolver(boolean bl) {
        this.useInternalIDResolver = bl;
    }

    OMElement getSignatureElement() {
        return this.signature;
    }

    OMElement setSignatureElement(OMElement oMElement) {
        OMElement oMElement2 = this.signature;
        this.signature = oMElement;
        return oMElement2;
    }

    OMElement getOwnerElement() {
        return this.owner;
    }

    OMElement setOwnerElement(OMElement oMElement) {
        OMElement oMElement2 = this.owner;
        this.owner = oMElement;
        return oMElement2;
    }

    public OMElement sign(OMElement oMElement, Key key) throws XSignatureException {
        Object object;
        this.signature = oMElement;
        this.owner = oMElement;
        if (this.isHWAccelerationProvider()) {
            object = HWKeyCache.getInstance();
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            try {
                key = ((HWKeyCache)object).translate(key);
            }
            catch (Exception exception) {
                throw new XSignatureException(exception);
            }
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            object = XSignature.internalSign(this, key);
            return object;
        }
        catch (Exception exception) {
            System.out.println("HARDWARE: Signature signing with HW crypto provider failed, Continue using software provider");
            try {
                OMElement oMElement2 = XSignature.internalSign(this, key);
                return oMElement2;
            }
            catch (Exception exception2) {
                throw new XSignatureException(exception2);
            }
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Validity verify(OMElement oMElement, Key key) {
        this.signature = oMElement;
        this.owner = oMElement;
        Validity validity = null;
        if (this.isHWAccelerationProvider()) {
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            validity = XSignature.internalVerify(this, key);
        }
        catch (Exception exception) {
            if (!this.isHWKeyStoreProvider() && this.isHWAccelerationProvider()) {
                this.aFactory.clearLocalProviderMap();
                System.out.println("HARDWARE: signature verification with HW crypto provider failed, Continue using software provider");
                validity = XSignature.internalVerify(this, key);
            }
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
        return validity;
    }

    public OMElement digestManifest(OMElement oMElement) throws XSignatureException {
        this.signature = null;
        this.owner = oMElement;
        if (this.isHWAccelerationProvider()) {
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            OMElement oMElement2 = ManifestProcessor.digest(this);
            return oMElement2;
        }
        catch (Exception exception) {
            System.out.println("HARDWARE: Digest with HW crypto provider failed, Continue using software provider");
            try {
                OMElement oMElement3 = ManifestProcessor.digest(this);
                return oMElement3;
            }
            catch (Exception exception2) {
                throw new XSignatureException(exception2);
            }
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
    }

    public Validity verifyManifest(OMElement oMElement) throws Exception {
        this.signature = null;
        this.owner = oMElement;
        if (this.isHWAccelerationProvider()) {
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            Validity validity = ManifestProcessor.verify(this);
            return validity;
        }
        catch (Exception exception) {
            System.out.println("HARDWARE: Verify with HW crypto provider failed, Continue using software provider");
            Validity validity = ManifestProcessor.verify(this);
            return validity;
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
    }

    public static void setKeyInfo(OMElement oMElement, KeyInfoGenerator keyInfoGenerator) throws SignatureStructureException {
        ProcessKey.setKeyInfo(oMElement, keyInfoGenerator);
    }

    protected OMDocument parse(InputSource inputSource) throws IOException, SAXException, XMLStreamException {
        Object object;
        XMLStreamReader xMLStreamReader = null;
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            xMLStreamReader = StAXUtils.createXMLStreamReader(inputStream);
        } else {
            object = inputSource.getCharacterStream();
            xMLStreamReader = StAXUtils.createXMLStreamReader((Reader)object);
        }
        object = new StAXOMBuilder(xMLStreamReader);
        OMDocument oMDocument = ((StAXBuilder)object).getDocument();
        XPathUtil.fixTree(oMDocument.getOMDocumentElement());
        return oMDocument;
    }

    private OMDocument parse(byte[] byArray) throws IOException, TransformException {
        try {
            return this.parse(new InputSource(new ByteArrayInputStream(byArray)));
        }
        catch (SAXException sAXException) {
            throw TransformException.create(sAXException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw TransformException.create(xMLStreamException);
        }
    }

    private OMElement parseWithConfirmingRoot(byte[] byArray, String string) throws SignatureStructureException, IOException, TransformException {
        OMDocument oMDocument = this.parse(byArray);
        OMElement oMElement = oMDocument.getOMDocumentElement();
        if (!XSignature.isDsigElement(oMElement, string)) {
            throw new SignatureStructureException("Type mismatch: Type=" + string + ", root=" + oMElement.getQName());
        }
        return oMElement;
    }

    public Object retrieve(OMElement oMElement) throws XSignatureException {
        try {
            byte[] byArray;
            this.signature = null;
            this.owner = oMElement;
            Object object = byArray = ReferenceProcessor.getTransformedOctets(this, DOMUtil.getOwnerDocument(oMElement), oMElement, -1);
            OMAttribute oMAttribute = oMElement.getAttribute(TYPE_Q);
            if (oMAttribute == null) {
                return object;
            }
            String string = oMAttribute.getAttributeValue();
            if (string.equals("http://www.w3.org/2000/09/xmldsig#X509Data")) {
                OMElement oMElement2 = this.parseWithConfirmingRoot(byArray, "X509Data");
                object = new KeyInfo.X509Data(oMElement2);
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#PGPData")) {
                OMElement oMElement3 = this.parseWithConfirmingRoot(byArray, "PGPData");
                object = new KeyInfo.PGPData(oMElement3);
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#SPKIData")) {
                OMElement oMElement4 = this.parseWithConfirmingRoot(byArray, "SPKIData");
                object = new KeyInfo.SPKIData(oMElement4);
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#MgmtData")) {
                OMElement oMElement5 = this.parseWithConfirmingRoot(byArray, "MgmgtData");
                object = DOMUtil.getStringValue(oMElement5);
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                object = x509Certificate;
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#DSAKeyValue")) {
                OMElement oMElement6 = this.parseWithConfirmingRoot(byArray, "DSAKeyValue");
                object = ProcessKey.createDSAKey(oMElement6);
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#RSAKeyValue")) {
                OMElement oMElement7 = this.parseWithConfirmingRoot(byArray, "RSAKeyValue");
                object = ProcessKey.createRSAKey(oMElement7);
            } else if (string.equals("http://www.w3.org/2001/04/xmlenc#EncryptedKey")) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(byteArrayInputStream);
                OMElement oMElement8 = stAXOMBuilder.getDocumentElement();
                object = new EncryptedKey(oMElement8);
            }
            return object;
        }
        catch (Exception exception) {
            throw new XSignatureException(exception);
        }
    }

    public Map getContext() {
        return this._context;
    }

    public void setContext(Map map) {
        this._context = map;
    }

    public boolean isDebug() {
        return false;
    }
}

